/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.apis;

import dan200.computercraft.api.filesystem.IMount;
import dan200.computercraft.api.filesystem.IWritableMount;
import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.ILuaAPI;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.peripheral.IDynamicPeripheral;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.peripheral.IWorkMonitor;
import dan200.computercraft.api.peripheral.NotAttachedException;
import dan200.computercraft.core.apis.ComputerAccess;
import dan200.computercraft.core.apis.FastLuaException;
import dan200.computercraft.core.apis.IAPIEnvironment;
import dan200.computercraft.core.asm.LuaMethod;
import dan200.computercraft.core.asm.NamedMethod;
import dan200.computercraft.core.asm.PeripheralMethod;
import dan200.computercraft.core.computer.ComputerSide;
import dan200.computercraft.core.tracking.TrackingField;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PeripheralAPI
implements ILuaAPI,
IAPIEnvironment.IPeripheralChangeListener {
    private final IAPIEnvironment environment;
    private final PeripheralWrapper[] peripherals = new PeripheralWrapper[6];
    private boolean running;

    public PeripheralAPI(IAPIEnvironment environment) {
        this.environment = environment;
        this.environment.setPeripheralChangeListener(this);
        this.running = false;
    }

    public static Map<String, PeripheralMethod> getMethods(IPeripheral peripheral) {
        String[] dynamicMethods = peripheral instanceof IDynamicPeripheral ? Objects.requireNonNull(((IDynamicPeripheral)peripheral).getMethodNames(), "Peripheral methods cannot be null") : LuaMethod.EMPTY_METHODS;
        List<NamedMethod<PeripheralMethod>> methods = PeripheralMethod.GENERATOR.getMethods(peripheral.getClass());
        HashMap<String, PeripheralMethod> methodMap = new HashMap<String, PeripheralMethod>(methods.size() + dynamicMethods.length);
        for (int i = 0; i < dynamicMethods.length; ++i) {
            methodMap.put(dynamicMethods[i], PeripheralMethod.DYNAMIC.get(i));
        }
        for (NamedMethod<PeripheralMethod> method : methods) {
            methodMap.put(method.getName(), method.getMethod());
        }
        return methodMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onPeripheralChanged(ComputerSide side, IPeripheral newPeripheral) {
        PeripheralWrapper[] peripheralWrapperArray = this.peripherals;
        synchronized (this.peripherals) {
            PeripheralWrapper wrapper;
            int index = side.ordinal();
            if (this.peripherals[index] != null) {
                wrapper = this.peripherals[index];
                if (wrapper.isAttached()) {
                    wrapper.detach();
                }
                this.environment.queueEvent("peripheral_detach", side.getName());
            }
            PeripheralWrapper peripheralWrapper = this.peripherals[index] = newPeripheral == null ? null : new PeripheralWrapper(newPeripheral, side.getName());
            if (this.peripherals[index] != null) {
                wrapper = this.peripherals[index];
                if (this.running && !wrapper.isAttached()) {
                    wrapper.attach();
                }
                this.environment.queueEvent("peripheral", side.getName());
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    @Override
    public String[] getNames() {
        return new String[]{"peripheral"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startup() {
        PeripheralWrapper[] peripheralWrapperArray = this.peripherals;
        synchronized (this.peripherals) {
            this.running = true;
            for (int i = 0; i < 6; ++i) {
                PeripheralWrapper wrapper = this.peripherals[i];
                if (wrapper == null || wrapper.isAttached()) continue;
                wrapper.attach();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        PeripheralWrapper[] peripheralWrapperArray = this.peripherals;
        synchronized (this.peripherals) {
            this.running = false;
            for (int i = 0; i < 6; ++i) {
                PeripheralWrapper wrapper = this.peripherals[i];
                if (wrapper == null || !wrapper.isAttached()) continue;
                wrapper.detach();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @LuaFunction
    public final boolean isPresent(String sideName) {
        ComputerSide side = ComputerSide.valueOfInsensitive(sideName);
        if (side == null) return false;
        PeripheralWrapper[] peripheralWrapperArray = this.peripherals;
        synchronized (this.peripherals) {
            PeripheralWrapper p = this.peripherals[side.ordinal()];
            if (p == null) return false;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LuaFunction
    public final Object[] getType(String sideName) {
        ComputerSide side = ComputerSide.valueOfInsensitive(sideName);
        if (side == null) {
            return null;
        }
        PeripheralWrapper[] peripheralWrapperArray = this.peripherals;
        synchronized (this.peripherals) {
            PeripheralWrapper p = this.peripherals[side.ordinal()];
            if (p != null) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return new Object[]{p.getType()};
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LuaFunction
    public final Object[] getMethods(String sideName) {
        ComputerSide side = ComputerSide.valueOfInsensitive(sideName);
        if (side == null) {
            return null;
        }
        PeripheralWrapper[] peripheralWrapperArray = this.peripherals;
        synchronized (this.peripherals) {
            PeripheralWrapper p = this.peripherals[side.ordinal()];
            if (p != null) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return new Object[]{p.getMethods()};
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LuaFunction
    public final MethodResult call(ILuaContext context, IArguments args) throws LuaException {
        ComputerSide side = ComputerSide.valueOfInsensitive(args.getString(0));
        String methodName = args.getString(1);
        IArguments methodArgs = args.drop(2);
        if (side == null) {
            throw new LuaException("No peripheral attached");
        }
        PeripheralWrapper[] peripheralWrapperArray = this.peripherals;
        synchronized (this.peripherals) {
            PeripheralWrapper p = this.peripherals[side.ordinal()];
            // ** MonitorExit[var7_6] (shouldn't be in output)
            if (p == null) {
                throw new LuaException("No peripheral attached");
            }
            try {
                return p.call(context, methodName, methodArgs).adjustError(1);
            }
            catch (LuaException e) {
                if (e.getLevel() > 0) {
                    throw new FastLuaException(e.getMessage(), e.getLevel() + 1);
                }
                throw e;
            }
        }
    }

    private class PeripheralWrapper
    extends ComputerAccess {
        private final String side;
        private final IPeripheral peripheral;
        private final String type;
        private final Map<String, PeripheralMethod> methodMap;
        private boolean attached;

        PeripheralWrapper(IPeripheral peripheral, String side) {
            super(PeripheralAPI.this.environment);
            this.side = side;
            this.peripheral = peripheral;
            this.attached = false;
            this.type = Objects.requireNonNull(peripheral.getType(), "Peripheral type cannot be null");
            this.methodMap = PeripheralAPI.getMethods(peripheral);
        }

        public IPeripheral getPeripheral() {
            return this.peripheral;
        }

        public String getType() {
            return this.type;
        }

        public Collection<String> getMethods() {
            return this.methodMap.keySet();
        }

        public synchronized boolean isAttached() {
            return this.attached;
        }

        public synchronized void attach() {
            this.attached = true;
            this.peripheral.attach(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void detach() {
            this.peripheral.detach(this);
            PeripheralWrapper peripheralWrapper = this;
            synchronized (peripheralWrapper) {
                this.unmountAll();
            }
            this.attached = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public MethodResult call(ILuaContext context, String methodName, IArguments arguments) throws LuaException {
            PeripheralMethod method;
            PeripheralWrapper peripheralWrapper = this;
            synchronized (peripheralWrapper) {
                method = this.methodMap.get(methodName);
            }
            if (method == null) {
                throw new LuaException("No such method " + methodName);
            }
            PeripheralAPI.this.environment.addTrackingChange(TrackingField.PERIPHERAL_OPS);
            return method.apply(this.peripheral, context, this, arguments);
        }

        @Override
        public synchronized String mount(@Nonnull String desiredLoc, @Nonnull IMount mount, @Nonnull String driveName) {
            if (!this.attached) {
                throw new NotAttachedException();
            }
            return super.mount(desiredLoc, mount, driveName);
        }

        @Override
        public synchronized String mountWritable(@Nonnull String desiredLoc, @Nonnull IWritableMount mount, @Nonnull String driveName) {
            if (!this.attached) {
                throw new NotAttachedException();
            }
            return super.mountWritable(desiredLoc, mount, driveName);
        }

        @Override
        public synchronized void unmount(String location) {
            if (!this.attached) {
                throw new NotAttachedException();
            }
            super.unmount(location);
        }

        @Override
        public int getID() {
            if (!this.attached) {
                throw new NotAttachedException();
            }
            return super.getID();
        }

        @Override
        public void queueEvent(@Nonnull String event, Object ... arguments) {
            if (!this.attached) {
                throw new NotAttachedException();
            }
            super.queueEvent(event, arguments);
        }

        @Override
        @Nonnull
        public String getAttachmentName() {
            if (!this.attached) {
                throw new NotAttachedException();
            }
            return this.side;
        }

        @Override
        @Nonnull
        public Map<String, IPeripheral> getAvailablePeripherals() {
            if (!this.attached) {
                throw new NotAttachedException();
            }
            HashMap<String, IPeripheral> peripherals = new HashMap<String, IPeripheral>();
            for (PeripheralWrapper wrapper : PeripheralAPI.this.peripherals) {
                if (wrapper == null || !wrapper.isAttached()) continue;
                peripherals.put(wrapper.getAttachmentName(), wrapper.getPeripheral());
            }
            return Collections.unmodifiableMap(peripherals);
        }

        @Override
        @Nullable
        public IPeripheral getAvailablePeripheral(@Nonnull String name) {
            if (!this.attached) {
                throw new NotAttachedException();
            }
            for (PeripheralWrapper wrapper : PeripheralAPI.this.peripherals) {
                if (wrapper == null || !wrapper.isAttached() || !wrapper.getAttachmentName().equals(name)) continue;
                return wrapper.getPeripheral();
            }
            return null;
        }

        @Override
        @Nonnull
        public IWorkMonitor getMainThreadMonitor() {
            if (!this.attached) {
                throw new NotAttachedException();
            }
            return super.getMainThreadMonitor();
        }
    }
}

