/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.apis.http.options;

import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.InMemoryCommentedFormat;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import dan200.computercraft.ComputerCraft;
import dan200.computercraft.core.apis.http.options.Action;
import dan200.computercraft.core.apis.http.options.AddressRule;
import dan200.computercraft.core.apis.http.options.PartialOptions;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;

public class AddressRuleConfig {
    public static UnmodifiableConfig makeRule(String host, Action action) {
        Config config = InMemoryCommentedFormat.defaultInstance().createConfig(ConcurrentHashMap::new);
        config.add("host", (Object)host);
        config.add("action", (Object)action.name().toLowerCase(Locale.ROOT));
        if (host.equals("*") && action == Action.ALLOW) {
            config.setComment("timeout", "The period of time (in milliseconds) to wait before a HTTP request times out. Set to 0 for unlimited.");
            config.add("timeout", (Object)30000);
            config.setComment("max_download", "The maximum size (in bytes) that a computer can download in a single request. Note that responses may receive more data than allowed, but this data will not be returned to the client.");
            config.set("max_download", (Object)0x1000000L);
            config.setComment("max_upload", "The maximum size (in bytes) that a computer can upload in a single request. This includes headers and POST text.");
            config.set("max_upload", (Object)0x400000L);
            config.setComment("max_websocket_message", "The maximum size (in bytes) that a computer can send or receive in one websocket packet.");
            config.set("max_websocket_message", (Object)131072);
        }
        return config;
    }

    public static boolean checkRule(UnmodifiableConfig builder) {
        String hostObj = AddressRuleConfig.get(builder, "host", String.class).orElse(null);
        Integer port = AddressRuleConfig.get(builder, "port", Number.class).map(Number::intValue).orElse(null);
        return hostObj != null && AddressRuleConfig.checkEnum(builder, "action", Action.class) && AddressRuleConfig.check(builder, "port", Number.class) && AddressRuleConfig.check(builder, "timeout", Number.class) && AddressRuleConfig.check(builder, "max_upload", Number.class) && AddressRuleConfig.check(builder, "max_download", Number.class) && AddressRuleConfig.check(builder, "websocket_message", Number.class) && AddressRule.parse(hostObj, port, PartialOptions.DEFAULT) != null;
    }

    @Nullable
    public static AddressRule parseRule(UnmodifiableConfig builder) {
        String hostObj = AddressRuleConfig.get(builder, "host", String.class).orElse(null);
        if (hostObj == null) {
            return null;
        }
        Action action = AddressRuleConfig.getEnum(builder, "action", Action.class).orElse(null);
        Integer port = AddressRuleConfig.get(builder, "port", Number.class).map(Number::intValue).orElse(null);
        Integer timeout = AddressRuleConfig.get(builder, "timeout", Number.class).map(Number::intValue).orElse(null);
        Long maxUpload = AddressRuleConfig.get(builder, "max_upload", Number.class).map(Number::longValue).orElse(null);
        Long maxDownload = AddressRuleConfig.get(builder, "max_download", Number.class).map(Number::longValue).orElse(null);
        Integer websocketMessage = AddressRuleConfig.get(builder, "websocket_message", Number.class).map(Number::intValue).orElse(null);
        PartialOptions options = new PartialOptions(action, maxUpload, maxDownload, timeout, websocketMessage);
        return AddressRule.parse(hostObj, port, options);
    }

    private static <T> boolean check(UnmodifiableConfig config, String field, Class<T> klass) {
        Object value = config.get(field);
        if (value == null || klass.isInstance(value)) {
            return true;
        }
        ComputerCraft.log.warn("HTTP rule's {} is not a {}.", (Object)field, (Object)klass.getSimpleName());
        return false;
    }

    private static <T extends Enum<T>> boolean checkEnum(UnmodifiableConfig config, String field, Class<T> klass) {
        Object value = config.get(field);
        if (value == null) {
            return true;
        }
        if (!(value instanceof String)) {
            ComputerCraft.log.warn("HTTP rule's {} is not a string", (Object)field);
            return false;
        }
        if (AddressRuleConfig.parseEnum(klass, (String)value) == null) {
            ComputerCraft.log.warn("HTTP rule's {} is not a known option", (Object)field);
            return false;
        }
        return true;
    }

    private static <T> Optional<T> get(UnmodifiableConfig config, String field, Class<T> klass) {
        Object value = config.get(field);
        return klass.isInstance(value) ? Optional.of(klass.cast(value)) : Optional.empty();
    }

    private static <T extends Enum<T>> Optional<T> getEnum(UnmodifiableConfig config, String field, Class<T> klass) {
        return AddressRuleConfig.get(config, field, String.class).map(x -> AddressRuleConfig.parseEnum(klass, x));
    }

    @Nullable
    private static <T extends Enum<T>> T parseEnum(Class<T> klass, String x) {
        for (Enum value : (Enum[])klass.getEnumConstants()) {
            if (!value.name().equalsIgnoreCase(x)) continue;
            return (T)value;
        }
        return null;
    }
}

