/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.tracking;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.LongFunction;

public final class TrackingField {
    private static final Map<String, TrackingField> fields = new HashMap<String, TrackingField>();
    public static final TrackingField TASKS = TrackingField.of("tasks", x -> String.format("%4d", x));
    public static final TrackingField TOTAL_TIME = TrackingField.of("total", x -> String.format("%7.1fms", (double)x / 1000000.0));
    public static final TrackingField AVERAGE_TIME = TrackingField.of("average", x -> String.format("%4.1fms", (double)x / 1000000.0));
    public static final TrackingField MAX_TIME = TrackingField.of("max", x -> String.format("%5.1fms", (double)x / 1000000.0));
    public static final TrackingField SERVER_COUNT = TrackingField.of("server_count", x -> String.format("%4d", x));
    public static final TrackingField SERVER_TIME = TrackingField.of("server_time", x -> String.format("%7.1fms", (double)x / 1000000.0));
    public static final TrackingField PERIPHERAL_OPS = TrackingField.of("peripheral", TrackingField::formatDefault);
    public static final TrackingField FS_OPS = TrackingField.of("fs", TrackingField::formatDefault);
    public static final TrackingField TURTLE_OPS = TrackingField.of("turtle", TrackingField::formatDefault);
    public static final TrackingField HTTP_REQUESTS = TrackingField.of("http", TrackingField::formatDefault);
    public static final TrackingField COROUTINES_CREATED = TrackingField.of("coroutines_created", x -> String.format("%4d", x));
    public static final TrackingField COROUTINES_DISPOSED = TrackingField.of("coroutines_dead", x -> String.format("%4d", x));
    private static final int KILOBYTE_SIZE = 1024;
    private static final String SI_PREFIXES = "KMGT";
    public static final TrackingField HTTP_UPLOAD = TrackingField.of("http_upload", TrackingField::formatBytes);
    public static final TrackingField HTTP_DOWNLOAD = TrackingField.of("http_download", TrackingField::formatBytes);
    public static final TrackingField WEBSOCKET_INCOMING = TrackingField.of("websocket_incoming", TrackingField::formatBytes);
    public static final TrackingField WEBSOCKET_OUTGOING = TrackingField.of("websocket_outgoing", TrackingField::formatBytes);
    private final String id;
    private final String translationKey;
    private final LongFunction<String> format;

    private TrackingField(String id, LongFunction<String> format) {
        this.id = id;
        this.translationKey = "tracking_field.computercraft." + id + ".name";
        this.format = format;
    }

    public static TrackingField of(String id, LongFunction<String> format) {
        TrackingField field = new TrackingField(id, format);
        fields.put(id, field);
        return field;
    }

    public static Map<String, TrackingField> fields() {
        return Collections.unmodifiableMap(fields);
    }

    private static String formatDefault(long value) {
        return String.format("%6d", value);
    }

    private static String formatBytes(long bytes) {
        if (bytes < 1024L) {
            return String.format("%10d B", bytes);
        }
        int exp = (int)(Math.log(bytes) / Math.log(1024.0));
        if (exp > SI_PREFIXES.length()) {
            exp = SI_PREFIXES.length();
        }
        return String.format("%10.1f %siB", (double)bytes / Math.pow(1024.0, exp), Character.valueOf(SI_PREFIXES.charAt(exp - 1)));
    }

    public String id() {
        return this.id;
    }

    public String translationKey() {
        return this.translationKey;
    }

    public String format(long value) {
        return this.format.apply(value);
    }
}

