/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.fabric;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.lwjgl.glfw.GLFWScrollCallbackI;

public class GLFWMouseManager {
    private static GLFWMouseManager instance;
    private final Map<UUID, GLFWScrollCallbackI> scrollObservers = new HashMap<UUID, GLFWScrollCallbackI>();

    private GLFWMouseManager() {
    }

    public static synchronized GLFWMouseManager getInstance() {
        if (instance == null) {
            instance = new GLFWMouseManager();
        }
        return instance;
    }

    public UUID addScrollObserver(GLFWScrollCallbackI observer) {
        UUID id = UUID.randomUUID();
        this.scrollObservers.put(id, observer);
        return id;
    }

    public void removeScrollObserver(UUID id) {
        this.scrollObservers.remove(id);
    }

    public void notifyScrollObservers(long window, double xoffset, double yoffset) {
        this.scrollObservers.values().forEach(observer -> observer.invoke(window, xoffset, yoffset));
    }
}

