/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.fabric.mixin;

import com.llamalad7.mixinextras.sugar.Local;
import dan200.computercraft.shared.common.ComputerCraftBlocks;
import dan200.computercraft.shared.common.ComputerCraftItems;
import dan200.computercraft.shared.media.items.ItemDisk;
import dan200.computercraft.shared.pocket.items.ItemPocketComputer;
import dan200.computercraft.shared.turtle.items.ItemBlockTurtle;
import java.util.List;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.player.inventory.menu.MenuInventoryCreative;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={MenuInventoryCreative.class}, remap=false)
public class MenuInventoryCreativeMixin {
    @Shadow
    public static List<ItemStack> creativeItems;
    @Shadow
    public static int creativeItemsCount;
    @Unique
    private static int extraCount;

    @Inject(method={"<clinit>"}, at={@At(value="INVOKE", target="Lnet/minecraft/core/block/Block;hasTag(Lnet/minecraft/core/data/tag/Tag;)Z")})
    private static void addBlocks(CallbackInfo ci, @Local(name={"id"}) int i) {
        Block block = Blocks.blocksList[i];
        if (block == null) {
            return;
        }
        if (block.id() == ComputerCraftBlocks.TURTLE_NORMAL.id() || block.id() == ComputerCraftBlocks.TURTLE_ADVANCED.id()) {
            int before = creativeItems.size();
            ((ItemBlockTurtle)block.asItem()).addToCreativeMenu(creativeItems);
            extraCount += creativeItems.size() - before;
        }
    }

    @Inject(method={"<clinit>"}, at={@At(value="INVOKE", target="Lnet/minecraft/core/item/Item;hasTag(Lnet/minecraft/core/data/tag/Tag;)Z", shift=At.Shift.AFTER)})
    private static void addItems(CallbackInfo ci, @Local(name={"i"}) int i) {
        int before;
        Item item = Item.itemsList[i];
        if (item == null) {
            return;
        }
        if (item.id == ComputerCraftItems.POCKET_COMPUTER_NORMAL.id || item.id == ComputerCraftItems.POCKET_COMPUTER_ADVANCED.id) {
            before = creativeItems.size();
            ((ItemPocketComputer)item).addToCreativeMenu(creativeItems);
            extraCount += creativeItems.size() - before;
        }
        if (item.id == ComputerCraftItems.DISK.id) {
            before = creativeItems.size();
            ((ItemDisk)item).addToCreativeMenu(creativeItems);
            extraCount += creativeItems.size() - before;
        }
    }

    @Inject(method={"<clinit>"}, at={@At(value="FIELD", target="Lnet/minecraft/core/player/inventory/menu/MenuInventoryCreative;creativeItemsCount:I", shift=At.Shift.AFTER)})
    private static void addUpItemCount(CallbackInfo ci) {
        creativeItemsCount += extraCount;
    }

    static {
        extraCount = 0;
    }
}

