/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared;

import dan200.computercraft.api.pocket.IPocketUpgrade;
import dan200.computercraft.shared.common.ComputerCraftPocketUpgrades;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.core.item.ItemStack;

public final class PocketUpgrades {
    private static final Map<Integer, IPocketUpgrade> upgrades = new HashMap<Integer, IPocketUpgrade>();

    private PocketUpgrades() {
    }

    public static synchronized void register(@Nonnull IPocketUpgrade upgrade) {
        Objects.requireNonNull(upgrade, "upgrade cannot be null");
        int id = upgrade.getUpgradeID();
        IPocketUpgrade existing = upgrades.get(id);
        if (existing != null) {
            throw new IllegalStateException("Error registering '" + upgrade.getUnlocalisedAdjective() + " pocket computer'. UpgradeID '" + id + "' is already registered by '" + existing.getUnlocalisedAdjective() + " pocket computer'");
        }
        upgrades.put(id, upgrade);
    }

    public static IPocketUpgrade get(int id) {
        return upgrades.get(id);
    }

    public static IPocketUpgrade get(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        for (IPocketUpgrade upgrade : upgrades.values()) {
            ItemStack craftingStack = upgrade.getCraftingItem();
            if (craftingStack == null || !craftingStack.getItem().equals(stack.getItem()) || !upgrade.isItemSuitable(stack)) continue;
            return upgrade;
        }
        return null;
    }

    public static Iterable<IPocketUpgrade> getVanillaUpgrades() {
        ArrayList<IPocketUpgrade> vanilla = new ArrayList<IPocketUpgrade>();
        vanilla.add(ComputerCraftPocketUpgrades.wirelessModemNormal);
        vanilla.add(ComputerCraftPocketUpgrades.wirelessModemAdvanced);
        vanilla.add(ComputerCraftPocketUpgrades.speaker);
        return vanilla;
    }

    public static Iterable<IPocketUpgrade> getUpgrades() {
        return Collections.unmodifiableCollection(upgrades.values());
    }
}

