/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared;

import dan200.computercraft.ComputerCraft;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.shared.common.ComputerCraftTurtleUpgrades;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import java.util.Arrays;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.item.ItemStack;

public final class TurtleUpgrades {
    private static final Map<Integer, ITurtleUpgrade> upgrades = new HashMap<Integer, ITurtleUpgrade>();
    private static final IdentityHashMap<ITurtleUpgrade, Wrapper> wrappers = new IdentityHashMap();
    private static ITurtleUpgrade[] vanilla;
    private static boolean needsRebuild;

    private TurtleUpgrades() {
    }

    public static void register(@Nonnull ITurtleUpgrade upgrade) {
        Objects.requireNonNull(upgrade, "upgrade cannot be null");
        TurtleUpgrades.rebuild();
        Wrapper wrapper = new Wrapper(upgrade);
        int id = wrapper.id;
        ITurtleUpgrade existing = upgrades.get(id);
        if (existing != null) {
            throw new IllegalStateException("Error registering '" + upgrade.getUnlocalisedAdjective() + " Turtle'. Upgrade ID '" + id + "' is already registered by '" + existing.getUnlocalisedAdjective() + " Turtle'");
        }
        upgrades.put(id, upgrade);
        wrappers.put(upgrade, wrapper);
    }

    @Nullable
    public static ITurtleUpgrade get(int id) {
        TurtleUpgrades.rebuild();
        return upgrades.get(id);
    }

    @Nullable
    public static String getOwner(@Nonnull ITurtleUpgrade upgrade) {
        Wrapper wrapper = wrappers.get(upgrade);
        return wrapper != null ? wrapper.modId : null;
    }

    public static ITurtleUpgrade get(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        for (Wrapper wrapper : wrappers.values()) {
            ItemStack craftingStack;
            if (!wrapper.enabled || (craftingStack = wrapper.upgrade.getCraftingItem()) == null || !craftingStack.getItem().equals(stack.getItem()) || !wrapper.upgrade.isItemSuitable(stack)) continue;
            return wrapper.upgrade;
        }
        return null;
    }

    public static Stream<ITurtleUpgrade> getVanillaUpgrades() {
        if (vanilla == null) {
            vanilla = new ITurtleUpgrade[]{ComputerCraftTurtleUpgrades.wirelessModemNormal, ComputerCraftTurtleUpgrades.wirelessModemAdvanced, ComputerCraftTurtleUpgrades.speaker, ComputerCraftTurtleUpgrades.diamondPickaxe, ComputerCraftTurtleUpgrades.diamondAxe, ComputerCraftTurtleUpgrades.diamondSword, ComputerCraftTurtleUpgrades.diamondShovel, ComputerCraftTurtleUpgrades.diamondHoe, ComputerCraftTurtleUpgrades.craftingTable, ComputerCraftTurtleUpgrades.goldenPickaxe};
        }
        return Arrays.stream(vanilla).filter(x -> {
            if (x == null) {
                return false;
            }
            Wrapper wrapper = wrappers.get(x);
            if (wrapper == null) {
                return true;
            }
            return wrapper.enabled;
        });
    }

    public static Stream<ITurtleUpgrade> getUpgrades() {
        return wrappers.values().stream().filter(x -> x.enabled).map(x -> x.upgrade);
    }

    public static boolean suitableForFamily(ComputerFamily family, ITurtleUpgrade upgrade) {
        return true;
    }

    private static void rebuild() {
        if (!needsRebuild) {
            return;
        }
        upgrades.clear();
        for (Wrapper wrapper : wrappers.values()) {
            if (!wrapper.enabled) continue;
            ITurtleUpgrade existing = upgrades.get(wrapper.id);
            if (existing != null) {
                ComputerCraft.log.error("Error registering '" + wrapper.upgrade.getUnlocalisedAdjective() + " Turtle'. Upgrade ID '" + wrapper.id + "' is already registered by '" + existing.getUnlocalisedAdjective() + " Turtle'");
                continue;
            }
            upgrades.put(wrapper.id, wrapper.upgrade);
        }
        needsRebuild = false;
    }

    public static void enable(ITurtleUpgrade upgrade) {
        Wrapper wrapper = wrappers.get(upgrade);
        if (wrapper.enabled) {
            return;
        }
        wrapper.enabled = true;
        needsRebuild = true;
    }

    public static void disable(ITurtleUpgrade upgrade) {
        Wrapper wrapper = wrappers.get(upgrade);
        if (!wrapper.enabled) {
            return;
        }
        wrapper.enabled = false;
        upgrades.remove(wrapper.id);
    }

    public static void remove(ITurtleUpgrade upgrade) {
        wrappers.remove(upgrade);
        needsRebuild = true;
    }

    private static class Wrapper {
        final ITurtleUpgrade upgrade;
        final int id;
        final String modId;
        boolean enabled;

        Wrapper(ITurtleUpgrade upgrade) {
            this.upgrade = upgrade;
            this.id = upgrade.getUpgradeID();
            this.modId = "computercraft";
            this.enabled = true;
        }
    }
}

