/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.common;

import com.mojang.nbt.tags.CompoundTag;
import dan200.computercraft.core.terminal.Terminal;
import dan200.computercraft.shared.common.ITerminal;
import dan200.computercraft.shared.network.client.TerminalState;

public class ClientTerminal
implements ITerminal {
    private boolean colour;
    private Terminal terminal;
    private boolean terminalChanged;

    public ClientTerminal(boolean colour) {
        this.colour = colour;
        this.terminal = null;
        this.terminalChanged = false;
    }

    public boolean pollTerminalChanged() {
        boolean changed = this.terminalChanged;
        this.terminalChanged = false;
        return changed;
    }

    @Override
    public Terminal getTerminal() {
        return this.terminal;
    }

    @Override
    public boolean isColour() {
        return this.colour;
    }

    public void read(TerminalState state) {
        this.colour = state.colour;
        if (state.hasTerminal()) {
            this.resizeTerminal(state.width, state.height);
            state.apply(this.terminal);
            this.terminal.setSelectedSlot(state.selectedSlot);
        } else {
            this.deleteTerminal();
        }
    }

    private void resizeTerminal(int width, int height) {
        if (this.terminal == null) {
            this.terminal = new Terminal(width, height, () -> {
                this.terminalChanged = true;
            });
            this.terminalChanged = true;
        } else {
            this.terminal.resize(width, height);
        }
    }

    private void deleteTerminal() {
        if (this.terminal != null) {
            this.terminal = null;
            this.terminalChanged = true;
        }
    }

    public void readDescription(CompoundTag nbt) {
        this.colour = nbt.getBoolean("colour");
        if (nbt.containsKey("terminal")) {
            CompoundTag terminal = nbt.getCompound("terminal");
            this.resizeTerminal(terminal.getInteger("term_width"), terminal.getInteger("term_height"));
            this.terminal.readFromNBT(terminal);
        } else {
            this.deleteTerminal();
        }
    }
}

