/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.common;

import com.mojang.nbt.tags.CompoundTag;
import java.util.Map;
import net.minecraft.core.item.ItemStack;

public interface IColouredItem {
    public static final String NBT_COLOUR = "Color";

    public static int getColourBasic(ItemStack stack) {
        CompoundTag tag = stack.getData();
        return tag.containsKey(NBT_COLOUR) ? tag.getInteger(NBT_COLOUR) : -1;
    }

    public static void setColourBasic(ItemStack stack, int colour) {
        if (colour == -1) {
            CompoundTag tag = stack.getData();
            ((Map)tag.getValue()).remove(NBT_COLOUR);
        } else {
            stack.getData().putInt(NBT_COLOUR, colour);
        }
    }

    default public int getColour(ItemStack stack) {
        return IColouredItem.getColourBasic(stack);
    }

    default public ItemStack withColour(ItemStack stack, int colour) {
        ItemStack copy = stack.copy();
        IColouredItem.setColourBasic(copy, colour);
        return copy;
    }
}

