/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.computer.blocks;

import com.mojang.nbt.tags.CompoundTag;
import dan200.computercraft.ComputerCraft;
import dan200.computercraft.core.computer.ComputerSide;
import dan200.computercraft.shared.common.IBundledRedstoneBlock;
import dan200.computercraft.shared.computer.blocks.TileComputerBase;
import dan200.computercraft.shared.computer.blocks.TileEntityComputer;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.computer.items.ComputerItemFactory;
import dan200.computercraft.shared.util.BlockPos;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicRotatable;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.tool.ItemToolShears;
import net.minecraft.core.player.gamemode.Gamemode;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;
import org.jetbrains.annotations.Nullable;

public class BlockLogicComputer
extends BlockLogicRotatable
implements IBundledRedstoneBlock {
    public BlockLogicComputer(Block<?> block, ComputerFamily family) {
        super(block, Material.stone);
        block.withEntity(() -> new TileEntityComputer(family));
    }

    @Nullable
    protected ItemStack getItemStack(TileEntity entity) {
        if (!(entity instanceof TileComputerBase)) {
            return null;
        }
        return ComputerItemFactory.create((TileComputerBase)entity);
    }

    public ItemStack[] getBreakResult(World world, EnumDropCause dropCause, int meta, TileEntity entity) {
        switch (dropCause) {
            case PICK_BLOCK: 
            case EXPLOSION: 
            case PROPER_TOOL: 
            case SILK_TOUCH: 
            case PISTON_CRUSH: {
                ItemStack item = this.getItemStack(entity);
                if (item == null) {
                    return null;
                }
                if (dropCause == EnumDropCause.PICK_BLOCK) {
                    item.setData(new CompoundTag());
                }
                return new ItemStack[]{item};
            }
        }
        ComputerCraft.log.info("{}", (Object)dropCause);
        return null;
    }

    public void harvestBlock(World world, Player player, int x, int y, int z, int meta, TileEntity tileEntity) {
        Item heldItem;
        player.addStat(this.block.getStat("stat_mined"), 1);
        ItemStack heldItemStack = player.inventory.getCurrentItem();
        Item item = heldItem = heldItemStack != null ? Item.itemsList[heldItemStack.itemID] : null;
        if (heldItem != null) {
            if (heldItem.isSilkTouch() && player.canHarvestBlock(this.block)) {
                this.dropBlockWithCause(world, EnumDropCause.SILK_TOUCH, x, y, z, meta, tileEntity, player);
                return;
            }
            if (heldItem instanceof ItemToolShears && (this.block.hasTag(BlockTags.SHEARS_DO_SILK_TOUCH) || this.block.hasTag(BlockTags.MINEABLE_BY_SHEARS))) {
                ItemToolShears heldShears = (ItemToolShears)heldItem;
                this.dropBlockWithCause(world, EnumDropCause.SILK_TOUCH, x, y, z, meta, tileEntity, player);
                heldShears.onBlockSheared((Mob)player, heldItemStack);
                return;
            }
        }
        if (tileEntity instanceof TileComputerBase) {
            TileComputerBase computerEntity = (TileComputerBase)tileEntity;
            if (player.getGamemode() == Gamemode.creative && computerEntity.getComputerID() == -1) {
                return;
            }
        }
        if (player.canHarvestBlock(this.block) || player.getGamemode() == Gamemode.creative) {
            this.dropBlockWithCause(world, EnumDropCause.PROPER_TOOL, x, y, z, meta, tileEntity, player);
        } else {
            this.dropBlockWithCause(world, EnumDropCause.IMPROPER_TOOL, x, y, z, meta, tileEntity, player);
        }
    }

    public void onBlockRemoved(World world, int x, int y, int z, int data) {
        TileEntity entity = world.getTileEntity(x, y, z);
        if (!(entity instanceof TileComputerBase)) {
            return;
        }
        TileComputerBase computerEntity = (TileComputerBase)entity;
        computerEntity.destroy();
    }

    public boolean isSignalSource() {
        return true;
    }

    public boolean getDirectSignal(World world, int x, int y, int z, Side side) {
        return this.getSignal((WorldSource)world, x, y, z, side);
    }

    public boolean getSignal(WorldSource world, int x, int y, int z, Side side) {
        TileEntity entity = world.getTileEntity(x, y, z);
        if (!(entity instanceof TileComputerBase)) {
            return false;
        }
        TileComputerBase computerEntity = (TileComputerBase)entity;
        ServerComputer computer = computerEntity.getServerComputer();
        if (computer == null) {
            return false;
        }
        ComputerSide localSide = computerEntity.remapToLocalSide(side.getOpposite().getDirection());
        return computer.getRedstoneOutput(localSide) > 0;
    }

    @Override
    public boolean getBundledRedstoneConnectivity(World world, BlockPos pos, Direction side) {
        return true;
    }

    @Override
    public int getBundledRedstoneOutput(World world, BlockPos pos, Direction side) {
        TileEntity entity = world.getTileEntity(pos.x, pos.y, pos.z);
        if (!(entity instanceof TileComputerBase)) {
            return 0;
        }
        TileComputerBase computerEntity = (TileComputerBase)entity;
        ServerComputer computer = computerEntity.getServerComputer();
        if (computer == null) {
            return 0;
        }
        ComputerSide localSide = computerEntity.remapToLocalSide(side);
        return computer.getBundledRedstoneOutput(localSide);
    }

    public boolean onBlockRightClicked(World world, int x, int y, int z, Player player, Side side, double xPlaced, double yPlaced) {
        return ((TileComputerBase)world.getTileEntity(x, y, z)).onBlockRightClicked(player, side, xPlaced, yPlaced);
    }

    public void onNeighborBlockChange(World world, int x, int y, int z, int blockId) {
        TileEntity entity = world.getTileEntity(x, y, z);
        if (!(entity instanceof TileComputerBase)) {
            return;
        }
        TileComputerBase computerEntity = (TileComputerBase)entity;
        computerEntity.onNeighbourChange(new BlockPos(x, y, z));
    }
}

