/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.computer.blocks;

import com.mojang.nbt.tags.CompoundTag;
import dan200.computercraft.ComputerCraft;
import dan200.computercraft.Peripherals;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.peripheral.IPeripheralTile;
import dan200.computercraft.core.computer.ComputerSide;
import dan200.computercraft.fabric.Helper;
import dan200.computercraft.fabric.IComputerPlayer;
import dan200.computercraft.shared.BundledRedstone;
import dan200.computercraft.shared.common.TileGeneric;
import dan200.computercraft.shared.computer.blocks.BlockLogicComputer;
import dan200.computercraft.shared.computer.blocks.ComputerPeripheral;
import dan200.computercraft.shared.computer.blocks.ComputerProxy;
import dan200.computercraft.shared.computer.blocks.IComputerTile;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.core.ComputerState;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.computer.inventory.ContainerComputer;
import dan200.computercraft.shared.util.BlockPos;
import dan200.computercraft.shared.util.DirectionUtil;
import dan200.computercraft.shared.util.PortableTickScheduler;
import dan200.computercraft.shared.util.RedstoneUtil;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;

public abstract class TileComputerBase
extends TileGeneric
implements IComputerTile,
IPeripheralTile {
    private static final String NBT_ID = "ComputerId";
    private static final String NBT_LABEL = "Label";
    private static final String NBT_ON = "On";
    private static final String NBT_FAMILY = "Family";
    protected String label = null;
    protected PortableTickScheduler portableTickScheduler = new PortableTickScheduler();
    boolean startOn = false;
    private ComputerFamily family;
    private int instanceID = -1;
    private int computerID = -1;
    private boolean on = false;
    private boolean fresh = false;

    public TileComputerBase(ComputerFamily family) {
        this.family = family;
    }

    public void destroy() {
        this.unload();
        for (Direction dir : DirectionUtil.FACINGS) {
            RedstoneUtil.propagateRedstoneOutput(this.worldObj, new BlockPos(this.x, this.y, this.z), dir);
        }
    }

    @Override
    public void onChunkUnloaded() {
        this.unload();
    }

    protected void unload() {
        if (this.instanceID >= 0) {
            if (!Helper.isServerEnvironment() && !Helper.isSinglePlayer()) {
                ComputerCraft.serverComputerRegistry.remove(this.instanceID);
            }
            this.instanceID = -1;
        }
    }

    public boolean onBlockRightClicked(Player player, Side side, double xPlaced, double yPlaced) {
        ItemStack currentItem = player.getHeldItem();
        if (currentItem != null && currentItem.getItem().equals(Items.LABEL) && this.canNameWithTag(player) && currentItem.hasCustomName()) {
            if (!Helper.isClientWorld()) {
                this.setLabel(currentItem.getCustomName());
                currentItem.consumeItem(player);
            }
            return true;
        }
        if (!player.isSneaking()) {
            if (!this.worldObj.isClientSide && this.isUsable(player, false)) {
                this.createServerComputer().turnOn();
                this.createServerComputer().sendTerminalState(player);
                ((IComputerPlayer)player).setCurrentContainerComputer(new ContainerComputer(this));
                this.createServerComputer().sendOpenComputerGui(player);
            }
            return true;
        }
        return true;
    }

    protected boolean canNameWithTag(Player player) {
        return true;
    }

    public ServerComputer createServerComputer() {
        if (!Helper.isServerEnvironment() && !Helper.isSinglePlayer()) {
            return null;
        }
        boolean changed = false;
        if (this.instanceID < 0) {
            this.instanceID = ComputerCraft.serverComputerRegistry.getUnusedInstanceID();
            changed = true;
        }
        if (!ComputerCraft.serverComputerRegistry.contains(this.instanceID)) {
            ServerComputer computer = this.createComputer(this.instanceID, this.computerID);
            ComputerCraft.serverComputerRegistry.add(this.instanceID, computer);
            this.fresh = true;
            changed = true;
        }
        if (changed) {
            this.updateBlock();
            this.updateRedstoneInput();
        }
        return (ServerComputer)ComputerCraft.serverComputerRegistry.get(this.instanceID);
    }

    public ServerComputer getServerComputer() {
        return !Helper.isServerEnvironment() && !Helper.isSinglePlayer() ? null : (ServerComputer)ComputerCraft.serverComputerRegistry.get(this.instanceID);
    }

    protected abstract ServerComputer createComputer(int var1, int var2);

    public void updateRedstoneInput() {
        if (this.worldObj == null || !Helper.isServerEnvironment() && !Helper.isSinglePlayer()) {
            return;
        }
        ServerComputer computer = this.getServerComputer();
        if (computer == null) {
            return;
        }
        BlockPos pos = computer.getPosition();
        for (Direction dir : DirectionUtil.FACINGS) {
            this.updateRedstoneSideInput(computer, dir, pos.offset(dir));
        }
    }

    public void updatePeripheral() {
        if (this.worldObj == null || !Helper.isServerEnvironment() && !Helper.isSinglePlayer()) {
            return;
        }
        ServerComputer computer = this.getServerComputer();
        if (computer == null) {
            return;
        }
        BlockPos pos = computer.getPosition();
        for (Direction dir : DirectionUtil.FACINGS) {
            this.updatePeripheralSide(computer, dir, pos.offset(dir));
        }
    }

    private void updateRedstoneSideInput(ServerComputer computer, Direction dir, BlockPos offset) {
        Direction offsetSide = dir.getOpposite();
        ComputerSide localDir = this.remapToLocalSide(dir);
        computer.setRedstoneInput(localDir, this.getRedstoneInput(offset, dir));
        computer.setBundledRedstoneInput(localDir, BundledRedstone.getOutput(this.worldObj, offset, offsetSide));
    }

    private void updatePeripheralSide(ServerComputer computer, Direction dir, BlockPos offset) {
        Direction offsetSide = dir.getOpposite();
        ComputerSide localDir = this.remapToLocalSide(dir);
        if (!this.isPeripheralBlockedOnSide(localDir)) {
            IPeripheral peripheral = Peripherals.getPeripheral(this.worldObj, offset, offsetSide);
            computer.setPeripheral(localDir, peripheral);
        }
    }

    protected ComputerSide remapToLocalSide(Direction globalSide) {
        return this.remapLocalSide(DirectionUtil.toLocal(this.getDirection(), globalSide));
    }

    private int getRedstoneInput(BlockPos pos, Direction direction) {
        return this.worldObj.getSignal(pos.x, pos.y, pos.z, direction.getSide()) ? 15 : 0;
    }

    protected boolean isPeripheralBlockedOnSide(ComputerSide localSide) {
        return false;
    }

    protected ComputerSide remapLocalSide(ComputerSide localSide) {
        return localSide;
    }

    protected abstract Direction getDirection();

    public void onNeighbourChange(@Nonnull BlockPos neighbour) {
        this.updateRedstoneInput(neighbour);
        if (Helper.isServerEnvironment() || Helper.isSinglePlayer()) {
            this.portableTickScheduler.scheduleOnNextStartTick(() -> this.updatePeripheral(neighbour));
        }
    }

    public void readDescription(@Nonnull CompoundTag nbt) {
        this.label = nbt.containsKey(NBT_LABEL) ? nbt.getString(NBT_LABEL) : null;
        this.computerID = nbt.containsKey(NBT_ID) ? nbt.getInteger(NBT_ID) : -1;
    }

    public void writeDescription(@Nonnull CompoundTag nbt) {
        if (this.label != null) {
            nbt.putString(NBT_LABEL, this.label);
        }
        if (this.computerID >= 0) {
            nbt.putInt(NBT_ID, this.computerID);
        }
    }

    public void tick() {
        this.portableTickScheduler.tickAtStart();
        if (Helper.isServerEnvironment() || Helper.isSinglePlayer()) {
            ServerComputer computer = this.createServerComputer();
            if (computer == null) {
                this.portableTickScheduler.tickAtEnd();
                return;
            }
            if (this.startOn || this.fresh && this.on) {
                computer.turnOn();
                this.startOn = false;
            }
            computer.unfreezeComputer();
            computer.keepAlive();
            this.fresh = false;
            this.computerID = computer.getID();
            this.label = computer.getLabel();
            this.on = computer.isOn();
            if (computer.hasOutputChanged()) {
                this.updateRedstoneOutput();
                this.portableTickScheduler.scheduleOnNextStartTick(this::updatePeripheral);
            }
            this.updateBlockState(computer.getState());
            if (computer.hasOutputChanged()) {
                this.updateRedstoneOutput();
                this.portableTickScheduler.scheduleOnNextStartTick(this::updatePeripheral);
            }
        }
        this.portableTickScheduler.tickAtEnd();
    }

    public void heldTick(World world, Entity holder) {
        if (Helper.isServerEnvironment() || Helper.isSinglePlayer()) {
            ServerComputer computer = this.createServerComputer();
            if (computer == null) {
                return;
            }
            computer.freezeComputer();
            computer.keepAlive();
        }
    }

    public void updateRedstoneOutput() {
        this.updateBlock();
        for (Direction dir : DirectionUtil.FACINGS) {
            RedstoneUtil.propagateRedstoneOutput(this.worldObj, new BlockPos(this.x, this.y, this.z), dir);
        }
    }

    public void updateBlock() {
        if (this.worldObj == null) {
            return;
        }
        int blockId = Helper.getBlockLogic(this.worldObj, this.x, this.y, this.z, BlockLogicComputer.class).id();
        this.worldObj.notifyBlockChange(this.x, this.y, this.z, blockId);
        if (Helper.isServerEnvironment()) {
            this.updateBlockServer();
        }
    }

    @Environment(value=EnvType.SERVER)
    protected void updateBlockServer() {
    }

    protected abstract void updateBlockState(ComputerState var1);

    public void readFromNBT(CompoundTag nbt) {
        super.readFromNBT(nbt);
        this.computerID = nbt.containsKey(NBT_ID) ? nbt.getInteger(NBT_ID) : -1;
        this.label = nbt.containsKey(NBT_LABEL) ? nbt.getString(NBT_LABEL) : null;
        this.on = this.startOn = nbt.getBoolean(NBT_ON);
        this.family = nbt.containsKey(NBT_FAMILY) ? ComputerFamily.values()[nbt.getInteger(NBT_FAMILY)] : ComputerFamily.NORMAL;
    }

    public void writeToNBT(CompoundTag nbt) {
        if (this.computerID >= 0) {
            nbt.putInt(NBT_ID, this.computerID);
        }
        if (this.label != null) {
            nbt.putString(NBT_LABEL, this.label);
        }
        nbt.putBoolean(NBT_ON, this.on);
        nbt.putInt(NBT_FAMILY, this.family.ordinal());
        super.writeToNBT(nbt);
    }

    private void updateRedstoneInput(BlockPos neighbour) {
        if (this.worldObj == null || !Helper.isServerEnvironment() && !Helper.isSinglePlayer()) {
            return;
        }
        ServerComputer computer = this.getServerComputer();
        if (computer == null) {
            return;
        }
        for (Direction dir : DirectionUtil.FACINGS) {
            BlockPos offset = new BlockPos(this.x, this.y, this.z).offset(dir);
            if (!offset.equals(neighbour)) continue;
            this.updateRedstoneSideInput(computer, dir, offset);
            return;
        }
        this.updateRedstoneInput();
    }

    private void updatePeripheral(BlockPos neighbour) {
        if (this.worldObj == null || !Helper.isServerEnvironment() && !Helper.isSinglePlayer()) {
            return;
        }
        ServerComputer computer = this.getServerComputer();
        if (computer == null) {
            return;
        }
        for (Direction dir : DirectionUtil.FACINGS) {
            BlockPos offset = new BlockPos(this.x, this.y, this.z).offset(dir);
            if (!offset.equals(neighbour)) continue;
            this.updatePeripheralSide(computer, dir, offset);
            return;
        }
        this.updatePeripheral();
    }

    private void updateRedstoneInput(Direction dir) {
        if (this.worldObj == null || !Helper.isServerEnvironment() && !Helper.isSinglePlayer()) {
            return;
        }
        ServerComputer computer = this.getServerComputer();
        if (computer == null) {
            return;
        }
        this.updateRedstoneSideInput(computer, dir, new BlockPos(this.x, this.y, this.z).offset(dir));
    }

    @Override
    public final int getComputerID() {
        return this.computerID;
    }

    @Override
    public final void setComputerID(int id) {
        if (!Helper.isSinglePlayer() && !Helper.isServerEnvironment() || this.computerID == id) {
            return;
        }
        this.computerID = id;
        ServerComputer computer = this.getServerComputer();
        if (computer != null) {
            computer.setID(this.computerID);
        }
        if (this.worldObj == null) {
            return;
        }
        this.worldObj.notifyBlockChange(this.x, this.y, this.z, this.getBlockId());
    }

    @Override
    public final String getLabel() {
        return this.label;
    }

    @Override
    public final void setLabel(String label) {
        if (!Helper.isSinglePlayer() && !Helper.isServerEnvironment() || Objects.equals(this.label, label)) {
            return;
        }
        this.label = label;
        ServerComputer computer = this.getServerComputer();
        if (computer != null) {
            computer.setLabel(label);
        }
        if (this.worldObj == null) {
            return;
        }
        this.worldObj.notifyBlockChange(this.x, this.y, this.z, this.getBlockId());
    }

    @Override
    public ComputerFamily getFamily() {
        return this.family;
    }

    @Override
    @Nonnull
    public IPeripheral getPeripheral(Direction side) {
        return new ComputerPeripheral("computer", this.createProxy());
    }

    public abstract ComputerProxy createProxy();
}

