/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.computer.core;

import dan200.computercraft.shared.computer.core.IComputer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;

public class ComputerRegistry<T extends IComputer> {
    private final Map<Integer, T> computers = new HashMap<Integer, T>();
    private int nextUnusedInstanceID;
    private int sessionID;

    protected ComputerRegistry() {
        this.reset();
    }

    public void reset() {
        this.computers.clear();
        this.nextUnusedInstanceID = 0;
        this.sessionID = new Random().nextInt();
    }

    public int getSessionID() {
        return this.sessionID;
    }

    public int getUnusedInstanceID() {
        return this.nextUnusedInstanceID++;
    }

    public Collection<T> getComputers() {
        return this.computers.values();
    }

    public T get(int instanceID) {
        if (instanceID >= 0 && this.computers.containsKey(instanceID)) {
            return (T)((IComputer)this.computers.get(instanceID));
        }
        return null;
    }

    public boolean contains(int instanceID) {
        return this.computers.containsKey(instanceID);
    }

    public void add(int instanceID, T computer) {
        if (this.computers.containsKey(instanceID)) {
            this.remove(instanceID);
        }
        this.computers.put(instanceID, computer);
        this.nextUnusedInstanceID = Math.max(this.nextUnusedInstanceID, instanceID + 1);
    }

    public void remove(int instanceID) {
        this.computers.remove(instanceID);
    }
}

