/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.computer.inventory;

import dan200.computercraft.ComputerCraft;
import dan200.computercraft.fabric.Helper;
import dan200.computercraft.shared.computer.core.ClientComputer;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.core.IComputer;
import dan200.computercraft.shared.computer.core.IContainerComputer;
import dan200.computercraft.shared.computer.core.InputState;
import dan200.computercraft.shared.computer.core.ServerComputer;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.entity.player.Player;

public class ContainerComputerBase
implements IContainerComputer {
    private final int instanceId;
    private final ComputerFamily family;
    private final InputState input = new InputState(this);

    public ContainerComputerBase(int computerInstanceId, ComputerFamily family) {
        this(x -> true, computerInstanceId, family);
    }

    protected ContainerComputerBase(Predicate<Player> canUse, int computerInstanceId, ComputerFamily family) {
        this.instanceId = computerInstanceId;
        this.family = family;
    }

    @Nonnull
    public ComputerFamily getFamily() {
        return this.family;
    }

    @Override
    @Nullable
    public IComputer getComputer() {
        if (Helper.isServerEnvironment() || Helper.isSinglePlayer()) {
            return ComputerCraft.serverComputerRegistry.get(this.instanceId);
        }
        ClientComputer computer = (ClientComputer)ComputerCraft.clientComputerRegistry.get(this.instanceId);
        if (computer == null) {
            computer = new ClientComputer(this.instanceId);
            ComputerCraft.clientComputerRegistry.add(this.instanceId, computer);
        }
        return computer;
    }

    @Override
    @Nullable
    public ClientComputer getClientComputer() {
        ClientComputer computer = (ClientComputer)ComputerCraft.clientComputerRegistry.get(this.instanceId);
        if (computer == null) {
            computer = new ClientComputer(this.instanceId);
            ComputerCraft.clientComputerRegistry.add(this.instanceId, computer);
        }
        return computer;
    }

    @Override
    @Nullable
    public ServerComputer getServerComputer() {
        return (ServerComputer)ComputerCraft.serverComputerRegistry.get(this.instanceId);
    }

    @Override
    @Nonnull
    public InputState getInput() {
        return this.input;
    }
}

