/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.computer.recipe;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.items.IComputerItem;
import dan200.computercraft.shared.computer.recipe.ComputerFamilyRecipe;
import java.lang.reflect.Type;
import javax.annotation.Nonnull;
import net.minecraft.core.data.registry.recipe.HasJsonAdapter;
import net.minecraft.core.data.registry.recipe.RecipeSymbol;
import net.minecraft.core.data.registry.recipe.adapter.RecipeCraftingShapedJsonAdapter;
import net.minecraft.core.data.registry.recipe.adapter.RecipeJsonAdapter;
import net.minecraft.core.data.registry.recipe.entry.RecipeEntryCraftingShaped;
import net.minecraft.core.item.ItemStack;

public class ComputerUpgradeRecipe
extends ComputerFamilyRecipe
implements HasJsonAdapter {
    public ComputerUpgradeRecipe(int recipeWidth, int recipeHeight, RecipeSymbol[] input, ItemStack output, boolean consumeContainerItem, boolean allowMirrored, ComputerFamily family) {
        super(recipeWidth, recipeHeight, input, output, consumeContainerItem, allowMirrored, family);
    }

    public ComputerUpgradeRecipe() {
    }

    @Override
    @Nonnull
    protected ItemStack convert(@Nonnull IComputerItem item, @Nonnull ItemStack stack) {
        return item.withFamily(stack, this.getFamily());
    }

    public RecipeJsonAdapter<?> getAdapter() {
        return new ComputerUpgradeRecipeJsonAdapter();
    }

    private static class ComputerUpgradeRecipeJsonAdapter
    implements RecipeJsonAdapter<ComputerUpgradeRecipe> {
        private ComputerUpgradeRecipeJsonAdapter() {
        }

        public ComputerUpgradeRecipe deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            RecipeEntryCraftingShaped recipeEntryCraftingShaped = new RecipeCraftingShapedJsonAdapter().deserialize(json, typeOfT, context);
            JsonObject obj = json.getAsJsonObject();
            ComputerFamily family = ComputerFamily.getFamily(obj.get("family").getAsString());
            return new ComputerUpgradeRecipe(recipeEntryCraftingShaped.recipeWidth, recipeEntryCraftingShaped.recipeHeight, (RecipeSymbol[])recipeEntryCraftingShaped.getInput(), (ItemStack)recipeEntryCraftingShaped.getOutput(), recipeEntryCraftingShaped.consumeContainerItem, recipeEntryCraftingShaped.allowMirrored, family);
        }

        public JsonElement serialize(ComputerUpgradeRecipe src, Type typeOfSrc, JsonSerializationContext context) {
            JsonElement recipeEntryCraftingShaped = new RecipeCraftingShapedJsonAdapter().serialize((RecipeEntryCraftingShaped)src, typeOfSrc, context);
            JsonObject obj = recipeEntryCraftingShaped.getAsJsonObject();
            obj.add("family", context.serialize((Object)src.getFamily().name()));
            return obj;
        }
    }
}

