/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.media.items;

import com.mojang.nbt.tags.CompoundTag;
import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.filesystem.IMount;
import dan200.computercraft.api.media.IMedia;
import dan200.computercraft.core.filesystem.SubMount;
import dan200.computercraft.shared.common.ComputerCraftItems;
import dan200.computercraft.shared.util.Colour;
import java.io.IOException;
import javax.annotation.Nonnull;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.collection.NamespaceID;
import net.minecraft.core.world.World;

public class ItemTreasureDisk
extends Item
implements IMedia {
    public static final String NBT_TITLE = "Title";
    public static final String NBT_COLOUR = "Color";
    public static final String NBT_SUB_PATH = "SubPath";

    public ItemTreasureDisk(NamespaceID namespaceId, int id) {
        super(namespaceId, id);
    }

    public static ItemStack create(String subPath, int colourIndex) {
        ItemStack result = new ItemStack((Item)ComputerCraftItems.TREASURE_DISK);
        CompoundTag nbt = result.getData();
        nbt.putString(NBT_SUB_PATH, subPath);
        int slash = subPath.indexOf(47);
        if (slash >= 0) {
            String author = subPath.substring(0, slash);
            String title = subPath.substring(slash + 1);
            nbt.putString(NBT_TITLE, "\"" + title + "\" by " + author);
        } else {
            nbt.putString(NBT_TITLE, "untitled");
        }
        nbt.putInt(NBT_COLOUR, Colour.values()[colourIndex].getHex());
        return result;
    }

    public static int getColour(@Nonnull ItemStack stack) {
        CompoundTag nbt = stack.getData();
        return nbt.containsKey(NBT_COLOUR) ? nbt.getInteger(NBT_COLOUR) : Colour.BLUE.getHex();
    }

    @Nonnull
    private static String getTitle(@Nonnull ItemStack stack) {
        CompoundTag nbt = stack.getData();
        return nbt.containsKey(NBT_TITLE) ? nbt.getString(NBT_TITLE) : "'alongtimeago' by dan200";
    }

    private static IMount getTreasureMount() {
        return ComputerCraftAPI.createResourceMount("computercraft", "lua/treasure");
    }

    @Nonnull
    private static String getSubPath(@Nonnull ItemStack stack) {
        CompoundTag nbt = stack.getData();
        return nbt.containsKey(NBT_SUB_PATH) ? nbt.getString(NBT_SUB_PATH) : "dan200/alongtimeago";
    }

    public String getTranslatedDescription(ItemStack stack) {
        String text = super.getTranslatedDescription(stack);
        String label = ItemTreasureDisk.getTitle(stack);
        if (!label.isEmpty()) {
            text = text + "\n" + label;
        }
        return text;
    }

    @Override
    public String getLabel(@Nonnull ItemStack stack) {
        return ItemTreasureDisk.getTitle(stack);
    }

    @Override
    public IMount createDataMount(@Nonnull ItemStack stack, @Nonnull World world) {
        IMount rootTreasure = ItemTreasureDisk.getTreasureMount();
        String subPath = ItemTreasureDisk.getSubPath(stack);
        try {
            if (rootTreasure.exists(subPath)) {
                return new SubMount(rootTreasure, subPath);
            }
            if (rootTreasure.exists("deprecated/" + subPath)) {
                return new SubMount(rootTreasure, "deprecated/" + subPath);
            }
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }
}

