/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.media.recipes;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import dan200.computercraft.shared.media.items.ItemDisk;
import dan200.computercraft.shared.util.Colour;
import dan200.computercraft.shared.util.ColourTracker;
import dan200.computercraft.shared.util.ColourUtils;
import java.lang.reflect.Type;
import javax.annotation.Nonnull;
import net.minecraft.core.data.registry.Registries;
import net.minecraft.core.data.registry.recipe.HasJsonAdapter;
import net.minecraft.core.data.registry.recipe.RecipeSymbol;
import net.minecraft.core.data.registry.recipe.SearchQuery;
import net.minecraft.core.data.registry.recipe.adapter.RecipeJsonAdapter;
import net.minecraft.core.data.registry.recipe.entry.RecipeEntryCrafting;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.player.inventory.container.ContainerCrafting;
import net.minecraft.core.util.helper.DyeColor;

public class DiskRecipe
extends RecipeEntryCrafting<RecipeSymbol[], ItemStack>
implements HasJsonAdapter {
    public boolean matches(ContainerCrafting inv) {
        boolean paperFound = false;
        boolean redstoneFound = false;
        for (int i = 0; i < inv.getContainerSize(); ++i) {
            ItemStack stack = inv.getItem(i);
            if (stack == null) continue;
            if (stack.getItem().equals(Items.PAPER)) {
                if (paperFound) {
                    return false;
                }
                paperFound = true;
                continue;
            }
            if (stack.getItem().equals(Items.DUST_REDSTONE)) {
                if (redstoneFound) {
                    return false;
                }
                redstoneFound = true;
                continue;
            }
            if (ColourUtils.getStackColour(stack) != null) continue;
            return false;
        }
        return redstoneFound && paperFound;
    }

    public boolean matchesQuery(SearchQuery searchQuery) {
        return false;
    }

    public ItemStack getCraftingResult(ContainerCrafting inv) {
        ColourTracker tracker = new ColourTracker();
        for (int i = 0; i < inv.getContainerSize(); ++i) {
            DyeColor dye;
            ItemStack stack = inv.getItem(i);
            if (stack == null || stack.getItem().equals(Items.PAPER) || stack.getItem().equals(Items.DUST_REDSTONE) || (dye = ColourUtils.getStackColour(stack)) == null) continue;
            tracker.addColour(dye);
        }
        return ItemDisk.createFromIDAndColour(-1, null, tracker.hasColour() ? tracker.getColour() : Colour.BLUE.getHex());
    }

    public int getRecipeSize() {
        return 0;
    }

    public ItemStack[] onCraftResult(ContainerCrafting containerCrafting) {
        ItemStack[] returnStack = new ItemStack[9];
        for (int i = 0; i < containerCrafting.getContainerSize(); ++i) {
            ItemStack itemStack = containerCrafting.getItem(i);
            if (itemStack == null) continue;
            containerCrafting.removeItem(i, 1);
            if (!itemStack.getItem().hasContainerItem()) continue;
            containerCrafting.setItem(i, new ItemStack(itemStack.getItem().getContainerItem()));
        }
        return returnStack;
    }

    @Nonnull
    public ItemStack getOutput() {
        return ItemDisk.createFromIDAndColour(-1, null, Colour.BLUE.getHex());
    }

    public RecipeJsonAdapter<?> getAdapter() {
        return new DiskRecipeJsonAdapter();
    }

    private static class DiskRecipeJsonAdapter
    implements RecipeJsonAdapter<DiskRecipe> {
        private DiskRecipeJsonAdapter() {
        }

        public DiskRecipe deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return new DiskRecipe();
        }

        public JsonElement serialize(DiskRecipe src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject obj = new JsonObject();
            obj.addProperty("name", src.toString().replaceFirst("/*$", ""));
            obj.addProperty("type", Registries.RECIPE_TYPES.getKey(((Object)((Object)src)).getClass()));
            return obj;
        }
    }
}

