/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.network.client;

import com.mojang.nbt.tags.CompoundTag;
import dan200.computercraft.fabric.Helper;
import dan200.computercraft.shared.computer.core.ComputerState;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.network.client.ComputerClientMessage;
import javax.annotation.Nonnull;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import turniplabs.halplibe.helper.network.NetworkMessage;
import turniplabs.halplibe.helper.network.UniversalPacket;

public class ComputerDataClientMessage
extends ComputerClientMessage {
    private ComputerState state;
    private CompoundTag userData;

    public ComputerDataClientMessage(ServerComputer computer) {
        super(computer.getInstanceID());
        this.state = computer.getState();
        this.userData = computer.getUserData();
    }

    public ComputerDataClientMessage() {
    }

    @Override
    public void encodeToUniversalPacket(@Nonnull UniversalPacket buf) {
        super.encodeToUniversalPacket(buf);
        buf.writeEnumConstant((Enum)this.state);
        buf.writeCompoundTag(this.userData);
    }

    @Override
    public void decodeFromUniversalPacket(@Nonnull UniversalPacket buf) {
        super.decodeFromUniversalPacket(buf);
        this.state = (ComputerState)buf.readEnumConstant(ComputerState.class);
        this.userData = buf.readCompoundTag();
    }

    public void handle(NetworkMessage.NetworkContext context) {
        if (!Helper.isServerEnvironment()) {
            this.clientHandler();
        }
    }

    @Environment(value=EnvType.CLIENT)
    private void clientHandler() {
        this.getComputer().setState(this.state, this.userData);
    }
}

