/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.network.client;

import dan200.computercraft.fabric.Helper;
import dan200.computercraft.shared.util.BlockPos;
import javax.annotation.Nonnull;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.Minecraft;
import net.minecraft.client.sound.SoundEntry;
import net.minecraft.client.sound.SoundRepository;
import net.minecraft.core.lang.I18n;
import org.jetbrains.annotations.NotNull;
import turniplabs.halplibe.helper.network.NetworkMessage;
import turniplabs.halplibe.helper.network.UniversalPacket;

public class PlayRecordClientMessage
implements NetworkMessage {
    private BlockPos pos;
    private String name;
    private SoundEntry soundEntry;

    public PlayRecordClientMessage(BlockPos pos, SoundEntry entry, String name) {
        this.pos = pos;
        this.name = name;
        this.soundEntry = entry;
    }

    public PlayRecordClientMessage(BlockPos pos) {
        this.pos = pos;
        this.name = null;
        this.soundEntry = null;
    }

    public void encodeToUniversalPacket(@Nonnull UniversalPacket buf) {
        buf.writeInt(this.pos.x);
        buf.writeInt(this.pos.y);
        buf.writeInt(this.pos.z);
        if (this.soundEntry == null) {
            buf.writeBoolean(false);
        } else {
            buf.writeBoolean(true);
            buf.writeString(this.name);
            buf.writeString(this.soundEntry.name);
        }
    }

    public void decodeFromUniversalPacket(@NotNull UniversalPacket buf) {
        int x = buf.readInt();
        int y = buf.readInt();
        int z = buf.readInt();
        this.pos = new BlockPos(x, y, z);
        if (buf.readBoolean()) {
            this.name = buf.readString();
            this.soundEntry = SoundRepository.SOUNDS.getSoundEntry(buf.readString());
        } else {
            this.name = null;
            this.soundEntry = null;
        }
    }

    public void handle(NetworkMessage.NetworkContext context) {
        if (!Helper.isServerEnvironment()) {
            this.clientHandler();
        }
    }

    @Environment(value=EnvType.CLIENT)
    private void clientHandler() {
        Minecraft mc = Minecraft.getMinecraft();
        mc.sndManager.playMusic(this.soundEntry, (float)this.pos.x, (float)this.pos.y, (float)this.pos.z, 1.0f, 1.0f);
        if (this.name != null) {
            mc.hudIngame.setRecordPlayingMessage(I18n.getInstance().translateKey(this.name));
        }
    }
}

