/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.network.client;

import com.mojang.nbt.tags.CompoundTag;
import dan200.computercraft.fabric.Helper;
import dan200.computercraft.shared.turtle.blocks.TileTurtle;
import dan200.computercraft.shared.turtle.core.TurtleBrain;
import dan200.computercraft.shared.util.BlockPos;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.WorldClient;
import net.minecraft.core.block.entity.TileEntity;
import org.jetbrains.annotations.NotNull;
import turniplabs.halplibe.helper.network.NetworkMessage;
import turniplabs.halplibe.helper.network.UniversalPacket;

public class TurtleBrainClientMessage
implements NetworkMessage {
    private int x;
    private int y;
    private int z;
    private CompoundTag brainData;

    public TurtleBrainClientMessage() {
    }

    public TurtleBrainClientMessage(BlockPos pos, TurtleBrain brain) {
        this.x = pos.x;
        this.y = pos.y;
        this.z = pos.z;
        this.brainData = new CompoundTag();
        brain.writeToNBT(this.brainData);
    }

    public void encodeToUniversalPacket(@NotNull UniversalPacket packet) {
        packet.writeInt(this.x);
        packet.writeInt(this.y);
        packet.writeInt(this.z);
        packet.writeCompoundTag(this.brainData);
    }

    public void decodeFromUniversalPacket(@NotNull UniversalPacket packet) {
        this.x = packet.readInt();
        this.y = packet.readInt();
        this.z = packet.readInt();
        this.brainData = packet.readCompoundTag();
    }

    public void handle(NetworkMessage.NetworkContext context) {
        if (!Helper.isServerEnvironment()) {
            this.clientHandler(context);
        }
    }

    @Environment(value=EnvType.CLIENT)
    private void clientHandler(NetworkMessage.NetworkContext context) {
        WorldClient world = Minecraft.getMinecraft().currentWorld;
        if (world == null) {
            return;
        }
        TileEntity tileEntity = world.getTileEntity(this.x, this.y, this.z);
        if (!(tileEntity instanceof TileTurtle)) {
            return;
        }
        ((TileTurtle)tileEntity).updateBrainFromNBT(this.brainData);
    }
}

