/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.network.server;

import dan200.computercraft.shared.computer.core.IContainerComputer;
import dan200.computercraft.shared.computer.core.InputState;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.network.server.ComputerServerMessage;
import javax.annotation.Nonnull;
import turniplabs.halplibe.helper.network.UniversalPacket;

public class KeyEventServerMessage
extends ComputerServerMessage {
    public static final int TYPE_DOWN = 0;
    public static final int TYPE_REPEAT = 1;
    public static final int TYPE_UP = 2;
    private int type;
    private int key;

    public KeyEventServerMessage(int instanceId, int type, int key) {
        super(instanceId);
        this.type = type;
        this.key = key;
    }

    public KeyEventServerMessage() {
    }

    @Override
    public void encodeToUniversalPacket(@Nonnull UniversalPacket buf) {
        super.encodeToUniversalPacket(buf);
        buf.writeByte(this.type);
        buf.writeInt(this.key);
    }

    @Override
    public void decodeFromUniversalPacket(@Nonnull UniversalPacket buf) {
        super.decodeFromUniversalPacket(buf);
        this.type = buf.readByte();
        this.key = buf.readInt();
    }

    @Override
    protected void handle(@Nonnull ServerComputer computer, @Nonnull IContainerComputer container) {
        InputState input = container.getInput();
        if (this.type == 2) {
            input.keyUp(this.key);
        } else {
            input.keyDown(this.key, this.type == 1);
        }
    }
}

