/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.network.server;

import com.mojang.nbt.tags.CompoundTag;
import dan200.computercraft.shared.computer.core.IContainerComputer;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.network.server.ComputerServerMessage;
import dan200.computercraft.shared.util.NBTUtil;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import turniplabs.halplibe.helper.network.UniversalPacket;

public class QueueEventServerMessage
extends ComputerServerMessage {
    private String event;
    private Object[] args;

    public QueueEventServerMessage(int instanceId, @Nonnull String event, @Nullable Object[] args) {
        super(instanceId);
        this.event = event;
        this.args = args;
    }

    public QueueEventServerMessage() {
    }

    @Override
    public void encodeToUniversalPacket(@Nonnull UniversalPacket buf) {
        super.encodeToUniversalPacket(buf);
        buf.writeString(this.event);
        buf.writeBoolean(this.args != null);
        if (this.args != null) {
            buf.writeCompoundTag(NBTUtil.encodeObjects(this.args));
        }
    }

    @Override
    public void decodeFromUniversalPacket(@Nonnull UniversalPacket buf) {
        super.decodeFromUniversalPacket(buf);
        this.event = buf.readString();
        boolean hasArgs = buf.readBoolean();
        if (hasArgs) {
            CompoundTag args = buf.readCompoundTag();
            this.args = NBTUtil.decodeObjects(args);
        }
    }

    @Override
    protected void handle(@Nonnull ServerComputer computer, @Nonnull IContainerComputer container) {
        computer.queueEvent(this.event, this.args);
    }
}

