/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.diskdrive;

import dan200.computercraft.shared.common.ComputerCraftItems;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.render.EntityRenderDispatcher;
import net.minecraft.client.render.Font;
import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.TextureManager;
import net.minecraft.client.render.item.model.ItemModelStandard;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class ItemModelDisk
extends ItemModelStandard {
    public static final IconCoordinate DISK_COLOUR = TextureRegistry.getTexture((String)"computercraft:item/disk_colour");

    public ItemModelDisk(Item item, String namespace) {
        super(item, namespace);
    }

    private static void draw3DModel(Tessellator tessellator, boolean worldTransform, IconCoordinate tex) {
        float y;
        float v;
        float x;
        float u;
        float texProgress;
        int i;
        tex.parentAtlas.bind();
        int tileWidth = tex.width;
        float uMin = (float)tex.getIconUMin();
        float uMax = (float)tex.getIconUMax();
        float vMin = (float)tex.getIconVMin();
        float vMax = (float)tex.getIconVMax();
        float uDiff = uMin - uMax;
        float vDiff = vMin - vMax;
        float width = 1.0f;
        float foon = 0.5f / (float)tex.parentAtlas.getHeight();
        float goon = 0.0625f * (16.0f / (float)tileWidth);
        GL11.glEnable((int)32826);
        float thickness = 0.0625f;
        float pixelWidth = 1.0f / (float)tileWidth;
        if (worldTransform) {
            GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)0.03125f);
        }
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, 0.0f, 1.0f);
        tessellator.addVertexWithUV(0.0, 0.0, 0.0, (double)uMax, (double)vMax);
        tessellator.addVertexWithUV(1.0, 0.0, 0.0, (double)uMin, (double)vMax);
        tessellator.addVertexWithUV(1.0, 1.0, 0.0, (double)uMin, (double)vMin);
        tessellator.addVertexWithUV(0.0, 1.0, 0.0, (double)uMax, (double)vMin);
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, 0.0f, -1.0f);
        tessellator.addVertexWithUV(0.0, 1.0, -0.0625, (double)uMax, (double)vMin);
        tessellator.addVertexWithUV(1.0, 1.0, -0.0625, (double)uMin, (double)vMin);
        tessellator.addVertexWithUV(1.0, 0.0, -0.0625, (double)uMin, (double)vMax);
        tessellator.addVertexWithUV(0.0, 0.0, -0.0625, (double)uMax, (double)vMax);
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(-1.0f, 0.0f, 0.0f);
        for (i = 0; i < tileWidth; ++i) {
            texProgress = (float)i * pixelWidth;
            u = uMax + uDiff * texProgress - foon;
            x = texProgress;
            tessellator.addVertexWithUV((double)x, 0.0, -0.0625, (double)u, (double)vMax);
            tessellator.addVertexWithUV((double)x, 0.0, 0.0, (double)u, (double)vMax);
            tessellator.addVertexWithUV((double)x, 1.0, 0.0, (double)u, (double)vMin);
            tessellator.addVertexWithUV((double)x, 1.0, -0.0625, (double)u, (double)vMin);
        }
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(1.0f, 0.0f, 0.0f);
        for (i = 0; i < tileWidth; ++i) {
            texProgress = (float)i * pixelWidth;
            u = uMax + uDiff * texProgress - foon;
            x = texProgress + goon;
            tessellator.addVertexWithUV((double)x, 1.0, -0.0625, (double)u, (double)vMin);
            tessellator.addVertexWithUV((double)x, 1.0, 0.0, (double)u, (double)vMin);
            tessellator.addVertexWithUV((double)x, 0.0, 0.0, (double)u, (double)vMax);
            tessellator.addVertexWithUV((double)x, 0.0, -0.0625, (double)u, (double)vMax);
        }
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, 1.0f, 0.0f);
        for (i = 0; i < tileWidth; ++i) {
            texProgress = (float)i * pixelWidth;
            v = vMax + vDiff * texProgress - foon;
            y = texProgress + goon;
            tessellator.addVertexWithUV(0.0, (double)y, 0.0, (double)uMax, (double)v);
            tessellator.addVertexWithUV(1.0, (double)y, 0.0, (double)uMin, (double)v);
            tessellator.addVertexWithUV(1.0, (double)y, -0.0625, (double)uMin, (double)v);
            tessellator.addVertexWithUV(0.0, (double)y, -0.0625, (double)uMax, (double)v);
        }
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, -1.0f, 0.0f);
        for (i = 0; i < tileWidth; ++i) {
            texProgress = (float)i * pixelWidth;
            v = vMax + vDiff * texProgress - foon;
            y = texProgress;
            tessellator.addVertexWithUV(1.0, (double)y, 0.0, (double)uMin, (double)v);
            tessellator.addVertexWithUV(0.0, (double)y, 0.0, (double)uMax, (double)v);
            tessellator.addVertexWithUV(0.0, (double)y, -0.0625, (double)uMax, (double)v);
            tessellator.addVertexWithUV(1.0, (double)y, -0.0625, (double)uMin, (double)v);
        }
        tessellator.draw();
    }

    public void renderItemInWorld(Tessellator tessellator, Entity entity, ItemStack itemStack, float brightness, float alpha, boolean worldTransform) {
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        if (this.useColor) {
            int color = this.getColor(itemStack);
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g2 = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            GL11.glColor4f((float)(r * brightness), (float)(g2 * brightness), (float)(b * brightness), (float)alpha);
        } else {
            GL11.glColor4f((float)brightness, (float)brightness, (float)brightness, (float)alpha);
        }
        IconCoordinate tex = this.getIcon(entity, itemStack);
        ItemModelDisk.draw3DModel(tessellator, worldTransform, tex);
        int diskColour = ComputerCraftItems.DISK.getColour(itemStack);
        if (diskColour != -1) {
            float r = (float)(diskColour >> 16 & 0xFF) / 255.0f;
            float g3 = (float)(diskColour >> 8 & 0xFF) / 255.0f;
            float b = (float)(diskColour & 0xFF) / 255.0f;
            GL11.glColor4f((float)(r * brightness), (float)(g3 * brightness), (float)(b * brightness), (float)alpha);
            ItemModelDisk.draw3DModel(tessellator, worldTransform, DISK_COLOUR);
        }
        GL11.glDisable((int)32826);
        GL11.glDisable((int)3042);
    }

    public void renderItemIntoGui(Tessellator tessellator, Font font, TextureManager textureManager, ItemStack itemStack, int x, int y, float brightness, float alpha) {
        if (itemStack != null) {
            float b;
            float g2;
            float r;
            Minecraft mc = Minecraft.getMinecraft();
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glDisable((int)2896);
            GL11.glEnable((int)3042);
            GL11.glEnable((int)2884);
            IconCoordinate textureIndex = this.getIcon((Entity)mc.thePlayer, itemStack);
            textureIndex.parentAtlas.bind();
            if (this.useColor) {
                int color = this.getColor(itemStack);
                r = (float)(color >> 16 & 0xFF) / 255.0f;
                g2 = (float)(color >> 8 & 0xFF) / 255.0f;
                b = (float)(color & 0xFF) / 255.0f;
                GL11.glColor4f((float)(r * brightness), (float)(g2 * brightness), (float)(b * brightness), (float)alpha);
            } else {
                GL11.glColor4f((float)brightness, (float)brightness, (float)brightness, (float)alpha);
            }
            this.renderTexturedQuad(tessellator, x, y, textureIndex);
            int diskColour = ComputerCraftItems.DISK.getColour(itemStack);
            if (diskColour != -1) {
                r = (float)(diskColour >> 16 & 0xFF) / 255.0f;
                g2 = (float)(diskColour >> 8 & 0xFF) / 255.0f;
                b = (float)(diskColour & 0xFF) / 255.0f;
                GL11.glColor4f((float)(r * brightness), (float)(g2 * brightness), (float)(b * brightness), (float)alpha);
                this.renderTexturedQuad(tessellator, x, y, DISK_COLOUR);
            }
            GL11.glEnable((int)2896);
            GL11.glDisable((int)2884);
            GL11.glDisable((int)3042);
        }
    }

    public void renderAsItemEntity(Tessellator tessellator, @Nullable Entity entity, Random random, ItemStack itemstack, int renderCount, float yaw, float brightness, float partialTick) {
        int i;
        Minecraft mc = Minecraft.getMinecraft();
        if (mc.fullbright || this.itemfullBright) {
            brightness = 1.0f;
        }
        EntityRenderDispatcher renderDispatcher = EntityRenderDispatcher.instance;
        GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
        IconCoordinate tex = this.getIcon(entity, itemstack);
        tex.parentAtlas.bind();
        if (this.useColor) {
            int color = this.getColor(itemstack);
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g2 = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            GL11.glColor4f((float)(r * brightness), (float)(g2 * brightness), (float)(b * brightness), (float)1.0f);
        } else {
            GL11.glColor4f((float)brightness, (float)brightness, (float)brightness, (float)1.0f);
        }
        if (LightmapHelper.isLightmapEnabled() && this.itemfullBright && entity != null) {
            int lmc = entity.getLightmapCoord(1.0f);
            lmc = LightmapHelper.setBlocklightValue((int)lmc, (int)15);
            LightmapHelper.setLightmapCoord((int)lmc);
        }
        if (((Boolean)mc.gameSettings.items3D.value).booleanValue()) {
            GL11.glPushMatrix();
            GL11.glScaled((double)1.0, (double)1.0, (double)1.0);
            GL11.glRotated((double)yaw, (double)0.0, (double)1.0, (double)0.0);
            GL11.glTranslated((double)-0.5, (double)0.0, (double)(-0.05 * (double)(renderCount - 1)));
            for (i = 0; i < renderCount; ++i) {
                GL11.glPushMatrix();
                GL11.glTranslated((double)0.0, (double)0.0, (double)(0.1 * (double)i));
                this.renderItem(tessellator, renderDispatcher.itemRenderer, itemstack, entity, brightness, false);
                GL11.glPopMatrix();
            }
            GL11.glPopMatrix();
        } else {
            for (i = 0; i < renderCount; ++i) {
                GL11.glPushMatrix();
                if (i > 0) {
                    float rOffX = (random.nextFloat() * 2.0f - 1.0f) * 0.3f;
                    float rOffY = (random.nextFloat() * 2.0f - 1.0f) * 0.3f;
                    float rOffZ = (random.nextFloat() * 2.0f - 1.0f) * 0.3f;
                    GL11.glTranslatef((float)rOffX, (float)rOffY, (float)rOffZ);
                }
                GL11.glRotatef((float)(180.0f - renderDispatcher.viewLerpYaw), (float)0.0f, (float)1.0f, (float)0.0f);
                this.renderFlat(tessellator, tex);
                int diskColour = ComputerCraftItems.DISK.getColour(itemstack);
                if (diskColour != -1) {
                    float r = (float)(diskColour >> 16 & 0xFF) / 255.0f;
                    float g3 = (float)(diskColour >> 8 & 0xFF) / 255.0f;
                    float b = (float)(diskColour & 0xFF) / 255.0f;
                    GL11.glColor4f((float)(r * brightness), (float)(g3 * brightness), (float)(b * brightness), (float)1.0f);
                    this.renderFlat(tessellator, DISK_COLOUR);
                }
                GL11.glPopMatrix();
            }
        }
    }
}

