/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.diskdrive;

import com.mojang.nbt.tags.CompoundTag;
import com.mojang.nbt.tags.Tag;
import dan200.computercraft.api.filesystem.IMount;
import dan200.computercraft.api.filesystem.IWritableMount;
import dan200.computercraft.api.media.IMedia;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.peripheral.IPeripheralTile;
import dan200.computercraft.fabric.Helper;
import dan200.computercraft.shared.MediaProviders;
import dan200.computercraft.shared.common.TileGeneric;
import dan200.computercraft.shared.network.client.OpenGuiDiskDriveClientMessage;
import dan200.computercraft.shared.peripheral.diskdrive.BlockLogicDiskDrive;
import dan200.computercraft.shared.peripheral.diskdrive.DiskDrivePeripheral;
import dan200.computercraft.shared.peripheral.diskdrive.DiskDriveState;
import dan200.computercraft.shared.util.BlockPos;
import dan200.computercraft.shared.util.InventoryUtil;
import dan200.computercraft.shared.util.RecordUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.sound.SoundEntry;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityItem;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.player.inventory.container.Container;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.Side;

public final class TileDiskDrive
extends TileGeneric
implements IPeripheralTile,
Container {
    private static final String NBT_NAME = "CustomName";
    private static final String NBT_ITEM = "Item";
    private final Map<IComputerAccess, MountInfo> computers = new HashMap<IComputerAccess, MountInfo>();
    String customName;
    private ItemStack diskStack = null;
    private IMount diskMount = null;
    private boolean recordQueued = false;
    private boolean recordPlaying = false;
    private boolean restartRecord = false;
    private boolean ejectQueued;

    public void invalidate() {
        this.ejectContents(true);
        if (this.recordPlaying) {
            this.stopRecord();
        }
        super.invalidate();
    }

    public boolean onBlockRightClicked(Player player, Side side, double xPlaced, double yPlaced) {
        if (player.isSneaking()) {
            ItemStack disk = player.getHeldItem();
            if (disk == null) {
                return true;
            }
            if (!Helper.isClientWorld() && this.getItem(0) == null && MediaProviders.get(disk) != null) {
                this.setDiskStack(disk);
                player.setHeldObject(null);
            }
            return true;
        }
        if (!Helper.isClientWorld()) {
            new OpenGuiDiskDriveClientMessage(this).sendToPlayer(player);
        }
        return true;
    }

    public Direction getDirection() {
        return BlockLogicDiskDrive.getDirectionFromMeta((int)this.getBlockMeta());
    }

    public void readFromNBT(CompoundTag nbt) {
        super.readFromNBT(nbt);
        String string = this.customName = nbt.containsKey(NBT_NAME) ? nbt.getString(NBT_NAME) : null;
        if (nbt.containsKey(NBT_ITEM)) {
            CompoundTag item = nbt.getCompound(NBT_ITEM);
            this.diskStack = ItemStack.readItemStackFromNbt((CompoundTag)item);
            this.diskMount = null;
        }
    }

    public void writeToNBT(CompoundTag nbt) {
        if (this.customName != null) {
            nbt.putString(NBT_NAME, this.customName);
        }
        if (this.diskStack != null) {
            CompoundTag item = new CompoundTag();
            this.diskStack.writeToNBT(item);
            nbt.put(NBT_ITEM, (Tag)item);
        }
        super.writeToNBT(nbt);
    }

    public void markDirty() {
        if (!Helper.isClientWorld()) {
            this.updateBlockState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tick() {
        if (this.ejectQueued) {
            this.ejectContents(false);
            this.ejectQueued = false;
        }
        TileDiskDrive tileDiskDrive = this;
        synchronized (tileDiskDrive) {
            if (!Helper.isClientWorld() && this.recordPlaying != this.recordQueued || this.restartRecord) {
                this.restartRecord = false;
                if (this.recordQueued) {
                    SoundEntry record;
                    IMedia contents = this.getDiskMedia();
                    SoundEntry soundEntry = record = contents != null ? contents.getAudio(this.diskStack) : null;
                    if (record != null) {
                        this.recordPlaying = true;
                        this.playRecord();
                    } else {
                        this.recordQueued = false;
                    }
                } else {
                    this.stopRecord();
                    this.recordPlaying = false;
                }
            }
        }
    }

    public int getContainerSize() {
        return 1;
    }

    @Nullable
    public ItemStack getItem(int i) {
        return this.diskStack;
    }

    @Nullable
    public ItemStack removeItem(int slot, int count) {
        if (this.diskStack == null) {
            return null;
        }
        if (this.diskStack.stackSize <= count) {
            ItemStack disk = this.diskStack;
            this.setItem(slot, null);
            return disk;
        }
        ItemStack part = this.diskStack.splitStack(count);
        this.setItem(slot, this.diskStack == null ? null : this.diskStack);
        return part;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setItem(int i, @Nullable ItemStack stack) {
        if (Helper.isClientWorld()) {
            this.diskStack = stack;
            this.diskMount = null;
            this.markDirty();
            return;
        }
        TileDiskDrive tileDiskDrive = this;
        synchronized (tileDiskDrive) {
            Set<IComputerAccess> computers;
            if (InventoryUtil.areItemsStackable(stack, this.diskStack)) {
                this.diskStack = stack;
                return;
            }
            if (this.diskStack != null) {
                computers = this.computers.keySet();
                for (IComputerAccess computer : computers) {
                    this.unmountDisk(computer);
                }
            }
            if (this.recordPlaying) {
                this.stopRecord();
                this.recordPlaying = false;
                this.recordQueued = false;
            }
            this.diskStack = stack;
            this.diskMount = null;
            this.markDirty();
            if (this.diskStack != null) {
                computers = this.computers.keySet();
                for (IComputerAccess computer : computers) {
                    this.mountDisk(computer);
                }
            }
        }
    }

    public String getNameTranslationKey() {
        return "";
    }

    public int getMaxStackSize() {
        return 1;
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public void sortContainer() {
    }

    @Override
    @Nonnull
    public IPeripheral getPeripheral(Direction side) {
        return new DiskDrivePeripheral(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getDiskMountPath(IComputerAccess computer) {
        TileDiskDrive tileDiskDrive = this;
        synchronized (tileDiskDrive) {
            MountInfo info = this.computers.get(computer);
            return info != null ? info.mountPath : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void mount(IComputerAccess computer) {
        TileDiskDrive tileDiskDrive = this;
        synchronized (tileDiskDrive) {
            this.computers.put(computer, new MountInfo());
            this.mountDisk(computer);
        }
    }

    private synchronized void mountDisk(IComputerAccess computer) {
        if (this.diskStack != null) {
            MountInfo info = this.computers.get(computer);
            IMedia contents = this.getDiskMedia();
            if (contents != null) {
                if (this.diskMount == null) {
                    this.diskMount = contents.createDataMount(this.diskStack, this.worldObj);
                }
                if (this.diskMount != null) {
                    if (this.diskMount instanceof IWritableMount) {
                        int n = 1;
                        while (info.mountPath == null) {
                            info.mountPath = computer.mountWritable(n == 1 ? "disk" : "disk" + n, (IWritableMount)this.diskMount);
                            ++n;
                        }
                    } else {
                        int n = 1;
                        while (info.mountPath == null) {
                            info.mountPath = computer.mount(n == 1 ? "disk" : "disk" + n, this.diskMount);
                            ++n;
                        }
                    }
                } else {
                    info.mountPath = null;
                }
            }
            computer.queueEvent("disk", computer.getAttachmentName());
        }
    }

    private IMedia getDiskMedia() {
        return MediaProviders.get(this.getDiskStack());
    }

    @Nullable
    ItemStack getDiskStack() {
        return this.getItem(0);
    }

    void setDiskStack(@Nullable ItemStack stack) {
        this.setItem(0, stack);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unmount(IComputerAccess computer) {
        TileDiskDrive tileDiskDrive = this;
        synchronized (tileDiskDrive) {
            this.unmountDisk(computer);
            this.computers.remove(computer);
        }
    }

    private synchronized void unmountDisk(IComputerAccess computer) {
        if (this.diskStack != null) {
            MountInfo info = this.computers.get(computer);
            assert (info != null);
            if (info.mountPath != null) {
                computer.unmount(info.mountPath);
                info.mountPath = null;
            }
            computer.queueEvent("disk_eject", computer.getAttachmentName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void playDiskAudio() {
        TileDiskDrive tileDiskDrive = this;
        synchronized (tileDiskDrive) {
            IMedia media = this.getDiskMedia();
            if (media != null && media.getAudioTitle(this.diskStack) != null) {
                this.recordQueued = true;
                this.restartRecord = this.recordPlaying;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopDiskAudio() {
        TileDiskDrive tileDiskDrive = this;
        synchronized (tileDiskDrive) {
            this.recordQueued = false;
            this.restartRecord = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void ejectDisk() {
        TileDiskDrive tileDiskDrive = this;
        synchronized (tileDiskDrive) {
            this.ejectQueued = true;
        }
    }

    private void updateBlockState() {
        if (this.diskStack != null) {
            IMedia contents = this.getDiskMedia();
            this.updateBlockState(contents != null ? DiskDriveState.FULL : DiskDriveState.INVALID);
        } else {
            this.updateBlockState(DiskDriveState.EMPTY);
        }
    }

    private void updateBlockState(DiskDriveState newState) {
        int currentMetadata = this.getBlockMeta();
        DiskDriveState currentState = ((DiskDriveState[])DiskDriveState.class.getEnumConstants())[currentMetadata >> 3 & 3];
        if (currentState != newState) {
            int newMetadata = currentMetadata & 0xFFFFFFE7 | newState.ordinal() << 3;
            if (this.worldObj != null) {
                this.worldObj.setBlockMetadataWithNotify(this.x, this.y, this.z, newMetadata);
            }
        }
    }

    private synchronized void ejectContents(boolean destroyed) {
        if (Helper.isClientWorld() || this.diskStack == null) {
            return;
        }
        ItemStack disks = this.diskStack;
        this.setDiskStack(null);
        int xOff = 0;
        int zOff = 0;
        if (!destroyed) {
            Direction dir = this.getDirection();
            xOff = dir.getOffsetX();
            zOff = dir.getOffsetZ();
        }
        BlockPos pos = this.getPos();
        double x = (double)pos.getX() + 0.5 + (double)xOff * 0.5;
        double y = (double)pos.getY() + 0.75;
        double z = (double)pos.getZ() + 0.5 + (double)zOff * 0.5;
        EntityItem entityitem = new EntityItem(this.worldObj, x, y, z, disks);
        entityitem.xd = (double)xOff * 0.15;
        entityitem.yd = 0.0;
        entityitem.zd = (double)zOff * 0.15;
        this.worldObj.entityJoinedWorld((Entity)entityitem);
        if (!destroyed) {
            // empty if block
        }
    }

    private BlockPos getPos() {
        return new BlockPos(this.x, this.y, this.z);
    }

    private void playRecord() {
        SoundEntry record;
        IMedia contents = this.getDiskMedia();
        SoundEntry soundEntry = record = contents != null ? contents.getAudio(this.diskStack) : null;
        if (record != null) {
            RecordUtil.playRecord(record, contents.getAudioTitle(this.diskStack), this.worldObj, new BlockPos(this.x, this.y, this.z));
        } else {
            RecordUtil.playRecord(null, null, this.worldObj, new BlockPos(this.x, this.y, this.z));
        }
    }

    private void stopRecord() {
        RecordUtil.playRecord(null, null, this.worldObj, new BlockPos(this.x, this.y, this.z));
    }

    @Nonnull
    public String getName() {
        return this.customName != null ? this.customName : "A name";
    }

    private static class MountInfo {
        String mountPath;

        private MountInfo() {
        }
    }
}

