/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.generic.data;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.data.registry.Registries;
import net.minecraft.core.data.tag.Tag;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.collection.NamespaceID;

public class BlockData {
    @Nonnull
    public static <T extends Map<? super String, Object>> T fill(@Nonnull T data, int id, int metadata, NamespaceID namespaceID) {
        data.put((String)"id", id);
        data.put((String)"metadata", metadata);
        data.put((String)"name", (String)namespaceID.toString());
        Block block = Objects.requireNonNull(Blocks.getBlock((int)id));
        HashMap<String, Boolean> tagsTable = new HashMap<String, Boolean>();
        for (Tag blockTag : BlockTags.TAG_LIST) {
            if (!block.hasTag(blockTag)) continue;
            tagsTable.put(blockTag.getName(), true);
        }
        data.put((String)"tags", tagsTable);
        HashMap<String, Boolean> groupsTable = new HashMap<String, Boolean>();
        for (List itemGroup : Registries.ITEM_GROUPS) {
            for (ItemStack itemStack : itemGroup) {
                if (!itemStack.getItem().equals(block.asItem())) continue;
                String key = Registries.ITEM_GROUPS.getKey((Object)itemGroup);
                groupsTable.put(key, true);
            }
        }
        data.put((String)"groups", groupsTable);
        return data;
    }
}

