/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.modem.wired;

import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.shared.common.ComputerCraftItems;
import dan200.computercraft.shared.peripheral.modem.wired.CableModemVariant;
import dan200.computercraft.shared.peripheral.modem.wired.CableShapes;
import dan200.computercraft.shared.peripheral.modem.wired.TileCable;
import dan200.computercraft.shared.util.BlockPos;
import java.util.ArrayList;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockLogicCable
extends BlockLogic {
    public BlockLogicCable(Block<?> block, Material material) {
        super(block, material);
        this.setBlockBounds(0.125, 0.0, 0.125, 0.875, 0.1875, 0.875);
    }

    public static boolean canConnectIn(TileCable state, Direction direction) {
        return state.blockStateCable && state.blockStateModem.getFacing() != direction;
    }

    public static boolean doesConnectVisually(TileCable state, World world, BlockPos pos, Direction direction) {
        if (!state.blockStateCable) {
            return false;
        }
        if (state.blockStateModem.getFacing() == direction) {
            return true;
        }
        return ComputerCraftAPI.getWiredElementAt(world, pos.offset(direction), direction.getOpposite()) != null;
    }

    public static void correctConnections(World world, BlockPos pos, TileCable state) {
        if (state.blockStateCable) {
            state.blockStateNorth = BlockLogicCable.doesConnectVisually(state, world, pos, Direction.NORTH);
            state.blockStateSouth = BlockLogicCable.doesConnectVisually(state, world, pos, Direction.SOUTH);
            state.blockStateEast = BlockLogicCable.doesConnectVisually(state, world, pos, Direction.EAST);
            state.blockStateWest = BlockLogicCable.doesConnectVisually(state, world, pos, Direction.WEST);
            state.blockStateUp = BlockLogicCable.doesConnectVisually(state, world, pos, Direction.UP);
            state.blockStateDown = BlockLogicCable.doesConnectVisually(state, world, pos, Direction.DOWN);
        } else {
            state.blockStateNorth = false;
            state.blockStateSouth = false;
            state.blockStateEast = false;
            state.blockStateWest = false;
            state.blockStateUp = false;
            state.blockStateDown = false;
        }
    }

    public boolean canPlaceBlockAt(World world, int x, int y, int z) {
        TileCable state = (TileCable)world.getTileEntity(x, y, z);
        if (state == null) {
            return super.canPlaceBlockAt(world, x, y, z);
        }
        Direction facing = state.blockStateModem.getFacing();
        if (facing == null) {
            return true;
        }
        return world.isBlockNormalCube(x + facing.getOffsetX(), y + facing.getOffsetY(), z + facing.getOffsetZ());
    }

    public AABB getBlockBoundsFromState(WorldSource world, int x, int y, int z) {
        this.updateBlockBoundsFromState(world, x, y, z);
        return super.getBlockBoundsFromState(world, x, y, z);
    }

    public void updateBlockBoundsFromState(WorldSource world, int x, int y, int z) {
        TileCable state = (TileCable)world.getTileEntity(x, y, z);
        if (state == null) {
            this.setBlockBounds(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
            return;
        }
        AABB shape = CableShapes.getShape(state);
        if (shape.getSize() == 0.0) {
            this.setBlockBounds(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
            return;
        }
        this.setBlockBounds(shape.minX, shape.minY, shape.minZ, shape.maxX, shape.maxY, shape.maxZ);
    }

    public boolean isCubeShaped() {
        return false;
    }

    public boolean isSolidRender() {
        return false;
    }

    public void getCollidingBoundingBoxes(World world, int x, int y, int z, AABB aabb, ArrayList<AABB> aabbList) {
        TileEntity tileEntity = world.getTileEntity(x, y, z);
        if (tileEntity instanceof TileCable) {
            TileCable state = (TileCable)tileEntity;
            if (state.blockStateCable) {
                this.addIntersectingBoundingBox(aabb, CableShapes.SHAPE_CABLE_CORE.cloneMove((double)x, (double)y, (double)z), aabbList);
                if (state.blockStateNorth) {
                    this.addIntersectingBoundingBox(aabb, CableShapes.SHAPE_CABLE_ARM.get(Direction.NORTH).cloneMove((double)x, (double)y, (double)z), aabbList);
                }
                if (state.blockStateSouth) {
                    this.addIntersectingBoundingBox(aabb, CableShapes.SHAPE_CABLE_ARM.get(Direction.SOUTH).cloneMove((double)x, (double)y, (double)z), aabbList);
                }
                if (state.blockStateEast) {
                    this.addIntersectingBoundingBox(aabb, CableShapes.SHAPE_CABLE_ARM.get(Direction.EAST).cloneMove((double)x, (double)y, (double)z), aabbList);
                }
                if (state.blockStateWest) {
                    this.addIntersectingBoundingBox(aabb, CableShapes.SHAPE_CABLE_ARM.get(Direction.WEST).cloneMove((double)x, (double)y, (double)z), aabbList);
                }
                if (state.blockStateUp) {
                    this.addIntersectingBoundingBox(aabb, CableShapes.SHAPE_CABLE_ARM.get(Direction.UP).cloneMove((double)x, (double)y, (double)z), aabbList);
                }
                if (state.blockStateDown) {
                    this.addIntersectingBoundingBox(aabb, CableShapes.SHAPE_CABLE_ARM.get(Direction.DOWN).cloneMove((double)x, (double)y, (double)z), aabbList);
                }
            }
            if (state.blockStateModem.getFacing() != null) {
                this.addIntersectingBoundingBox(aabb, CableShapes.getModemShape(state).cloneMove((double)x, (double)y, (double)z), aabbList);
            }
        }
    }

    public void onBlockPlacedByWorld(World world, int x, int y, int z) {
        TileCable cable;
        TileEntity tile = world.getTileEntity(x, y, z);
        if (tile instanceof TileCable && (cable = (TileCable)tile).hasCable()) {
            cable.connectionsChanged();
        }
    }

    public void onBlockPlacedByMob(World world, int x, int y, int z, @NotNull Side side, Mob mob, double xPlaced, double yPlaced) {
        TileCable cable;
        TileEntity tile = world.getTileEntity(x, y, z);
        if (tile instanceof TileCable && (cable = (TileCable)tile).hasCable()) {
            cable.connectionsChanged();
        }
    }

    public ItemStack @Nullable [] getBreakResult(World world, EnumDropCause dropCause, int meta, TileEntity tileEntity) {
        if (dropCause == EnumDropCause.IMPROPER_TOOL) {
            return null;
        }
        if (!(tileEntity instanceof TileCable)) {
            return null;
        }
        TileCable cable = (TileCable)tileEntity;
        if (cable.blockStateCable && cable.blockStateModem != CableModemVariant.None) {
            return new ItemStack[]{new ItemStack((Item)ComputerCraftItems.CABLE), new ItemStack((Item)ComputerCraftItems.WIRED_MODEM)};
        }
        if (cable.blockStateModem != CableModemVariant.None) {
            return new ItemStack[]{new ItemStack((Item)ComputerCraftItems.WIRED_MODEM)};
        }
        return new ItemStack[]{new ItemStack((Item)ComputerCraftItems.CABLE)};
    }

    public boolean onBlockRightClicked(World world, int x, int y, int z, Player player, Side side, double xPlaced, double yPlaced) {
        return ((TileCable)world.getTileEntity(x, y, z)).onBlockRightClicked(player, side, xPlaced, yPlaced);
    }

    public void onNeighborBlockChange(World world, int x, int y, int z, int blockId) {
        TileEntity entity = world.getTileEntity(x, y, z);
        if (!(entity instanceof TileCable)) {
            return;
        }
        TileCable tileCable = (TileCable)entity;
        tileCable.onNeighbourChange(new BlockPos(x, y, z));
    }
}

