/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.modem.wired;

import dan200.computercraft.shared.peripheral.modem.ModemShapes;
import dan200.computercraft.shared.peripheral.modem.wired.CableModemVariant;
import dan200.computercraft.shared.peripheral.modem.wired.CableShapes;
import dan200.computercraft.shared.peripheral.modem.wired.TileCable;
import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.block.color.BlockColor;
import net.minecraft.client.render.block.color.BlockColorDispatcher;
import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.AABB;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;

public class BlockModelCable<T extends BlockLogic>
extends BlockModelStandard<T> {
    public static final IconCoordinate CABLE_CORE = TextureRegistry.getTexture((String)"computercraft:block/cable_core");
    public static final IconCoordinate CABLE_SIDE = TextureRegistry.getTexture((String)"computercraft:block/cable_side");
    public static final IconCoordinate MODEM_BACK = TextureRegistry.getTexture((String)"computercraft:block/modem_back");
    public static final IconCoordinate WIRED_MODEM_FACE = TextureRegistry.getTexture((String)"computercraft:block/wired_modem_face");
    public static final IconCoordinate WIRED_MODEM_FACE_ON = TextureRegistry.getTexture((String)"computercraft:block/wired_modem_face_on");
    public static final IconCoordinate WIRED_MODEM_FACE_PERIPHERAL = TextureRegistry.getTexture((String)"computercraft:block/wired_modem_face_peripheral");
    public static final IconCoordinate WIRED_MODEM_FACE_PERIPHERAL_ON = TextureRegistry.getTexture((String)"computercraft:block/wired_modem_face_peripheral_on");
    IconCoordinate currentCoordinate = CABLE_SIDE;

    public BlockModelCable(Block<T> block) {
        super(block);
    }

    private static void setBounds(AABB bounds, AABB shape) {
        bounds.set(shape.minX, shape.minY, shape.minZ, shape.maxX, shape.maxY, shape.maxZ);
    }

    public boolean render(Tessellator tessellator, int x, int y, int z) {
        AABB bounds = this.block.getBlockBoundsFromState(BlockModelCable.renderBlocks.blockAccess, x, y, z);
        BlockModelCable.renderBlocks.enableAO = true;
        BlockModelCable.renderBlocks.cache.setupCache(this.block, BlockModelCable.renderBlocks.blockAccess, x, y, z);
        TileEntity tileEntity = BlockModelCable.renderBlocks.blockAccess.getTileEntity(x, y, z);
        if (tileEntity instanceof TileCable) {
            TileCable state = (TileCable)tileEntity;
            if (state.blockStateCable) {
                BlockModelCable.setBounds(bounds, CableShapes.SHAPE_CABLE_CORE);
                if (!state.blockStateNorth) {
                    if (!(!state.blockStateSouth || state.blockStateWest || state.blockStateEast || state.blockStateUp || state.blockStateDown)) {
                        this.currentCoordinate = CABLE_CORE;
                    }
                    this.renderSide(tessellator, bounds, x, y, z, Side.NORTH, 0);
                    this.currentCoordinate = CABLE_SIDE;
                }
                if (!state.blockStateSouth) {
                    if (!(!state.blockStateNorth || state.blockStateWest || state.blockStateEast || state.blockStateUp || state.blockStateDown)) {
                        this.currentCoordinate = CABLE_CORE;
                    }
                    this.renderSide(tessellator, bounds, x, y, z, Side.SOUTH, 0);
                    this.currentCoordinate = CABLE_SIDE;
                }
                if (!state.blockStateEast) {
                    if (!(!state.blockStateWest || state.blockStateSouth || state.blockStateNorth || state.blockStateUp || state.blockStateDown)) {
                        this.currentCoordinate = CABLE_CORE;
                    }
                    if (!(state.blockStateWest || state.blockStateSouth || state.blockStateNorth || state.blockStateUp || state.blockStateDown)) {
                        this.currentCoordinate = CABLE_CORE;
                    }
                    this.renderSide(tessellator, bounds, x, y, z, Side.EAST, 0);
                    this.currentCoordinate = CABLE_SIDE;
                }
                if (!state.blockStateWest) {
                    if (!(!state.blockStateEast || state.blockStateSouth || state.blockStateNorth || state.blockStateUp || state.blockStateDown)) {
                        this.currentCoordinate = CABLE_CORE;
                    }
                    if (!(state.blockStateEast || state.blockStateSouth || state.blockStateNorth || state.blockStateUp || state.blockStateDown)) {
                        this.currentCoordinate = CABLE_CORE;
                    }
                    this.renderSide(tessellator, bounds, x, y, z, Side.WEST, 0);
                    this.currentCoordinate = CABLE_SIDE;
                }
                if (!state.blockStateUp) {
                    if (!(!state.blockStateDown || state.blockStateSouth || state.blockStateNorth || state.blockStateWest || state.blockStateEast)) {
                        this.currentCoordinate = CABLE_CORE;
                    }
                    this.renderSide(tessellator, bounds, x, y, z, Side.TOP, 0);
                    this.currentCoordinate = CABLE_SIDE;
                }
                if (!state.blockStateDown) {
                    if (!(!state.blockStateUp || state.blockStateSouth || state.blockStateNorth || state.blockStateWest || state.blockStateEast)) {
                        this.currentCoordinate = CABLE_CORE;
                    }
                    this.renderSide(tessellator, bounds, x, y, z, Side.BOTTOM, 0);
                    this.currentCoordinate = CABLE_SIDE;
                }
                if (state.blockStateNorth) {
                    BlockModelCable.setBounds(bounds, CableShapes.SHAPE_CABLE_ARM.get(Direction.NORTH));
                    this.renderSide(tessellator, bounds, x, y, z, Side.TOP, 0);
                    this.renderSide(tessellator, bounds, x, y, z, Side.BOTTOM, 0);
                    this.renderSide(tessellator, bounds, x, y, z, Side.EAST, 0);
                    this.renderSide(tessellator, bounds, x, y, z, Side.WEST, 0);
                }
                if (state.blockStateSouth) {
                    BlockModelCable.setBounds(bounds, CableShapes.SHAPE_CABLE_ARM.get(Direction.SOUTH));
                    this.renderSide(tessellator, bounds, x, y, z, Side.TOP, 0);
                    this.renderSide(tessellator, bounds, x, y, z, Side.BOTTOM, 0);
                    this.renderSide(tessellator, bounds, x, y, z, Side.EAST, 0);
                    this.renderSide(tessellator, bounds, x, y, z, Side.WEST, 0);
                }
                if (state.blockStateEast) {
                    BlockModelCable.setBounds(bounds, CableShapes.SHAPE_CABLE_ARM.get(Direction.EAST));
                    this.renderSide(tessellator, bounds, x, y, z, Side.TOP, 0);
                    this.renderSide(tessellator, bounds, x, y, z, Side.BOTTOM, 0);
                    this.renderSide(tessellator, bounds, x, y, z, Side.NORTH, 0);
                    this.renderSide(tessellator, bounds, x, y, z, Side.SOUTH, 0);
                }
                if (state.blockStateWest) {
                    BlockModelCable.setBounds(bounds, CableShapes.SHAPE_CABLE_ARM.get(Direction.WEST));
                    this.renderSide(tessellator, bounds, x, y, z, Side.TOP, 0);
                    this.renderSide(tessellator, bounds, x, y, z, Side.BOTTOM, 0);
                    this.renderSide(tessellator, bounds, x, y, z, Side.NORTH, 0);
                    this.renderSide(tessellator, bounds, x, y, z, Side.SOUTH, 0);
                }
                if (state.blockStateUp) {
                    BlockModelCable.setBounds(bounds, CableShapes.SHAPE_CABLE_ARM.get(Direction.UP));
                    this.renderSide(tessellator, bounds, x, y, z, Side.NORTH, 0);
                    this.renderSide(tessellator, bounds, x, y, z, Side.SOUTH, 0);
                    this.renderSide(tessellator, bounds, x, y, z, Side.EAST, 0);
                    this.renderSide(tessellator, bounds, x, y, z, Side.WEST, 0);
                }
                if (state.blockStateDown) {
                    BlockModelCable.setBounds(bounds, CableShapes.SHAPE_CABLE_ARM.get(Direction.DOWN));
                    this.renderSide(tessellator, bounds, x, y, z, Side.NORTH, 0);
                    this.renderSide(tessellator, bounds, x, y, z, Side.SOUTH, 0);
                    this.renderSide(tessellator, bounds, x, y, z, Side.EAST, 0);
                    this.renderSide(tessellator, bounds, x, y, z, Side.WEST, 0);
                }
            }
            if (state.blockStateModem.getFacing() != null) {
                BlockModelCable.setBounds(bounds, CableShapes.getModemShape(state));
                switch (state.blockStateModem.getFacing()) {
                    case NORTH: {
                        this.currentCoordinate = state.blockStateModem == CableModemVariant.NorthOn ? WIRED_MODEM_FACE_ON : (state.blockStateModem == CableModemVariant.NorthOffPeripheral ? WIRED_MODEM_FACE_PERIPHERAL : (state.blockStateModem == CableModemVariant.NorthOnPeripheral ? WIRED_MODEM_FACE_PERIPHERAL_ON : WIRED_MODEM_FACE));
                        this.renderSide(tessellator, bounds, x, y, z, Side.SOUTH, 0);
                        this.renderSide(tessellator, bounds, x, y, z, Side.TOP, 0);
                        this.renderSide(tessellator, bounds, x, y, z, Side.BOTTOM, 0);
                        BlockModelCable.renderBlocks.flipTexture = true;
                        this.renderSide(tessellator, bounds, x, y, z, Side.EAST, 0);
                        BlockModelCable.renderBlocks.flipTexture = false;
                        this.renderSide(tessellator, bounds, x, y, z, Side.WEST, 0);
                        this.currentCoordinate = MODEM_BACK;
                        this.renderSide(tessellator, bounds, x, y, z, Side.NORTH, 0);
                        break;
                    }
                    case EAST: {
                        this.currentCoordinate = state.blockStateModem == CableModemVariant.EastOn ? WIRED_MODEM_FACE_ON : (state.blockStateModem == CableModemVariant.EastOffPeripheral ? WIRED_MODEM_FACE_PERIPHERAL : (state.blockStateModem == CableModemVariant.EastOnPeripheral ? WIRED_MODEM_FACE_PERIPHERAL_ON : WIRED_MODEM_FACE));
                        BlockModelCable.renderBlocks.uvRotateTop = 1;
                        this.renderSide(tessellator, bounds, x, y, z, Side.SOUTH, 0);
                        this.renderSide(tessellator, bounds, x, y, z, Side.TOP, 0);
                        this.renderSide(tessellator, bounds, x, y, z, Side.BOTTOM, 0);
                        this.renderSide(tessellator, bounds, x, y, z, Side.WEST, 0);
                        BlockModelCable.renderBlocks.flipTexture = true;
                        this.renderSide(tessellator, bounds, x, y, z, Side.NORTH, 0);
                        BlockModelCable.renderBlocks.flipTexture = false;
                        this.currentCoordinate = MODEM_BACK;
                        this.renderSide(tessellator, bounds, x, y, z, Side.EAST, 0);
                        break;
                    }
                    case SOUTH: {
                        this.currentCoordinate = state.blockStateModem == CableModemVariant.SouthOn ? WIRED_MODEM_FACE_ON : (state.blockStateModem == CableModemVariant.SouthOffPeripheral ? WIRED_MODEM_FACE_PERIPHERAL : (state.blockStateModem == CableModemVariant.SouthOnPeripheral ? WIRED_MODEM_FACE_PERIPHERAL_ON : WIRED_MODEM_FACE));
                        BlockModelCable.renderBlocks.uvRotateTop = 3;
                        this.renderSide(tessellator, bounds, x, y, z, Side.NORTH, 0);
                        this.renderSide(tessellator, bounds, x, y, z, Side.TOP, 0);
                        this.renderSide(tessellator, bounds, x, y, z, Side.BOTTOM, 0);
                        BlockModelCable.renderBlocks.flipTexture = true;
                        this.renderSide(tessellator, bounds, x, y, z, Side.EAST, 0);
                        BlockModelCable.renderBlocks.flipTexture = false;
                        this.renderSide(tessellator, bounds, x, y, z, Side.WEST, 0);
                        this.currentCoordinate = MODEM_BACK;
                        this.renderSide(tessellator, bounds, x, y, z, Side.SOUTH, 0);
                        break;
                    }
                    case WEST: {
                        this.currentCoordinate = state.blockStateModem == CableModemVariant.WestOn ? WIRED_MODEM_FACE_ON : (state.blockStateModem == CableModemVariant.WestOffPeripheral ? WIRED_MODEM_FACE_PERIPHERAL : (state.blockStateModem == CableModemVariant.WestOnPeripheral ? WIRED_MODEM_FACE_PERIPHERAL_ON : WIRED_MODEM_FACE));
                        BlockModelCable.renderBlocks.uvRotateTop = 2;
                        this.renderSide(tessellator, bounds, x, y, z, Side.SOUTH, 0);
                        this.renderSide(tessellator, bounds, x, y, z, Side.TOP, 0);
                        this.renderSide(tessellator, bounds, x, y, z, Side.BOTTOM, 0);
                        this.renderSide(tessellator, bounds, x, y, z, Side.EAST, 0);
                        BlockModelCable.renderBlocks.flipTexture = true;
                        this.renderSide(tessellator, bounds, x, y, z, Side.NORTH, 0);
                        BlockModelCable.renderBlocks.flipTexture = false;
                        this.currentCoordinate = MODEM_BACK;
                        this.renderSide(tessellator, bounds, x, y, z, Side.WEST, 0);
                        break;
                    }
                    case UP: {
                        this.currentCoordinate = state.blockStateModem == CableModemVariant.UpOn ? WIRED_MODEM_FACE_ON : (state.blockStateModem == CableModemVariant.UpOffPeripheral ? WIRED_MODEM_FACE_PERIPHERAL : (state.blockStateModem == CableModemVariant.UpOnPeripheral ? WIRED_MODEM_FACE_PERIPHERAL_ON : WIRED_MODEM_FACE));
                        this.renderSide(tessellator, bounds, x, y, z, Side.SOUTH, 0);
                        this.renderSide(tessellator, bounds, x, y, z, Side.BOTTOM, 0);
                        this.renderSide(tessellator, bounds, x, y, z, Side.WEST, 0);
                        this.renderSide(tessellator, bounds, x, y, z, Side.EAST, 0);
                        this.renderSide(tessellator, bounds, x, y, z, Side.NORTH, 0);
                        this.currentCoordinate = MODEM_BACK;
                        this.renderSide(tessellator, bounds, x, y, z, Side.TOP, 0);
                        break;
                    }
                    case DOWN: {
                        this.currentCoordinate = state.blockStateModem == CableModemVariant.DownOn ? WIRED_MODEM_FACE_ON : (state.blockStateModem == CableModemVariant.DownOffPeripheral ? WIRED_MODEM_FACE_PERIPHERAL : (state.blockStateModem == CableModemVariant.DownOnPeripheral ? WIRED_MODEM_FACE_PERIPHERAL_ON : WIRED_MODEM_FACE));
                        this.renderSide(tessellator, bounds, x, y, z, Side.SOUTH, 0);
                        this.renderSide(tessellator, bounds, x, y, z, Side.TOP, 0);
                        this.renderSide(tessellator, bounds, x, y, z, Side.WEST, 0);
                        this.renderSide(tessellator, bounds, x, y, z, Side.EAST, 0);
                        this.renderSide(tessellator, bounds, x, y, z, Side.NORTH, 0);
                        this.currentCoordinate = MODEM_BACK;
                        this.renderSide(tessellator, bounds, x, y, z, Side.BOTTOM, 0);
                        break;
                    }
                }
            }
            this.currentCoordinate = CABLE_SIDE;
        }
        this.resetRenderBlocks();
        return true;
    }

    public void renderBlockOnInventory(Tessellator tessellator, int metadata, float brightness, float alpha, @Nullable Integer lightmapCoordinate) {
        if (BlockModelCable.renderBlocks.useInventoryTint) {
            int color = ((BlockColor)BlockColorDispatcher.getInstance().getDispatch((Object)this.block)).getFallbackColor(metadata);
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g2 = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            GL11.glColor4f((float)(r * brightness), (float)(g2 * brightness), (float)(b * brightness), (float)alpha);
        } else {
            GL11.glColor4f((float)brightness, (float)brightness, (float)brightness, (float)alpha);
        }
        float yOffset = 0.5f;
        AABB bounds = this.getBlockBoundsForItemRender();
        GL11.glTranslatef((float)-0.5f, (float)(0.0f - yOffset), (float)-0.5f);
        if (LightmapHelper.isLightmapEnabled() && lightmapCoordinate != null) {
            LightmapHelper.setLightmapCoord((int)lightmapCoordinate);
        }
        tessellator.startDrawingQuads();
        if (metadata == 1) {
            BlockModelCable.setBounds(bounds, ModemShapes.getBounds(Direction.WEST));
            BlockModelCable.renderBlocks.uvRotateTop = 1;
            tessellator.setNormal(0.0f, 0.0f, 1.0f);
            this.renderSouthFace(tessellator, bounds, 0.0, 0.0, 0.0, WIRED_MODEM_FACE);
            tessellator.setNormal(0.0f, 1.0f, 0.0f);
            this.renderTopFace(tessellator, bounds, 0.0, 0.0, 0.0, WIRED_MODEM_FACE);
            tessellator.setNormal(0.0f, -1.0f, 0.0f);
            this.renderBottomFace(tessellator, bounds, 0.0, 0.0, 0.0, WIRED_MODEM_FACE);
            tessellator.setNormal(1.0f, 0.0f, 0.0f);
            this.renderEastFace(tessellator, bounds, 0.0, 0.0, 0.0, WIRED_MODEM_FACE);
            BlockModelCable.renderBlocks.flipTexture = true;
            tessellator.setNormal(0.0f, 0.0f, -1.0f);
            this.renderNorthFace(tessellator, bounds, 0.0, 0.0, 0.0, WIRED_MODEM_FACE);
            BlockModelCable.renderBlocks.flipTexture = false;
            tessellator.setNormal(-1.0f, 0.0f, 0.0f);
            this.renderWestFace(tessellator, bounds, 0.0, 0.0, 0.0, MODEM_BACK);
        } else {
            BlockModelCable.setBounds(bounds, CableShapes.SHAPE_CABLE_CORE);
            tessellator.setNormal(0.0f, 0.0f, -1.0f);
            this.renderNorthFace(tessellator, bounds, 0.0, 0.0, 0.0, CABLE_SIDE);
            tessellator.setNormal(0.0f, 0.0f, 1.0f);
            this.renderSouthFace(tessellator, bounds, 0.0, 0.0, 0.0, CABLE_SIDE);
            tessellator.setNormal(0.0f, 1.0f, 0.0f);
            this.renderTopFace(tessellator, bounds, 0.0, 0.0, 0.0, CABLE_SIDE);
            tessellator.setNormal(0.0f, -1.0f, 0.0f);
            this.renderBottomFace(tessellator, bounds, 0.0, 0.0, 0.0, CABLE_SIDE);
            BlockModelCable.setBounds(bounds, CableShapes.SHAPE_CABLE_ARM.get(Direction.EAST));
            tessellator.setNormal(0.0f, 0.0f, -1.0f);
            this.renderNorthFace(tessellator, bounds, 0.0, 0.0, 0.0, CABLE_SIDE);
            tessellator.setNormal(0.0f, 0.0f, 1.0f);
            this.renderSouthFace(tessellator, bounds, 0.0, 0.0, 0.0, CABLE_SIDE);
            tessellator.setNormal(0.0f, 1.0f, 0.0f);
            this.renderTopFace(tessellator, bounds, 0.0, 0.0, 0.0, CABLE_SIDE);
            tessellator.setNormal(0.0f, -1.0f, 0.0f);
            this.renderBottomFace(tessellator, bounds, 0.0, 0.0, 0.0, CABLE_SIDE);
            tessellator.setNormal(1.0f, 0.0f, 0.0f);
            this.renderEastFace(tessellator, bounds, 0.0, 0.0, 0.0, CABLE_CORE);
            BlockModelCable.setBounds(bounds, CableShapes.SHAPE_CABLE_ARM.get(Direction.WEST));
            tessellator.setNormal(0.0f, 0.0f, -1.0f);
            this.renderNorthFace(tessellator, bounds, 0.0, 0.0, 0.0, CABLE_SIDE);
            tessellator.setNormal(0.0f, 0.0f, 1.0f);
            this.renderSouthFace(tessellator, bounds, 0.0, 0.0, 0.0, CABLE_SIDE);
            tessellator.setNormal(0.0f, 1.0f, 0.0f);
            this.renderTopFace(tessellator, bounds, 0.0, 0.0, 0.0, CABLE_SIDE);
            tessellator.setNormal(0.0f, -1.0f, 0.0f);
            this.renderBottomFace(tessellator, bounds, 0.0, 0.0, 0.0, CABLE_SIDE);
            tessellator.setNormal(-1.0f, 0.0f, 0.0f);
            this.renderWestFace(tessellator, bounds, 0.0, 0.0, 0.0, CABLE_CORE);
        }
        tessellator.draw();
        GL11.glTranslatef((float)0.5f, (float)yOffset, (float)0.5f);
    }

    public IconCoordinate getBlockTextureFromSideAndMetadata(Side side, int data) {
        return this.currentCoordinate;
    }
}

