/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.modem.wired;

import com.google.common.collect.ImmutableMap;
import dan200.computercraft.shared.peripheral.modem.ModemShapes;
import dan200.computercraft.shared.peripheral.modem.wired.TileCable;
import dan200.computercraft.shared.util.DirectionUtil;
import java.util.EnumMap;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.phys.AABB;

public final class CableShapes {
    private static final double MIN = 0.375;
    private static final double MAX = 0.625;
    public static final AABB SHAPE_CABLE_CORE = AABB.getPermanentBB((double)0.375, (double)0.375, (double)0.375, (double)0.625, (double)0.625, (double)0.625);
    public static final EnumMap<Direction, AABB> SHAPE_CABLE_ARM = new EnumMap<Direction, AABB>(new ImmutableMap.Builder<Direction, AABB>().put(Direction.DOWN, AABB.getPermanentBB((double)0.375, (double)0.0, (double)0.375, (double)0.625, (double)0.375, (double)0.625)).put(Direction.UP, AABB.getPermanentBB((double)0.375, (double)0.625, (double)0.375, (double)0.625, (double)1.0, (double)0.625)).put(Direction.NORTH, AABB.getPermanentBB((double)0.375, (double)0.375, (double)0.0, (double)0.625, (double)0.625, (double)0.375)).put(Direction.SOUTH, AABB.getPermanentBB((double)0.375, (double)0.375, (double)0.625, (double)0.625, (double)0.625, (double)1.0)).put(Direction.WEST, AABB.getPermanentBB((double)0.0, (double)0.375, (double)0.375, (double)0.375, (double)0.625, (double)0.625)).put(Direction.EAST, AABB.getPermanentBB((double)0.625, (double)0.375, (double)0.375, (double)1.0, (double)0.625, (double)0.625)).build());
    private static final AABB[] SHAPES = new AABB[448];
    private static final AABB[] CABLE_SHAPES = new AABB[64];

    private CableShapes() {
    }

    public static AABB getCableShape(TileCable state) {
        if (!state.blockStateCable) {
            return AABB.getPermanentBB((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
        }
        return CableShapes.getCableShape(CableShapes.getCableIndex(state));
    }

    private static AABB getCableShape(int index) {
        AABB shape = CABLE_SHAPES[index];
        if (shape != null) {
            return shape;
        }
        shape = SHAPE_CABLE_CORE;
        for (Direction facing : DirectionUtil.FACINGS) {
            if ((index & 1 << facing.ordinal()) == 0) continue;
            shape = CableShapes.union(shape, SHAPE_CABLE_ARM.get(facing));
        }
        CableShapes.CABLE_SHAPES[index] = shape;
        return CableShapes.CABLE_SHAPES[index];
    }

    private static int getCableIndex(TileCable state) {
        int index = 0;
        for (Direction facing : DirectionUtil.FACINGS) {
            boolean hasConnection = false;
            switch (facing) {
                case NORTH: {
                    hasConnection = state.blockStateNorth;
                    break;
                }
                case EAST: {
                    hasConnection = state.blockStateEast;
                    break;
                }
                case SOUTH: {
                    hasConnection = state.blockStateSouth;
                    break;
                }
                case WEST: {
                    hasConnection = state.blockStateWest;
                    break;
                }
                case UP: {
                    hasConnection = state.blockStateUp;
                    break;
                }
                case DOWN: {
                    hasConnection = state.blockStateDown;
                    break;
                }
            }
            if (!hasConnection) continue;
            index |= 1 << facing.ordinal();
        }
        return index;
    }

    public static AABB getShape(TileCable state) {
        Direction facing = state.blockStateModem.getFacing();
        if (!state.blockStateCable) {
            return CableShapes.getModemShape(state);
        }
        int cableIndex = CableShapes.getCableIndex(state);
        int index = cableIndex + ((facing == null ? 0 : facing.ordinal() + 1) << 6);
        AABB shape = SHAPES[index];
        if (shape != null) {
            return shape;
        }
        shape = CableShapes.getCableShape(cableIndex);
        if (facing != null) {
            shape = CableShapes.union(shape, ModemShapes.getBounds(facing));
        }
        CableShapes.SHAPES[index] = shape;
        return CableShapes.SHAPES[index];
    }

    public static AABB getModemShape(TileCable state) {
        Direction facing = state.blockStateModem.getFacing();
        return facing == null ? AABB.getPermanentBB((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0) : ModemShapes.getBounds(facing);
    }

    private static AABB union(AABB a, AABB b) {
        return AABB.getPermanentBB((double)Math.min(a.minX, b.minX), (double)Math.min(a.minY, b.minY), (double)Math.min(a.minZ, b.minZ), (double)Math.max(a.maxX, b.maxX), (double)Math.max(a.maxY, b.maxY), (double)Math.max(a.maxZ, b.maxZ));
    }
}

