/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.modem.wireless;

import dan200.computercraft.shared.peripheral.modem.ModemShapes;
import dan200.computercraft.shared.peripheral.modem.wireless.BlockLogicWirelessModem;
import net.minecraft.client.render.block.color.BlockColor;
import net.minecraft.client.render.block.color.BlockColorDispatcher;
import net.minecraft.client.render.block.model.BlockModelFullyRotatable;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.BlockLogicFullyRotatable;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.helper.Sides;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.WorldSource;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;

public class BlockModelWirelessModem<T extends BlockLogic>
extends BlockModelFullyRotatable<T> {
    public BlockModelWirelessModem(Block<T> block) {
        super(block);
    }

    public boolean render(Tessellator tessellator, int x, int y, int z) {
        return super.render(tessellator, x, y, z);
    }

    public void renderBlockOnInventory(Tessellator tessellator, int metadata, float brightness, float alpha, @Nullable Integer lightmapCoordinate) {
        Direction dir = BlockLogicFullyRotatable.metaToDirection((int)metadata);
        switch (dir) {
            case DOWN: {
                BlockModelWirelessModem.renderBlocks.uvRotateEast = 3;
                BlockModelWirelessModem.renderBlocks.uvRotateWest = 3;
                BlockModelWirelessModem.renderBlocks.uvRotateSouth = 3;
                BlockModelWirelessModem.renderBlocks.uvRotateNorth = 3;
                break;
            }
            case NORTH: {
                BlockModelWirelessModem.renderBlocks.uvRotateSouth = 1;
                BlockModelWirelessModem.renderBlocks.uvRotateNorth = 2;
                break;
            }
            case SOUTH: {
                BlockModelWirelessModem.renderBlocks.uvRotateSouth = 2;
                BlockModelWirelessModem.renderBlocks.uvRotateNorth = 1;
                BlockModelWirelessModem.renderBlocks.uvRotateTop = 3;
                BlockModelWirelessModem.renderBlocks.uvRotateBottom = 3;
                break;
            }
            case WEST: {
                BlockModelWirelessModem.renderBlocks.uvRotateEast = 1;
                BlockModelWirelessModem.renderBlocks.uvRotateWest = 2;
                BlockModelWirelessModem.renderBlocks.uvRotateTop = 2;
                BlockModelWirelessModem.renderBlocks.uvRotateBottom = 1;
                break;
            }
            case EAST: {
                BlockModelWirelessModem.renderBlocks.uvRotateEast = 2;
                BlockModelWirelessModem.renderBlocks.uvRotateWest = 1;
                BlockModelWirelessModem.renderBlocks.uvRotateTop = 1;
                BlockModelWirelessModem.renderBlocks.uvRotateBottom = 2;
            }
        }
        if (BlockModelWirelessModem.renderBlocks.useInventoryTint) {
            int color = ((BlockColor)BlockColorDispatcher.getInstance().getDispatch((Object)this.block)).getFallbackColor(metadata);
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g2 = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            GL11.glColor4f((float)(r * brightness), (float)(g2 * brightness), (float)(b * brightness), (float)alpha);
        } else {
            GL11.glColor4f((float)brightness, (float)brightness, (float)brightness, (float)alpha);
        }
        float yOffset = 0.5f;
        AABB bounds = ModemShapes.getBounds(BlockLogicWirelessModem.metaToDirection((int)metadata).getOpposite());
        GL11.glTranslatef((float)-0.5f, (float)(0.0f - yOffset), (float)-0.5f);
        this.renderBlockWithBounds(tessellator, bounds, metadata, brightness, alpha, lightmapCoordinate);
        GL11.glTranslatef((float)0.5f, (float)yOffset, (float)0.5f);
        this.resetRenderBlocks();
    }

    public IconCoordinate getBlockTexture(WorldSource blockAccess, int x, int y, int z, Side side) {
        boolean isOn;
        int currentMetadata = blockAccess.getBlockMetadata(x, y, z);
        int index = Sides.orientationLookUpHorizontal[6 * Math.min(currentMetadata & 7, 5) + side.getId()];
        if (index >= Sides.orientationLookUpHorizontal.length) {
            return this.blockTextures.get(Side.BOTTOM);
        }
        IconCoordinate originalFront = this.blockTextures.get(Side.NORTH);
        boolean bl = isOn = (currentMetadata >> 3 & 1) == 1;
        if (isOn) {
            return TextureRegistry.getTexture((String)(originalFront.namespaceId.namespace() + ":block/" + originalFront.namespaceId.value() + "_on"));
        }
        return originalFront;
    }
}

