/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.modem.wireless;

import com.mojang.nbt.tags.CompoundTag;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.peripheral.IPeripheralTile;
import dan200.computercraft.shared.common.TileGeneric;
import dan200.computercraft.shared.peripheral.modem.ModemPeripheral;
import dan200.computercraft.shared.peripheral.modem.ModemState;
import dan200.computercraft.shared.peripheral.modem.wireless.BlockLogicWirelessModem;
import dan200.computercraft.shared.peripheral.modem.wireless.WirelessModemPeripheral;
import dan200.computercraft.shared.util.TickScheduler;
import javax.annotation.Nonnull;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.phys.Vec3;
import net.minecraft.core.world.World;

public class TileWirelessModem
extends TileGeneric
implements IPeripheralTile {
    private static final String NBT_ADVANCED = "Advanced";
    private final ModemPeripheral modem;
    private boolean advanced;
    private boolean hasModemDirection = false;
    private Direction modemDirection = Direction.DOWN;
    private final boolean destroyed = false;

    public TileWirelessModem() {
        this(false);
    }

    public TileWirelessModem(boolean advanced) {
        this.advanced = advanced;
        this.modem = new Peripheral(this);
    }

    public void invalidate() {
        this.modem.destroy();
        super.invalidate();
    }

    public void tick() {
        Direction currentDirection = this.modemDirection;
        this.refreshDirection();
        if (this.modem.getModemState().pollChanged()) {
            this.updateBlockState();
        }
    }

    private void refreshDirection() {
        if (this.hasModemDirection) {
            return;
        }
        this.hasModemDirection = true;
        this.modemDirection = BlockLogicWirelessModem.metaToDirection((int)this.worldObj.getBlockMetadata(this.x, this.y, this.z)).getOpposite();
    }

    private void updateBlockState() {
        boolean isOn;
        boolean on = this.modem.getModemState().isOpen();
        int currentMetadata = this.getBlockMeta();
        boolean bl = isOn = (currentMetadata >> 3 & 1) == 1;
        if (isOn != on) {
            int newMetadata = currentMetadata & 0xFFFFFFF7 | (on ? 1 : 0) << 3;
            if (this.worldObj != null) {
                this.worldObj.setBlockMetadataWithNotify(this.x, this.y, this.z, newMetadata);
            }
        }
    }

    @Override
    @Nonnull
    public IPeripheral getPeripheral(Direction side) {
        this.refreshDirection();
        return side == this.modemDirection ? this.modem : null;
    }

    public void readFromNBT(CompoundTag nbt) {
        super.readFromNBT(nbt);
        this.advanced = nbt.getBoolean(NBT_ADVANCED);
    }

    public void writeToNBT(CompoundTag tag) {
        tag.putBoolean(NBT_ADVANCED, this.advanced);
        super.writeToNBT(tag);
    }

    private static class Peripheral
    extends WirelessModemPeripheral {
        private final TileWirelessModem entity;

        Peripheral(TileWirelessModem entity) {
            super(new ModemState(() -> TickScheduler.schedule(entity)), entity.advanced);
            this.entity = entity;
        }

        @Override
        @Nonnull
        public World getWorld() {
            return this.entity.worldObj;
        }

        @Override
        @Nonnull
        public Vec3 getPosition() {
            return Vec3.getPermanentVec3((double)(this.entity.x + this.entity.modemDirection.getOffsetX()), (double)(this.entity.y + this.entity.modemDirection.getOffsetY()), (double)(this.entity.z + this.entity.modemDirection.getOffsetZ()));
        }

        @Override
        @Nonnull
        public Object getTarget() {
            return this.entity;
        }

        @Override
        public boolean equals(IPeripheral other) {
            return this == other || other instanceof Peripheral && this.entity == ((Peripheral)other).entity;
        }
    }
}

