/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.modem.wireless;

import dan200.computercraft.ComputerCraft;
import dan200.computercraft.api.network.IPacketNetwork;
import dan200.computercraft.shared.peripheral.modem.ModemPeripheral;
import dan200.computercraft.shared.peripheral.modem.ModemState;
import dan200.computercraft.shared.peripheral.modem.wireless.WirelessNetwork;
import net.minecraft.core.util.phys.Vec3;
import net.minecraft.core.world.World;
import net.minecraft.core.world.weather.Weathers;

public abstract class WirelessModemPeripheral
extends ModemPeripheral {
    private final boolean advanced;

    public WirelessModemPeripheral(ModemState state, boolean advanced) {
        super(state);
        this.advanced = advanced;
    }

    @Override
    public double getRange() {
        if (this.advanced) {
            return 2.147483647E9;
        }
        World world = this.getWorld();
        if (world != null) {
            Vec3 position = this.getPosition();
            double minRange = ComputerCraft.modemRange;
            double maxRange = ComputerCraft.modemHighAltitudeRange;
            if (world.getCurrentWeather() != null && world.getCurrentWeather().weatherId == Weathers.OVERWORLD_STORM.weatherId) {
                minRange = ComputerCraft.modemRangeDuringStorm;
                maxRange = ComputerCraft.modemHighAltitudeRangeDuringStorm;
            }
            if (position.y > 96.0 && maxRange > minRange) {
                return minRange + (position.y - 96.0) * ((maxRange - minRange) / 159.0);
            }
            return minRange;
        }
        return 0.0;
    }

    @Override
    public boolean isInterdimensional() {
        return this.advanced;
    }

    @Override
    protected IPacketNetwork getNetwork() {
        return WirelessNetwork.getUniversal();
    }
}

