/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.modem.wireless;

import dan200.computercraft.api.network.IPacketNetwork;
import dan200.computercraft.api.network.IPacketReceiver;
import dan200.computercraft.api.network.IPacketSender;
import dan200.computercraft.api.network.Packet;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;

public class WirelessNetwork
implements IPacketNetwork {
    private static WirelessNetwork universalNetwork = null;
    private final Set<IPacketReceiver> receivers = Collections.newSetFromMap(new ConcurrentHashMap());

    public static WirelessNetwork getUniversal() {
        if (universalNetwork == null) {
            universalNetwork = new WirelessNetwork();
        }
        return universalNetwork;
    }

    public static void resetNetworks() {
        universalNetwork = null;
    }

    private static void tryTransmit(IPacketReceiver receiver, Packet packet, double range, boolean interdimensional) {
        IPacketSender sender = packet.getSender();
        if (receiver.getWorld() == sender.getWorld()) {
            double receiveRange = Math.max(range, receiver.getRange());
            double distanceSq = receiver.getPosition().distanceToSquared(sender.getPosition());
            if (interdimensional || receiver.isInterdimensional() || distanceSq <= receiveRange * receiveRange) {
                receiver.receiveSameDimension(packet, Math.sqrt(distanceSq));
            }
        } else if (interdimensional || receiver.isInterdimensional()) {
            receiver.receiveDifferentDimension(packet);
        }
    }

    @Override
    public void addReceiver(@Nonnull IPacketReceiver receiver) {
        Objects.requireNonNull(receiver, "device cannot be null");
        this.receivers.add(receiver);
    }

    @Override
    public void removeReceiver(@Nonnull IPacketReceiver receiver) {
        Objects.requireNonNull(receiver, "device cannot be null");
        this.receivers.remove(receiver);
    }

    @Override
    public boolean isWireless() {
        return true;
    }

    @Override
    public void transmitSameDimension(@Nonnull Packet packet, double range) {
        Objects.requireNonNull(packet, "packet cannot be null");
        for (IPacketReceiver device : this.receivers) {
            WirelessNetwork.tryTransmit(device, packet, range, false);
        }
    }

    @Override
    public void transmitInterdimensional(@Nonnull Packet packet) {
        Objects.requireNonNull(packet, "packet cannot be null");
        for (IPacketReceiver device : this.receivers) {
            WirelessNetwork.tryTransmit(device, packet, 0.0, true);
        }
    }
}

