/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.monitor;

import dan200.computercraft.fabric.Helper;
import dan200.computercraft.shared.peripheral.monitor.MonitorEdgeState;
import dan200.computercraft.shared.peripheral.monitor.TileMonitor;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.NotNull;

public class BlockLogicMonitor
extends BlockLogic {
    public BlockLogicMonitor(Block<?> block, boolean advanced) {
        super(block, Material.stone);
        block.withEntity(() -> new TileMonitor(advanced));
    }

    public static int facingToMeta(Direction direction) {
        switch (direction) {
            case EAST: {
                return 1;
            }
            case SOUTH: {
                return 2;
            }
            case WEST: {
                return 3;
            }
        }
        return 0;
    }

    public static Direction metaToFacing(int meta) {
        switch (meta & 3) {
            case 1: {
                return Direction.EAST;
            }
            case 2: {
                return Direction.SOUTH;
            }
            case 3: {
                return Direction.WEST;
            }
        }
        return Direction.NORTH;
    }

    public static int orientationToMeta(Direction direction) {
        switch (direction) {
            case UP: {
                return 4;
            }
            case DOWN: {
                return 8;
            }
        }
        return 0;
    }

    public static Direction metaToOrientation(int meta) {
        switch (meta >> 2 & 3) {
            case 1: {
                return Direction.UP;
            }
            case 2: {
                return Direction.DOWN;
            }
        }
        return Direction.NORTH;
    }

    public static int stateToMeta(MonitorEdgeState state) {
        return state.ordinal() << 4;
    }

    public static MonitorEdgeState metaToState(int meta) {
        return MonitorEdgeState.values()[meta >> 4 & 0xF];
    }

    public void onBlockPlacedOnSide(World world, int x, int y, int z, @NotNull Side side, double xPlaced, double yPlaced) {
        world.setBlockMetadataWithNotify(x, y, z, BlockLogicMonitor.facingToMeta(side.getDirection()) + BlockLogicMonitor.orientationToMeta(Direction.NORTH));
    }

    public void onBlockPlacedByMob(World world, int x, int y, int z, @NotNull Side side, Mob mob, double xPlaced, double yPlaced) {
        float pitch = mob.xRot;
        Direction orientation = pitch > 66.5f ? Direction.UP : (pitch < -66.5f ? Direction.DOWN : Direction.NORTH);
        Direction direction = mob.getHorizontalPlacementDirection(side).getOpposite();
        world.setBlockMetadataWithNotify(x, y, z, BlockLogicMonitor.facingToMeta(direction) + BlockLogicMonitor.orientationToMeta(orientation));
        TileEntity entity = world.getTileEntity(x, y, z);
        if (entity instanceof TileMonitor && !Helper.isClientWorld()) {
            TileMonitor monitor = (TileMonitor)entity;
            monitor.updateNeighbors();
        }
    }

    public boolean onBlockRightClicked(World world, int x, int y, int z, Player player, Side side, double xPlaced, double yPlaced) {
        return ((TileMonitor)world.getTileEntity(x, y, z)).onBlockRightClicked(player, side, xPlaced, yPlaced);
    }

    public void onBlockRemoved(World world, int x, int y, int z, int data) {
        super.onBlockRemoved(world, x, y, z, data);
        TileEntity entity = world.getTileEntity(x, y, z);
        if (entity instanceof TileMonitor && !Helper.isClientWorld()) {
            world.setBlockAndMetadataRaw(x, y, z, this.id(), data);
            TileMonitor monitor = (TileMonitor)entity;
            monitor.markDestroyed();
            world.setBlockRaw(x, y, z, 0);
        }
    }
}

