/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.monitor;

import dan200.computercraft.shared.peripheral.monitor.BlockLogicMonitor;
import dan200.computercraft.shared.peripheral.monitor.MonitorEdgeState;
import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.helper.Sides;
import net.minecraft.core.world.WorldSource;

public class BlockModelMonitor<T extends BlockLogic>
extends BlockModelStandard<T> {
    private final String texturePrefix;

    public BlockModelMonitor(Block<T> block, String texturePrefix) {
        super(block);
        this.texturePrefix = texturePrefix;
    }

    public boolean render(Tessellator tessellator, int x, int y, int z) {
        int meta = BlockModelMonitor.renderBlocks.blockAccess.getBlockMetadata(x, y, z);
        Direction dir = BlockLogicMonitor.metaToFacing(meta);
        Direction orientation = BlockLogicMonitor.metaToOrientation(meta);
        if (orientation == Direction.UP) {
            switch (dir) {
                case NORTH: {
                    BlockModelMonitor.renderBlocks.uvRotateSouth = 2;
                    BlockModelMonitor.renderBlocks.uvRotateNorth = 1;
                    BlockModelMonitor.renderBlocks.uvRotateTop = 3;
                    BlockModelMonitor.renderBlocks.uvRotateBottom = 3;
                    BlockModelMonitor.renderBlocks.uvRotateEast = 3;
                    break;
                }
                case SOUTH: {
                    BlockModelMonitor.renderBlocks.uvRotateSouth = 1;
                    BlockModelMonitor.renderBlocks.uvRotateNorth = 2;
                    BlockModelMonitor.renderBlocks.uvRotateWest = 3;
                    break;
                }
                case WEST: {
                    BlockModelMonitor.renderBlocks.uvRotateTop = 1;
                    BlockModelMonitor.renderBlocks.uvRotateBottom = 2;
                    BlockModelMonitor.renderBlocks.uvRotateEast = 2;
                    BlockModelMonitor.renderBlocks.uvRotateWest = 1;
                    BlockModelMonitor.renderBlocks.uvRotateNorth = 3;
                    break;
                }
                case EAST: {
                    BlockModelMonitor.renderBlocks.uvRotateTop = 2;
                    BlockModelMonitor.renderBlocks.uvRotateBottom = 1;
                    BlockModelMonitor.renderBlocks.uvRotateEast = 1;
                    BlockModelMonitor.renderBlocks.uvRotateWest = 2;
                    BlockModelMonitor.renderBlocks.uvRotateSouth = 3;
                }
            }
        } else if (orientation == Direction.DOWN) {
            switch (dir) {
                case NORTH: {
                    BlockModelMonitor.renderBlocks.uvRotateSouth = 1;
                    BlockModelMonitor.renderBlocks.uvRotateNorth = 2;
                    BlockModelMonitor.renderBlocks.uvRotateEast = 3;
                    break;
                }
                case SOUTH: {
                    BlockModelMonitor.renderBlocks.uvRotateSouth = 2;
                    BlockModelMonitor.renderBlocks.uvRotateNorth = 1;
                    BlockModelMonitor.renderBlocks.uvRotateWest = 3;
                    BlockModelMonitor.renderBlocks.uvRotateTop = 3;
                    BlockModelMonitor.renderBlocks.uvRotateBottom = 3;
                    break;
                }
                case WEST: {
                    BlockModelMonitor.renderBlocks.uvRotateTop = 2;
                    BlockModelMonitor.renderBlocks.uvRotateBottom = 1;
                    BlockModelMonitor.renderBlocks.uvRotateEast = 1;
                    BlockModelMonitor.renderBlocks.uvRotateWest = 2;
                    BlockModelMonitor.renderBlocks.uvRotateNorth = 3;
                    break;
                }
                case EAST: {
                    BlockModelMonitor.renderBlocks.uvRotateTop = 1;
                    BlockModelMonitor.renderBlocks.uvRotateBottom = 2;
                    BlockModelMonitor.renderBlocks.uvRotateEast = 2;
                    BlockModelMonitor.renderBlocks.uvRotateWest = 1;
                    BlockModelMonitor.renderBlocks.uvRotateSouth = 3;
                }
            }
        } else {
            switch (dir) {
                case NORTH: {
                    break;
                }
                case SOUTH: {
                    BlockModelMonitor.renderBlocks.uvRotateTop = 3;
                    BlockModelMonitor.renderBlocks.uvRotateBottom = 3;
                    break;
                }
                case WEST: {
                    BlockModelMonitor.renderBlocks.uvRotateTop = 2;
                    BlockModelMonitor.renderBlocks.uvRotateBottom = 1;
                    break;
                }
                case EAST: {
                    BlockModelMonitor.renderBlocks.uvRotateTop = 1;
                    BlockModelMonitor.renderBlocks.uvRotateBottom = 2;
                }
            }
        }
        boolean result = this.renderStandardBlock(tessellator, this.block.getBlockBoundsFromState(BlockModelMonitor.renderBlocks.blockAccess, x, y, z), x, y, z);
        this.resetRenderBlocks();
        return result;
    }

    public IconCoordinate getBlockTextureFromSideAndMetadata(Side side, int data) {
        int index = Sides.orientationLookUpHorizontal[6 * Math.min(data & 7, 5) + side.getId()];
        return index >= Sides.orientationLookUpHorizontal.length ? this.blockTextures.get(Side.BOTTOM) : super.getBlockTextureFromSideAndMetadata(Side.getSideById((int)index), data);
    }

    public IconCoordinate getBlockTexture(WorldSource blockAccess, int x, int y, int z, Side side) {
        int currentMetadata = blockAccess.getBlockMetadata(x, y, z);
        Direction facing = BlockLogicMonitor.metaToFacing(currentMetadata);
        int index = Sides.orientationLookUpHorizontal[6 * Math.min(facing.getId(), 5) + side.getId()];
        MonitorEdgeState edgeState = BlockLogicMonitor.metaToState(currentMetadata);
        Direction orientation = BlockLogicMonitor.metaToOrientation(currentMetadata);
        if (index >= Sides.orientationLookUpHorizontal.length) {
            return this.blockTextures.get(Side.BOTTOM);
        }
        Side orientedSide = Side.getSideById((int)index);
        IconCoordinate originalFront = this.blockTextures.get(Side.NORTH);
        if (orientation == Direction.UP) {
            switch (orientedSide) {
                case NORTH: {
                    orientedSide = Side.BOTTOM;
                    break;
                }
                case BOTTOM: {
                    orientedSide = Side.SOUTH;
                    break;
                }
                case SOUTH: {
                    orientedSide = Side.TOP;
                    break;
                }
                case TOP: {
                    orientedSide = Side.NORTH;
                }
            }
        } else if (orientation == Direction.DOWN) {
            switch (orientedSide) {
                case NORTH: {
                    orientedSide = Side.TOP;
                    break;
                }
                case TOP: {
                    orientedSide = Side.SOUTH;
                    break;
                }
                case SOUTH: {
                    orientedSide = Side.BOTTOM;
                    break;
                }
                case BOTTOM: {
                    orientedSide = Side.NORTH;
                }
            }
            if (orientedSide == Side.NORTH && facing != Direction.SOUTH) {
                switch (edgeState) {
                    case NONE: {
                        break;
                    }
                    case L: {
                        edgeState = MonitorEdgeState.R;
                        break;
                    }
                    case R: {
                        edgeState = MonitorEdgeState.L;
                        break;
                    }
                    case LR: {
                        break;
                    }
                    case U: {
                        break;
                    }
                    case D: {
                        break;
                    }
                    case UD: {
                        break;
                    }
                    case RD: {
                        edgeState = MonitorEdgeState.LD;
                        break;
                    }
                    case LD: {
                        edgeState = MonitorEdgeState.RD;
                        break;
                    }
                    case RU: {
                        edgeState = MonitorEdgeState.LU;
                        break;
                    }
                    case LU: {
                        edgeState = MonitorEdgeState.RU;
                        break;
                    }
                    case LRD: {
                        break;
                    }
                    case RUD: {
                        edgeState = MonitorEdgeState.LUD;
                        break;
                    }
                    case LUD: {
                        edgeState = MonitorEdgeState.RUD;
                        break;
                    }
                    case LRU: {
                        break;
                    }
                }
            }
        }
        switch (edgeState) {
            case NONE: {
                switch (orientedSide) {
                    case NORTH: {
                        return TextureRegistry.getTexture((String)(this.texturePrefix + "_16"));
                    }
                    case BOTTOM: 
                    case TOP: {
                        return TextureRegistry.getTexture((String)(this.texturePrefix + "_0"));
                    }
                    case SOUTH: {
                        return TextureRegistry.getTexture((String)(this.texturePrefix + "_4"));
                    }
                }
                return TextureRegistry.getTexture((String)(this.texturePrefix + "_4"));
            }
            case L: {
                switch (orientedSide) {
                    case NORTH: {
                        return TextureRegistry.getTexture((String)(this.texturePrefix + "_19"));
                    }
                    case BOTTOM: 
                    case TOP: {
                        return TextureRegistry.getTexture((String)(this.texturePrefix + "_1"));
                    }
                    case SOUTH: {
                        return TextureRegistry.getTexture((String)(this.texturePrefix + "_33"));
                    }
                }
                return TextureRegistry.getTexture((String)(this.texturePrefix + "_4"));
            }
            case R: {
                switch (orientedSide) {
                    case NORTH: {
                        return TextureRegistry.getTexture((String)(this.texturePrefix + "_17"));
                    }
                    case BOTTOM: 
                    case TOP: {
                        return TextureRegistry.getTexture((String)(this.texturePrefix + "_3"));
                    }
                    case SOUTH: {
                        return TextureRegistry.getTexture((String)(this.texturePrefix + "_35"));
                    }
                }
                return TextureRegistry.getTexture((String)(this.texturePrefix + "_4"));
            }
            case LR: {
                switch (orientedSide) {
                    case NORTH: {
                        return TextureRegistry.getTexture((String)(this.texturePrefix + "_18"));
                    }
                    case BOTTOM: 
                    case TOP: {
                        return TextureRegistry.getTexture((String)(this.texturePrefix + "_2"));
                    }
                    case SOUTH: {
                        return TextureRegistry.getTexture((String)(this.texturePrefix + "_34"));
                    }
                }
                return TextureRegistry.getTexture((String)(this.texturePrefix + "_4"));
            }
            case U: {
                switch (orientedSide) {
                    case NORTH: {
                        return TextureRegistry.getTexture((String)(this.texturePrefix + "_22"));
                    }
                    case BOTTOM: 
                    case TOP: {
                        return TextureRegistry.getTexture((String)(this.texturePrefix + "_0"));
                    }
                    case SOUTH: {
                        return TextureRegistry.getTexture((String)(this.texturePrefix + "_38"));
                    }
                }
                return TextureRegistry.getTexture((String)(this.texturePrefix + "_38"));
            }
            case D: {
                switch (orientedSide) {
                    case NORTH: {
                        return TextureRegistry.getTexture((String)(this.texturePrefix + "_20"));
                    }
                    case BOTTOM: 
                    case TOP: {
                        return TextureRegistry.getTexture((String)(this.texturePrefix + "_0"));
                    }
                    case SOUTH: {
                        return TextureRegistry.getTexture((String)(this.texturePrefix + "_36"));
                    }
                }
                return TextureRegistry.getTexture((String)(this.texturePrefix + "_36"));
            }
            case UD: {
                switch (orientedSide) {
                    case NORTH: {
                        return TextureRegistry.getTexture((String)(this.texturePrefix + "_21"));
                    }
                    case BOTTOM: 
                    case TOP: {
                        return TextureRegistry.getTexture((String)(this.texturePrefix + "_0"));
                    }
                    case SOUTH: {
                        return TextureRegistry.getTexture((String)(this.texturePrefix + "_37"));
                    }
                }
                return TextureRegistry.getTexture((String)(this.texturePrefix + "_37"));
            }
            case RD: {
                switch (orientedSide) {
                    case NORTH: {
                        return TextureRegistry.getTexture((String)(this.texturePrefix + "_29"));
                    }
                    case BOTTOM: 
                    case TOP: {
                        return TextureRegistry.getTexture((String)(this.texturePrefix + "_3"));
                    }
                    case SOUTH: {
                        return TextureRegistry.getTexture((String)(this.texturePrefix + "_47"));
                    }
                }
                return TextureRegistry.getTexture((String)(this.texturePrefix + "_7"));
            }
            case LD: {
                switch (orientedSide) {
                    case NORTH: {
                        return TextureRegistry.getTexture((String)(this.texturePrefix + "_31"));
                    }
                    case BOTTOM: 
                    case TOP: {
                        return TextureRegistry.getTexture((String)(this.texturePrefix + "_1"));
                    }
                    case SOUTH: {
                        return TextureRegistry.getTexture((String)(this.texturePrefix + "_45"));
                    }
                }
                return TextureRegistry.getTexture((String)(this.texturePrefix + "_7"));
            }
            case RU: {
                switch (orientedSide) {
                    case NORTH: {
                        return TextureRegistry.getTexture((String)(this.texturePrefix + "_23"));
                    }
                    case BOTTOM: 
                    case TOP: {
                        return TextureRegistry.getTexture((String)(this.texturePrefix + "_3"));
                    }
                    case SOUTH: {
                        return TextureRegistry.getTexture((String)(this.texturePrefix + "_41"));
                    }
                }
                return TextureRegistry.getTexture((String)(this.texturePrefix + "_38"));
            }
            case LU: {
                switch (orientedSide) {
                    case NORTH: {
                        return TextureRegistry.getTexture((String)(this.texturePrefix + "_25"));
                    }
                    case BOTTOM: 
                    case TOP: {
                        return TextureRegistry.getTexture((String)(this.texturePrefix + "_1"));
                    }
                    case SOUTH: {
                        return TextureRegistry.getTexture((String)(this.texturePrefix + "_39"));
                    }
                }
                return TextureRegistry.getTexture((String)(this.texturePrefix + "_38"));
            }
            case LRD: {
                switch (orientedSide) {
                    case NORTH: {
                        return TextureRegistry.getTexture((String)(this.texturePrefix + "_30"));
                    }
                    case BOTTOM: 
                    case TOP: {
                        return TextureRegistry.getTexture((String)(this.texturePrefix + "_2"));
                    }
                    case SOUTH: {
                        return TextureRegistry.getTexture((String)(this.texturePrefix + "_46"));
                    }
                }
                return TextureRegistry.getTexture((String)(this.texturePrefix + "_7"));
            }
            case RUD: {
                switch (orientedSide) {
                    case NORTH: {
                        return TextureRegistry.getTexture((String)(this.texturePrefix + "_26"));
                    }
                    case BOTTOM: 
                    case TOP: {
                        return TextureRegistry.getTexture((String)(this.texturePrefix + "_3"));
                    }
                    case SOUTH: {
                        return TextureRegistry.getTexture((String)(this.texturePrefix + "_44"));
                    }
                }
                return TextureRegistry.getTexture((String)(this.texturePrefix + "_37"));
            }
            case LUD: {
                switch (orientedSide) {
                    case NORTH: {
                        return TextureRegistry.getTexture((String)(this.texturePrefix + "_28"));
                    }
                    case BOTTOM: 
                    case TOP: {
                        return TextureRegistry.getTexture((String)(this.texturePrefix + "_1"));
                    }
                    case SOUTH: {
                        return TextureRegistry.getTexture((String)(this.texturePrefix + "_42"));
                    }
                }
                return TextureRegistry.getTexture((String)(this.texturePrefix + "_37"));
            }
            case LRU: {
                switch (orientedSide) {
                    case NORTH: {
                        return TextureRegistry.getTexture((String)(this.texturePrefix + "_24"));
                    }
                    case BOTTOM: 
                    case TOP: {
                        return TextureRegistry.getTexture((String)(this.texturePrefix + "_2"));
                    }
                    case SOUTH: {
                        return TextureRegistry.getTexture((String)(this.texturePrefix + "_40"));
                    }
                }
                return TextureRegistry.getTexture((String)(this.texturePrefix + "_38"));
            }
            case LRUD: {
                switch (orientedSide) {
                    case NORTH: {
                        return TextureRegistry.getTexture((String)(this.texturePrefix + "_27"));
                    }
                    case BOTTOM: 
                    case TOP: {
                        return TextureRegistry.getTexture((String)(this.texturePrefix + "_2"));
                    }
                    case SOUTH: {
                        return TextureRegistry.getTexture((String)(this.texturePrefix + "_43"));
                    }
                }
                return TextureRegistry.getTexture((String)(this.texturePrefix + "_37"));
            }
        }
        return originalFront;
    }
}

