/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.monitor;

import dan200.computercraft.client.gui.FixedWidthFontRenderer;
import dan200.computercraft.shared.common.ClientTerminal;
import dan200.computercraft.shared.peripheral.monitor.MonitorRenderer;
import dan200.computercraft.shared.peripheral.monitor.TileMonitor;
import dan200.computercraft.shared.util.BlockPos;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.GLAllocation;
import net.minecraft.client.render.tessellator.Tessellator;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL15;

@Environment(value=EnvType.CLIENT)
public final class ClientMonitor
extends ClientTerminal {
    private static final Set<ClientMonitor> allMonitors = new HashSet<ClientMonitor>();
    private final TileMonitor origin;
    public long lastRenderFrame = -1L;
    public BlockPos lastRenderPos = null;
    public int tboBuffer;
    public int tboTexture;
    public int displayList;
    public boolean displayListCompiled = false;

    public ClientMonitor(boolean colour, TileMonitor origin) {
        super(colour);
        this.origin = origin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Environment(value=EnvType.CLIENT)
    public static void destroyAll() {
        Set<ClientMonitor> set = allMonitors;
        synchronized (set) {
            Iterator<ClientMonitor> iterator = allMonitors.iterator();
            while (iterator.hasNext()) {
                ClientMonitor monitor = iterator.next();
                monitor.deleteBuffers();
                iterator.remove();
            }
        }
    }

    public TileMonitor getOrigin() {
        return this.origin;
    }

    @Environment(value=EnvType.CLIENT)
    public boolean createBuffer(MonitorRenderer renderer, float xMargin, float yMargin) {
        switch (renderer) {
            case DisplayList: {
                if (this.displayListCompiled) {
                    return false;
                }
                this.deleteBuffers();
                this.displayList = GLAllocation.generateDisplayLists((int)1);
                GL11.glNewList((int)this.displayList, (int)4864);
                Tessellator tessellator = Tessellator.instance;
                FixedWidthFontRenderer.drawTerminalWithoutCursor(0.0f, 0.0f, this.getTerminal(), !this.isColour(), yMargin, yMargin, xMargin, xMargin);
                GL11.glEndList();
                this.displayListCompiled = true;
                this.addMonitor();
                return true;
            }
        }
        return false;
    }

    private void deleteBuffers() {
        if (this.tboBuffer != 0) {
            GL15.glDeleteBuffers((int)this.tboBuffer);
            this.tboBuffer = 0;
        }
        if (this.tboTexture != 0) {
            GL15.glDeleteTextures((int)this.tboTexture);
            this.tboTexture = 0;
        }
        if (this.displayList != 0) {
            GL11.glDeleteLists((int)this.displayList, (int)1);
            this.displayList = 0;
            this.displayListCompiled = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addMonitor() {
        Set<ClientMonitor> set = allMonitors;
        synchronized (set) {
            allMonitors.add(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Environment(value=EnvType.CLIENT)
    public void destroy() {
        if (this.tboBuffer != 0) {
            Set<ClientMonitor> set = allMonitors;
            synchronized (set) {
                allMonitors.remove(this);
            }
            this.deleteBuffers();
        }
    }
}

