/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.monitor;

import javax.annotation.Nonnull;

public enum MonitorEdgeState {
    NONE("none", 0),
    L("l", 4),
    R("r", 8),
    LR("lr", 12),
    U("u", 1),
    D("d", 2),
    UD("ud", 3),
    RD("rd", 10),
    LD("ld", 6),
    RU("ru", 9),
    LU("lu", 5),
    LRD("lrd", 14),
    RUD("rud", 11),
    LUD("lud", 7),
    LRU("lru", 13),
    LRUD("lrud", 15);

    private static final MonitorEdgeState[] BY_FLAG;
    private final String name;
    private final int flags;

    private MonitorEdgeState(String name, int flags) {
        this.name = name;
        this.flags = flags;
    }

    public static MonitorEdgeState fromConnections(boolean up, boolean down, boolean left, boolean right) {
        return BY_FLAG[(up ? 1 : 0) | (down ? 2 : 0) | (left ? 4 : 0) | (right ? 8 : 0)];
    }

    @Nonnull
    public String asString() {
        return this.name;
    }

    static {
        BY_FLAG = new MonitorEdgeState[16];
        MonitorEdgeState[] monitorEdgeStateArray = MonitorEdgeState.values();
        int n = monitorEdgeStateArray.length;
        for (int i = 0; i < n; ++i) {
            MonitorEdgeState state;
            MonitorEdgeState.BY_FLAG[state.flags] = state = monitorEdgeStateArray[i];
        }
    }

    static final class Flags {
        static final int UP = 1;
        static final int DOWN = 2;
        static final int LEFT = 4;
        static final int RIGHT = 8;

        Flags() {
        }
    }
}

