/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.monitor;

import dan200.computercraft.ComputerCraft;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.fabricmc.loader.api.FabricLoader;
import org.lwjgl.opengl.GL;

public enum MonitorRenderer {
    BEST,
    DisplayList;

    private static boolean initialised;
    private static boolean textureBuffer;
    private static boolean shaderMod;
    private static final List<String> shaderModIds;

    @Nonnull
    public static MonitorRenderer current() {
        MonitorRenderer current = ComputerCraft.monitorRenderer;
        switch (current) {
            case BEST: {
                return MonitorRenderer.best();
            }
        }
        return current;
    }

    private static MonitorRenderer best() {
        if (!initialised) {
            MonitorRenderer.checkCapabilities();
            MonitorRenderer.checkForShaderMods();
            if (textureBuffer && shaderMod) {
                ComputerCraft.log.warn("Shader mod detected. Enabling DisplayList renderer for compatibility.");
            }
            initialised = true;
        }
        return DisplayList;
    }

    private static void checkCapabilities() {
        textureBuffer = GL.getCapabilities().OpenGL31;
    }

    private static void checkForShaderMods() {
        shaderMod = FabricLoader.getInstance().getAllMods().stream().map(modContainer -> modContainer.getMetadata().getId()).anyMatch(id -> shaderModIds.contains(id));
    }

    static {
        initialised = false;
        textureBuffer = false;
        shaderMod = false;
        shaderModIds = Collections.singletonList("optifabric");
    }
}

