/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.monitor;

import dan200.computercraft.client.FrameInfo;
import dan200.computercraft.client.gui.FixedWidthFontRenderer;
import dan200.computercraft.core.terminal.Terminal;
import dan200.computercraft.shared.peripheral.monitor.ClientMonitor;
import dan200.computercraft.shared.peripheral.monitor.MonitorRenderer;
import dan200.computercraft.shared.peripheral.monitor.TileMonitor;
import dan200.computercraft.shared.util.BlockPos;
import dan200.computercraft.shared.util.DirectionUtil;
import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.tileentity.TileEntityRenderer;
import net.minecraft.core.util.helper.Direction;
import org.lwjgl.opengl.GL11;

public class TileEntityMonitorRenderer
extends TileEntityRenderer<TileMonitor> {
    private static final float MARGIN = 0.034375f;

    private static void renderTerminal(ClientMonitor monitor, float xMargin, float yMargin) {
        MonitorRenderer renderType = MonitorRenderer.current();
        boolean redraw = monitor.pollTerminalChanged();
        if (redraw) {
            monitor.displayListCompiled = false;
        }
        monitor.createBuffer(renderType, xMargin, yMargin);
        switch (renderType) {
            case DisplayList: {
                if (!monitor.displayListCompiled) break;
                GL11.glCallList((int)monitor.displayList);
            }
        }
    }

    public void doRender(Tessellator tessellator, TileMonitor monitor, double x, double y, double z, float partialTick) {
        ClientMonitor originTerminal = monitor.getClientMonitor();
        if (originTerminal == null) {
            return;
        }
        TileMonitor origin = originTerminal.getOrigin();
        BlockPos monitorPos = monitor.getPos();
        long renderFrame = FrameInfo.getRenderFrame();
        if (originTerminal.lastRenderFrame == renderFrame && !monitorPos.equals(originTerminal.lastRenderPos)) {
            return;
        }
        originTerminal.lastRenderFrame = renderFrame;
        originTerminal.lastRenderPos = monitorPos;
        BlockPos originPos = origin.getPos();
        Direction dir = origin.getDirection();
        Direction front = origin.getFront();
        float yaw = DirectionUtil.getRotationYaw(dir);
        float pitch = DirectionUtil.toPitchAngle(front);
        GL11.glPushMatrix();
        if (LightmapHelper.isLightmapEnabled()) {
            LightmapHelper.setLightmapCoord((int)LightmapHelper.getLightmapCoord((int)15, (int)15));
        }
        GL11.glEnable((int)32826);
        GL11.glDisable((int)2896);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
        GL11.glTranslatef((float)((float)(originPos.getX() - monitorPos.getX()) + 0.5f), (float)((float)(originPos.getY() - monitorPos.getY()) + 0.5f), (float)((float)(originPos.getZ() - monitorPos.getZ()) + 0.5f));
        GL11.glRotatef((float)(-yaw), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)pitch, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glTranslatef((float)-0.34375f, (float)((float)((double)((float)origin.getHeight() - 0.5f) - 0.15625)), (float)0.5f);
        double xSize = (double)origin.getWidth() - 0.3125;
        double ySize = (double)origin.getHeight() - 0.3125;
        FixedWidthFontRenderer.drawBlocker(tessellator, -0.03125f, 0.03125f, (float)(xSize + 0.0625), (float)(-(ySize + 0.0625)));
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)0.001f);
        Terminal terminal = originTerminal.getTerminal();
        if (terminal != null) {
            int width = terminal.getWidth();
            int height = terminal.getHeight();
            int pixelWidth = width * 6;
            int pixelHeight = height * 9;
            double xScale = xSize / (double)pixelWidth;
            double yScale = ySize / (double)pixelHeight;
            GL11.glPushMatrix();
            GL11.glScalef((float)((float)xScale), (float)((float)(-yScale)), (float)1.0f);
            GL11.glDepthMask((boolean)false);
            TileEntityMonitorRenderer.renderTerminal(originTerminal, (float)((double)0.034375f / xScale), (float)((double)0.034375f / yScale));
            GL11.glDepthMask((boolean)true);
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)0.001f);
            FixedWidthFontRenderer.drawCursor(0.0f, 0.0f, terminal, !originTerminal.isColour());
            GL11.glPopMatrix();
        } else {
            FixedWidthFontRenderer.drawEmptyTerminal(tessellator, -0.034375f, 0.034375f, (float)(xSize + (double)0.06875f), (float)(-(ySize + (double)0.06875f)));
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)32826);
        GL11.glEnable((int)2896);
        GL11.glPopMatrix();
    }
}

