/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.monitor;

import com.mojang.nbt.tags.CompoundTag;
import dan200.computercraft.ComputerCraft;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.peripheral.IPeripheralTile;
import dan200.computercraft.core.terminal.Terminal;
import dan200.computercraft.fabric.Helper;
import dan200.computercraft.shared.common.TileGeneric;
import dan200.computercraft.shared.network.client.TerminalState;
import dan200.computercraft.shared.peripheral.monitor.BlockLogicMonitor;
import dan200.computercraft.shared.peripheral.monitor.ClientMonitor;
import dan200.computercraft.shared.peripheral.monitor.MonitorEdgeState;
import dan200.computercraft.shared.peripheral.monitor.MonitorPeripheral;
import dan200.computercraft.shared.peripheral.monitor.ServerMonitor;
import dan200.computercraft.shared.peripheral.monitor.XYPair;
import dan200.computercraft.shared.util.BlockPos;
import dan200.computercraft.shared.util.DirectionUtil;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.net.packet.Packet;
import net.minecraft.core.net.packet.PacketTileEntityData;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.HitResult;
import net.minecraft.core.world.World;

public class TileMonitor
extends TileGeneric
implements IPeripheralTile {
    public static final double RENDER_BORDER = 0.125;
    public static final double RENDER_MARGIN = 0.03125;
    public static final double RENDER_PIXEL_SCALE = 0.015625;
    private static final String NBT_X = "XIndex";
    private static final String NBT_Y = "YIndex";
    private static final String NBT_WIDTH = "Width";
    private static final String NBT_HEIGHT = "Height";
    private static final String NBT_ADVANCED = "Advanced";
    private final Set<IComputerAccess> computers = new HashSet<IComputerAccess>();
    private boolean advanced;
    private ServerMonitor serverMonitor;
    private ClientMonitor clientMonitor;
    private MonitorPeripheral peripheral;
    private boolean needsUpdate = false;
    private boolean destroyed = false;
    private boolean visiting = false;
    private int width = 1;
    private int height = 1;
    private int xIndex = 0;
    private int yIndex = 0;

    public TileMonitor() {
    }

    public TileMonitor(boolean advanced) {
        this.advanced = advanced;
    }

    public void invalidate() {
        super.invalidate();
        if (this.clientMonitor != null && this.xIndex == 0 && this.yIndex == 0) {
            this.clientMonitor.destroy();
        }
    }

    public void markDestroyed() {
        if (this.destroyed) {
            return;
        }
        this.destroyed = true;
        if (!Helper.isClientWorld()) {
            this.contractNeighbours();
        }
    }

    @Override
    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        if (this.clientMonitor != null && this.xIndex == 0 && this.yIndex == 0) {
            this.clientMonitor.destroy();
        }
        this.clientMonitor = null;
    }

    public boolean onBlockRightClicked(Player player, Side side, double xPlaced, double yPlaced) {
        if (!player.isSneaking() && this.getFront() == side.getDirection()) {
            HitResult hit;
            if (!Helper.isClientWorld() && (hit = player.rayTrace(player.distanceTo((double)this.x, (double)this.y, (double)this.z), 0.0f, false, false)) != null) {
                this.monitorTouched((float)(hit.location.x - (double)hit.x), (float)(hit.location.y - (double)hit.y), (float)(hit.location.z - (double)hit.z));
            }
            return true;
        }
        return false;
    }

    public void tick() {
        if (this.needsUpdate) {
            this.needsUpdate = false;
            this.updateNeighbors();
        }
        if (this.xIndex != 0 || this.yIndex != 0 || this.serverMonitor == null) {
            return;
        }
        this.serverMonitor.clearChanged();
        if (this.serverMonitor.pollResized()) {
            for (int x = 0; x < this.width; ++x) {
                for (int y = 0; y < this.height; ++y) {
                    TileMonitor monitor = this.getNeighbour(x, y);
                    if (monitor == null) continue;
                    for (IComputerAccess computer : monitor.computers) {
                        computer.queueEvent("monitor_resize", computer.getAttachmentName());
                    }
                }
            }
        }
        if (this.serverMonitor.pollTerminalChanged()) {
            this.updateBlock();
        }
        if (Helper.isSinglePlayer()) {
            if (this.clientMonitor == null) {
                this.clientMonitor = new ClientMonitor(this.advanced, this);
            }
            this.clientMonitor.read(this.serverMonitor.write());
        }
    }

    public Packet getDescriptionPacket() {
        return new PacketTileEntityData((TileEntity)this);
    }

    private TileMonitor getNeighbour(int x, int y) {
        BlockPos pos = this.getPos();
        Direction right = this.getRight();
        Direction down = this.getDown();
        int xOffset = -this.xIndex + x;
        int yOffset = -this.yIndex + y;
        return this.getSimilarMonitorAt(pos.offset(right, xOffset).offset(down, yOffset));
    }

    public BlockPos getPos() {
        return new BlockPos(this.x, this.y, this.z);
    }

    public Direction getRight() {
        return DirectionUtil.rotateYCounterclockwise(this.getDirection());
    }

    public Direction getDown() {
        Direction orientation = this.getOrientation();
        if (orientation == Direction.NORTH) {
            return Direction.UP;
        }
        return orientation == Direction.DOWN ? this.getDirection() : this.getDirection().getOpposite();
    }

    private TileMonitor getSimilarMonitorAt(BlockPos pos) {
        if (pos.equals(this.getPos())) {
            return this;
        }
        int y = pos.getY();
        World world = this.worldObj;
        if (world == null || !world.isChunkLoaded(Math.floorDiv(pos.x, 16), Math.floorDiv(pos.z, 16))) {
            return null;
        }
        TileEntity tile = world.getTileEntity(pos.x, pos.y, pos.z);
        if (!(tile instanceof TileMonitor)) {
            return null;
        }
        TileMonitor monitor = (TileMonitor)tile;
        return !monitor.visiting && !monitor.destroyed && this.advanced == monitor.advanced && this.getDirection() == monitor.getDirection() && this.getOrientation() == monitor.getOrientation() ? monitor : null;
    }

    public Direction getDirection() {
        return BlockLogicMonitor.metaToFacing(this.getBlockMeta());
    }

    public Direction getOrientation() {
        return BlockLogicMonitor.metaToOrientation(this.getBlockMeta());
    }

    public void readFromNBT(CompoundTag nbt) {
        super.readFromNBT(nbt);
        int oldXIndex = this.xIndex;
        int oldYIndex = this.yIndex;
        int oldWidth = this.width;
        int oldHeight = this.height;
        this.xIndex = nbt.getInteger(NBT_X);
        this.yIndex = nbt.getInteger(NBT_Y);
        this.width = nbt.getInteger(NBT_WIDTH);
        this.height = nbt.getInteger(NBT_HEIGHT);
        this.advanced = nbt.getBoolean(NBT_ADVANCED);
        if (!Helper.isServerEnvironment()) {
            if (oldXIndex != this.xIndex || oldYIndex != this.yIndex) {
                if (oldXIndex == 0 && oldYIndex == 0 && this.clientMonitor != null) {
                    this.clientMonitor.destroy();
                }
                this.clientMonitor = null;
            }
            if (this.xIndex == 0 && this.yIndex == 0) {
                if (this.clientMonitor == null) {
                    this.clientMonitor = new ClientMonitor(this.advanced, this);
                }
                this.clientMonitor.readDescription(nbt);
            }
        }
        if (Helper.isClientWorld() && (this.xIndex != 0 || this.yIndex != 0)) {
            BlockPos pos = this.getPos().offset(this.getRight(), -this.xIndex).offset(this.getDown(), -this.yIndex);
            TileEntity te = this.worldObj.getTileEntity(pos.x, pos.y, pos.z);
            if (!(te instanceof TileMonitor)) {
                this.clientMonitor = null;
            }
            if (this.clientMonitor != ((TileMonitor)te).clientMonitor) {
                this.clientMonitor = ((TileMonitor)te).clientMonitor;
            }
        }
        if (oldXIndex != this.xIndex || oldYIndex != this.yIndex || oldWidth != this.width || oldHeight != this.height) {
            this.updateBlock();
        }
    }

    public void writeToNBT(CompoundTag tag) {
        tag.putInt(NBT_X, this.xIndex);
        tag.putInt(NBT_Y, this.yIndex);
        tag.putInt(NBT_WIDTH, this.width);
        tag.putInt(NBT_HEIGHT, this.height);
        tag.putBoolean(NBT_ADVANCED, this.advanced);
        if (this.xIndex == 0 && this.yIndex == 0 && this.serverMonitor != null) {
            this.serverMonitor.writeDescription(tag);
        }
        super.writeToNBT(tag);
    }

    @Override
    @Nonnull
    public IPeripheral getPeripheral(Direction side) {
        this.createServerMonitor();
        if (this.peripheral == null) {
            this.peripheral = new MonitorPeripheral(this);
        }
        return this.peripheral;
    }

    public ServerMonitor getCachedServerMonitor() {
        return this.serverMonitor;
    }

    private ServerMonitor getServerMonitor() {
        if (this.serverMonitor != null) {
            return this.serverMonitor;
        }
        TileMonitor origin = this.getOrigin();
        if (origin == null) {
            return null;
        }
        this.serverMonitor = origin.serverMonitor;
        return this.serverMonitor;
    }

    private ServerMonitor createServerMonitor() {
        if (this.serverMonitor != null) {
            return this.serverMonitor;
        }
        if (this.xIndex == 0 && this.yIndex == 0) {
            this.serverMonitor = new ServerMonitor(this.advanced, this);
            this.clientMonitor = null;
            this.serverMonitor.rebuild();
            for (int x = 0; x < this.width; ++x) {
                for (int y = 0; y < this.height; ++y) {
                    TileMonitor monitor = this.getNeighbour(x, y);
                    if (monitor == null) continue;
                    monitor.serverMonitor = this.serverMonitor;
                }
            }
            return this.serverMonitor;
        }
        BlockPos pos = this.getPos().offset(this.getRight(), -this.xIndex).offset(this.getDown(), -this.yIndex);
        TileEntity te = this.worldObj.getTileEntity(pos.x, pos.y, pos.z);
        if (!(te instanceof TileMonitor)) {
            return null;
        }
        this.serverMonitor = ((TileMonitor)te).createServerMonitor();
        return this.serverMonitor;
    }

    public ClientMonitor getClientMonitor() {
        if (this.clientMonitor != null) {
            return this.clientMonitor;
        }
        BlockPos pos = this.getPos().offset(this.getRight(), -this.xIndex).offset(this.getDown(), -this.yIndex);
        TileEntity te = this.worldObj.getTileEntity(pos.x, pos.y, pos.z);
        if (!(te instanceof TileMonitor)) {
            return null;
        }
        this.clientMonitor = ((TileMonitor)te).clientMonitor;
        return this.clientMonitor;
    }

    public final void read(TerminalState state) {
        if (this.xIndex != 0 || this.yIndex != 0) {
            ComputerCraft.log.warn("Receiving monitor state for non-origin terminal at {}", (Object)this.getPos());
            return;
        }
        if (this.clientMonitor == null) {
            this.clientMonitor = new ClientMonitor(this.advanced, this);
        }
        this.clientMonitor.read(state);
    }

    private void updateBlockState() {
        int currentMetadata = this.getBlockMeta();
        MonitorEdgeState edgeState = MonitorEdgeState.fromConnections(this.yIndex < this.height - 1, this.yIndex > 0, this.xIndex > 0, this.xIndex < this.width - 1);
        if (this.worldObj != null) {
            int newMetadata = currentMetadata & 0xFFFFFF0F | BlockLogicMonitor.stateToMeta(edgeState);
            this.worldObj.setBlockMetadataWithNotify(this.x, this.y, this.z, newMetadata);
        }
    }

    public Direction getFront() {
        Direction orientation = this.getOrientation();
        return orientation == Direction.NORTH ? this.getDirection() : orientation;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getXIndex() {
        return this.xIndex;
    }

    public int getYIndex() {
        return this.yIndex;
    }

    private TileMonitor getOrigin() {
        return this.getNeighbour(0, 0);
    }

    private void resize(int width, int height) {
        TileMonitor monitor;
        int y;
        int x;
        if (this.xIndex != 0 || this.yIndex != 0) {
            this.serverMonitor = null;
            this.clientMonitor = null;
        }
        this.xIndex = 0;
        this.yIndex = 0;
        this.width = width;
        this.height = height;
        boolean needsTerminal = false;
        block0: for (x = 0; x < width; ++x) {
            for (y = 0; y < height; ++y) {
                monitor = this.getNeighbour(x, y);
                if (monitor == null || monitor.peripheral == null) continue;
                needsTerminal = true;
                break block0;
            }
        }
        if (needsTerminal) {
            if (this.serverMonitor == null) {
                this.serverMonitor = new ServerMonitor(this.advanced, this);
                this.clientMonitor = null;
            }
        } else {
            this.serverMonitor = null;
            this.clientMonitor = null;
        }
        if (this.serverMonitor != null) {
            this.serverMonitor.rebuild();
        }
        for (x = 0; x < width; ++x) {
            for (y = 0; y < height; ++y) {
                monitor = this.getNeighbour(x, y);
                if (monitor == null) continue;
                monitor.xIndex = x;
                monitor.yIndex = y;
                monitor.width = width;
                monitor.height = height;
                monitor.serverMonitor = this.serverMonitor;
                monitor.clientMonitor = null;
                monitor.updateBlockState();
                monitor.updateBlock();
            }
        }
    }

    private void updateBlock() {
        if (this.worldObj != null) {
            this.worldObj.notifyBlockChange(this.x, this.y, this.z, this.getBlockId());
        }
    }

    private boolean mergeLeft() {
        TileMonitor left = this.getNeighbour(-1, 0);
        if (left == null || left.yIndex != 0 || left.height != this.height) {
            return false;
        }
        int width = left.width + this.width;
        if (width > ComputerCraft.monitorWidth) {
            return false;
        }
        TileMonitor origin = left.getOrigin();
        if (origin != null) {
            origin.resize(width, this.height);
        }
        left.expand();
        return true;
    }

    private boolean mergeRight() {
        TileMonitor right = this.getNeighbour(this.width, 0);
        if (right == null || right.yIndex != 0 || right.height != this.height) {
            return false;
        }
        int width = this.width + right.width;
        if (width > ComputerCraft.monitorWidth) {
            return false;
        }
        TileMonitor origin = this.getOrigin();
        if (origin != null) {
            origin.resize(width, this.height);
        }
        this.expand();
        return true;
    }

    private boolean mergeUp() {
        TileMonitor above = this.getNeighbour(0, this.height);
        if (above == null || above.xIndex != 0 || above.width != this.width) {
            return false;
        }
        int height = above.height + this.height;
        if (height > ComputerCraft.monitorHeight) {
            return false;
        }
        TileMonitor origin = this.getOrigin();
        if (origin != null) {
            origin.resize(this.width, height);
        }
        this.expand();
        return true;
    }

    private boolean mergeDown() {
        TileMonitor below = this.getNeighbour(0, -1);
        if (below == null || below.xIndex != 0 || below.width != this.width) {
            return false;
        }
        int height = this.height + below.height;
        if (height > ComputerCraft.monitorHeight) {
            return false;
        }
        TileMonitor origin = below.getOrigin();
        if (origin != null) {
            origin.resize(this.width, height);
        }
        below.expand();
        return true;
    }

    void updateNeighborsDeferred() {
        this.needsUpdate = true;
    }

    void updateNeighbors() {
        this.contractNeighbours();
        this.contract();
        this.expand();
    }

    void expand() {
        if (Helper.isSinglePlayer()) {
            this.createServerMonitor();
        }
        while (this.mergeLeft() || this.mergeRight() || this.mergeUp() || this.mergeDown()) {
        }
    }

    void contractNeighbours() {
        TileMonitor above;
        TileMonitor below;
        TileMonitor right;
        TileMonitor left;
        if (Helper.isSinglePlayer()) {
            this.createServerMonitor();
        }
        this.visiting = true;
        if (this.xIndex > 0 && (left = this.getNeighbour(this.xIndex - 1, this.yIndex)) != null) {
            left.contract();
        }
        if (this.xIndex + 1 < this.width && (right = this.getNeighbour(this.xIndex + 1, this.yIndex)) != null) {
            right.contract();
        }
        if (this.yIndex > 0 && (below = this.getNeighbour(this.xIndex, this.yIndex - 1)) != null) {
            below.contract();
        }
        if (this.yIndex + 1 < this.height && (above = this.getNeighbour(this.xIndex, this.yIndex + 1)) != null) {
            above.contract();
        }
        this.visiting = false;
    }

    void contract() {
        if (Helper.isSinglePlayer()) {
            this.createServerMonitor();
        }
        int height = this.height;
        int width = this.width;
        TileMonitor origin = this.getOrigin();
        if (origin == null) {
            TileMonitor below;
            TileMonitor right = width > 1 ? this.getNeighbour(1, 0) : null;
            TileMonitor tileMonitor = below = height > 1 ? this.getNeighbour(0, 1) : null;
            if (right != null) {
                right.resize(width - 1, 1);
            }
            if (below != null) {
                below.resize(width, height - 1);
            }
            if (right != null) {
                right.expand();
            }
            if (below != null) {
                below.expand();
            }
            return;
        }
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                TileMonitor monitor = origin.getNeighbour(x, y);
                if (monitor != null) continue;
                TileMonitor above = null;
                TileMonitor left = null;
                TileMonitor right = null;
                TileMonitor below = null;
                if (y > 0) {
                    above = origin;
                    above.resize(width, y);
                }
                if (x > 0) {
                    left = origin.getNeighbour(0, y);
                    left.resize(x, 1);
                }
                if (x + 1 < width) {
                    right = origin.getNeighbour(x + 1, y);
                    right.resize(width - (x + 1), 1);
                }
                if (y + 1 < height) {
                    below = origin.getNeighbour(0, y + 1);
                    below.resize(width, height - (y + 1));
                }
                if (above != null) {
                    above.expand();
                }
                if (left != null) {
                    left.expand();
                }
                if (right != null) {
                    right.expand();
                }
                if (below != null) {
                    below.expand();
                }
                return;
            }
        }
    }

    private void monitorTouched(float xPos, float yPos, float zPos) {
        XYPair pair = XYPair.of(xPos, yPos, zPos, this.getDirection(), this.getOrientation()).add(this.xIndex, this.height - this.yIndex - 1);
        if ((double)pair.x > (double)this.width - 0.125 || (double)pair.y > (double)this.height - 0.125 || (double)pair.x < 0.125 || (double)pair.y < 0.125) {
            return;
        }
        ServerMonitor serverTerminal = this.getServerMonitor();
        if (serverTerminal == null || !serverTerminal.isColour()) {
            return;
        }
        Terminal originTerminal = serverTerminal.getTerminal();
        if (originTerminal == null) {
            return;
        }
        double xCharWidth = ((double)this.width - 0.3125) / (double)originTerminal.getWidth();
        double yCharHeight = ((double)this.height - 0.3125) / (double)originTerminal.getHeight();
        int xCharPos = (int)Math.min((double)originTerminal.getWidth(), Math.max(((double)pair.x - 0.125 - 0.03125) / xCharWidth + 1.0, 1.0));
        int yCharPos = (int)Math.min((double)originTerminal.getHeight(), Math.max(((double)pair.y - 0.125 - 0.03125) / yCharHeight + 1.0, 1.0));
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                TileMonitor monitor = this.getNeighbour(x, y);
                if (monitor == null) continue;
                for (IComputerAccess computer : monitor.computers) {
                    computer.queueEvent("monitor_touch", computer.getAttachmentName(), xCharPos, yCharPos);
                }
            }
        }
    }

    void addComputer(IComputerAccess computer) {
        this.computers.add(computer);
    }

    void removeComputer(IComputerAccess computer) {
        this.computers.remove(computer);
    }
}

