/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.printer;

import com.mojang.nbt.tags.CompoundTag;
import com.mojang.nbt.tags.ListTag;
import com.mojang.nbt.tags.Tag;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.peripheral.IPeripheralTile;
import dan200.computercraft.core.terminal.Terminal;
import dan200.computercraft.fabric.Helper;
import dan200.computercraft.shared.common.TileGeneric;
import dan200.computercraft.shared.media.items.ItemPrintout;
import dan200.computercraft.shared.network.client.OpenGuiPrinterClientMessage;
import dan200.computercraft.shared.peripheral.printer.PrinterPeripheral;
import dan200.computercraft.shared.util.BlockPos;
import dan200.computercraft.shared.util.ColourUtils;
import dan200.computercraft.shared.util.InventoryUtil;
import dan200.computercraft.shared.util.ItemStorage;
import dan200.computercraft.shared.util.WorldUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.player.inventory.container.Container;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.DyeColor;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.Vec3;

public final class TilePrinter
extends TileGeneric
implements IPeripheralTile,
Container {
    static final int SLOTS = 13;
    private static final String NBT_NAME = "CustomName";
    private static final String NBT_PRINTING = "Printing";
    private static final String NBT_PAGE_TITLE = "PageTitle";
    private static final int[] BOTTOM_SLOTS = new int[]{7, 8, 9, 10, 11, 12};
    private static final int[] TOP_SLOTS = new int[]{1, 2, 3, 4, 5, 6};
    private static final int[] SIDE_SLOTS = new int[]{0};
    private final List<ItemStack> inventory = new ArrayList<Object>(Collections.nCopies(13, null));
    private final ItemStorage itemHandlerAll = ItemStorage.wrap(this);
    private final Terminal page = new Terminal(25, 21);
    String customName;
    private String pageTitle = "";
    private boolean printing = false;

    public void invalidate() {
        this.ejectContents();
        super.invalidate();
    }

    private static boolean isPaper(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        Item item = stack.getItem();
        return item.equals(Items.PAPER) || item instanceof ItemPrintout && ((ItemPrintout)item).getType() == ItemPrintout.Type.PAGE;
    }

    static boolean isInk(@Nonnull ItemStack stack) {
        return ColourUtils.getStackColour(stack) != null;
    }

    public boolean onBlockRightClicked(Player player, Side side, double xPlaced, double yPlaced) {
        if (player.isSneaking()) {
            return true;
        }
        if (!Helper.isClientWorld()) {
            new OpenGuiPrinterClientMessage(this).sendToPlayer(player);
        }
        return true;
    }

    private void ejectContents() {
        for (int i = 0; i < 13; ++i) {
            ItemStack stack = this.inventory.get(i);
            if (stack == null) continue;
            this.setItem(i, null);
            WorldUtil.dropItemStack(stack, this.worldObj, Vec3.getPermanentVec3((double)this.x, (double)this.y, (double)this.z).add(0.5, 0.75, 0.5));
        }
    }

    public BlockPos getPos() {
        return new BlockPos(this.x, this.y, this.z);
    }

    private void updateBlockState() {
        ItemStack stack;
        int i;
        boolean top = false;
        boolean bottom = false;
        for (i = 1; i < 7; ++i) {
            stack = this.inventory.get(i);
            if (!TilePrinter.isPaper(stack)) continue;
            top = true;
            break;
        }
        for (i = 7; i < 13; ++i) {
            stack = this.inventory.get(i);
            if (!TilePrinter.isPaper(stack)) continue;
            bottom = true;
            break;
        }
        this.updateBlockState(top, bottom);
    }

    private void updateBlockState(boolean top, boolean bottom) {
        boolean currentTop;
        if (this.isInvalid()) {
            return;
        }
        int currentMetadata = this.getBlockMeta();
        boolean currentBottom = (currentMetadata >> 3 & 1) == 1;
        boolean bl = currentTop = (currentMetadata >> 4 & 1) == 1;
        if (currentBottom != bottom || currentTop != top) {
            int newMetadata = currentMetadata & 0xFFFFFFE7 | (bottom ? 8 : 0) + (top ? 16 : 0);
            if (this.worldObj != null) {
                this.worldObj.setBlockMetadataWithNotify(this.x, this.y, this.z, newMetadata);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readFromNBT(CompoundTag nbt) {
        super.readFromNBT(nbt);
        this.customName = nbt.containsKey(NBT_NAME) ? nbt.getString(NBT_NAME) : null;
        Terminal terminal = this.page;
        synchronized (terminal) {
            this.printing = nbt.getBoolean(NBT_PRINTING);
            this.pageTitle = nbt.getString(NBT_PAGE_TITLE);
            this.page.readFromNBT(nbt);
        }
        ListTag nbttaglist = nbt.getList("Items");
        this.inventory.replaceAll(ignored -> null);
        for (int i = 0; i < nbttaglist.tagCount(); ++i) {
            CompoundTag tag = (CompoundTag)nbttaglist.tagAt(i);
            int slot = tag.getByte("Slot") & 0xFF;
            if (slot >= this.inventory.size()) continue;
            this.inventory.set(slot, ItemStack.readItemStackFromNbt((CompoundTag)tag));
            ItemStack itemStack = this.inventory.get(slot);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToNBT(CompoundTag nbt) {
        if (this.customName != null) {
            nbt.putString(NBT_NAME, this.customName);
        }
        Terminal terminal = this.page;
        synchronized (terminal) {
            nbt.putBoolean(NBT_PRINTING, this.printing);
            nbt.putString(NBT_PAGE_TITLE, this.pageTitle);
            this.page.writeToNBT(nbt);
        }
        ListTag nbttaglist = new ListTag();
        for (int i = 0; i < this.inventory.size(); ++i) {
            ItemStack item = this.inventory.get(i);
            if (item != null) {
                CompoundTag tag = new CompoundTag();
                tag.putByte("Slot", (byte)i);
                item.writeToNBT(tag);
                nbttaglist.addTag((Tag)tag);
                continue;
            }
            this.inventory.set(i, null);
        }
        nbt.put("Items", (Tag)nbttaglist);
        super.writeToNBT(nbt);
    }

    boolean isPrinting() {
        return this.printing;
    }

    public int getContainerSize() {
        return this.inventory.size();
    }

    @Nullable
    public ItemStack getItem(int slot) {
        return slot >= 0 && slot < this.inventory.size() ? this.inventory.get(slot) : null;
    }

    @Nullable
    public ItemStack removeItem(int slot, int count) {
        ItemStack stack = this.inventory.get(slot);
        if (stack == null) {
            return null;
        }
        if (stack.stackSize <= count) {
            this.setItem(slot, null);
            this.updateBlockState();
            return stack;
        }
        ItemStack part = stack.splitStack(count);
        if (this.inventory.get(slot) == null) {
            this.inventory.set(slot, null);
            this.updateBlockState();
        }
        this.updateBlockState();
        return part;
    }

    public void setItem(int i, @Nullable ItemStack stack) {
        if (i >= 0 && i < this.inventory.size() && !InventoryUtil.areItemsEqual(stack, this.inventory.get(i))) {
            this.inventory.set(i, stack);
        }
        this.updateBlockState();
    }

    public String getNameTranslationKey() {
        return "";
    }

    public int getMaxStackSize() {
        return 64;
    }

    public boolean stillValid(Player player) {
        return this.isUsable(player, false);
    }

    public void sortContainer() {
    }

    @Override
    @Nonnull
    public IPeripheral getPeripheral(Direction side) {
        return new PrinterPeripheral(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    Terminal getCurrentPage() {
        Terminal terminal = this.page;
        synchronized (terminal) {
            return this.printing ? this.page : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean startNewPage() {
        Terminal terminal = this.page;
        synchronized (terminal) {
            if (!this.canInputPage()) {
                return false;
            }
            if (this.printing && !this.outputPage()) {
                return false;
            }
            return this.inputPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean endCurrentPage() {
        Terminal terminal = this.page;
        synchronized (terminal) {
            return this.printing && this.outputPage();
        }
    }

    private boolean outputPage() {
        int height = this.page.getHeight();
        String[] lines = new String[height];
        String[] colours = new String[height];
        for (int i = 0; i < height; ++i) {
            lines[i] = this.page.getLine(i).toString();
            colours[i] = this.page.getTextColourLine(i).toString();
        }
        ItemStack stack = ItemPrintout.createSingleFromTitleAndText(this.pageTitle, lines, colours);
        for (int slot : BOTTOM_SLOTS) {
            if (this.inventory.get(slot) != null) continue;
            this.setItem(slot, stack);
            this.printing = false;
            return true;
        }
        return false;
    }

    int getInkLevel() {
        ItemStack inkStack = this.inventory.get(0);
        return TilePrinter.isInk(inkStack) ? inkStack.stackSize : 0;
    }

    int getPaperLevel() {
        int count = 0;
        for (int i = 1; i < 7; ++i) {
            ItemStack paperStack = this.inventory.get(i);
            if (!TilePrinter.isPaper(paperStack)) continue;
            count += paperStack.stackSize;
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setPageTitle(String title) {
        Terminal terminal = this.page;
        synchronized (terminal) {
            if (this.printing) {
                this.pageTitle = title;
            }
        }
    }

    private boolean canInputPage() {
        ItemStack inkStack = this.inventory.get(0);
        return inkStack != null && TilePrinter.isInk(inkStack) && this.getPaperLevel() > 0;
    }

    private boolean inputPage() {
        ItemStack inkStack = this.inventory.get(0);
        DyeColor dye = ColourUtils.getStackColour(inkStack);
        if (dye == null) {
            return false;
        }
        for (int i = 1; i < 7; ++i) {
            ItemStack paperStack = this.inventory.get(i);
            if (!TilePrinter.isPaper(paperStack)) continue;
            this.page.setTextColour(dye.blockMeta);
            this.page.clear();
            if (paperStack.getItem() instanceof ItemPrintout) {
                this.pageTitle = ItemPrintout.getTitle(paperStack);
                String[] text = ItemPrintout.getText(paperStack);
                String[] textColour = ItemPrintout.getColours(paperStack);
                for (int y = 0; y < this.page.getHeight(); ++y) {
                    this.page.setLine(y, text[y], textColour[y], "");
                }
            } else {
                this.pageTitle = "";
            }
            this.page.setCursorPos(0, 0);
            --inkStack.stackSize;
            if (inkStack.stackSize == 0) {
                this.inventory.set(0, null);
            }
            --paperStack.stackSize;
            if (paperStack.stackSize == 0) {
                this.inventory.set(i, null);
                this.updateBlockState();
            }
            this.printing = true;
            return true;
        }
        return false;
    }
}

