/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.speaker;

import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.peripheral.IPeripheralTile;
import dan200.computercraft.shared.common.TileGeneric;
import dan200.computercraft.shared.peripheral.speaker.SpeakerPeripheral;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.phys.Vec3;
import net.minecraft.core.world.World;

public class TileSpeaker
extends TileGeneric
implements IPeripheralTile {
    public static final int MIN_TICKS_BETWEEN_SOUNDS = 1;
    private final SpeakerPeripheral peripheral = new Peripheral(this);

    public void tick() {
        this.peripheral.update();
    }

    @Override
    @Nonnull
    public IPeripheral getPeripheral(Direction side) {
        return this.peripheral;
    }

    private static final class Peripheral
    extends SpeakerPeripheral {
        private final TileSpeaker speaker;

        private Peripheral(TileSpeaker speaker) {
            this.speaker = speaker;
        }

        @Override
        public World getWorld() {
            return this.speaker.worldObj;
        }

        @Override
        public Vec3 getPosition() {
            return Vec3.getPermanentVec3((double)this.speaker.x, (double)this.speaker.y, (double)this.speaker.z);
        }

        @Override
        public boolean equals(@Nullable IPeripheral other) {
            return this == other || other instanceof Peripheral && this.speaker == ((Peripheral)other).speaker;
        }
    }
}

