/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.pocket.core;

import com.mojang.nbt.tags.CompoundTag;
import dan200.computercraft.ComputerCraft;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.pocket.IPocketAccess;
import dan200.computercraft.api.pocket.IPocketUpgrade;
import dan200.computercraft.core.computer.ComputerSide;
import dan200.computercraft.shared.common.IColouredItem;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.pocket.items.ItemPocketComputer;
import dan200.computercraft.shared.util.BlockPos;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.player.inventory.container.ContainerInventory;
import net.minecraft.core.world.World;
import turniplabs.halplibe.helper.network.NetworkHandler;
import turniplabs.halplibe.helper.network.NetworkMessage;

public class PocketServerComputer
extends ServerComputer
implements IPocketAccess {
    private IPocketUpgrade upgrade;
    private Entity entity;
    private ItemStack stack;

    public PocketServerComputer(World world, int computerID, String label, int instanceID, ComputerFamily family) {
        super(world, computerID, label, instanceID, family, ComputerCraft.pocketTermWidth, ComputerCraft.pocketTermHeight);
    }

    @Override
    @Nullable
    public Entity getEntity() {
        Entity entity = this.entity;
        if (entity == null || this.stack == null || !entity.isAlive()) {
            return null;
        }
        if (entity instanceof Player) {
            ContainerInventory inventory = ((Player)entity).inventory;
            for (ItemStack itemStack : inventory.mainInventory) {
                if (itemStack != this.stack) continue;
                return entity;
            }
            return null;
        }
        if (entity instanceof Mob) {
            Mob living = (Mob)entity;
            return living.getHeldItem() == this.stack ? entity : null;
        }
        return null;
    }

    @Override
    public int getColour() {
        return IColouredItem.getColourBasic(this.stack);
    }

    @Override
    public void setColour(int colour) {
        IColouredItem.setColourBasic(this.stack, colour);
        this.updateUpgradeNBTData();
    }

    @Override
    public int getLight() {
        CompoundTag tag = this.getUserData();
        return tag.containsKey("Light") ? tag.getInteger("Light") : -1;
    }

    @Override
    public void setLight(int colour) {
        CompoundTag tag = this.getUserData();
        if (colour >= 0 && colour <= 0xFFFFFF) {
            if (!tag.containsKey("Light") || tag.getInteger("Light") != colour) {
                tag.putInt("Light", colour);
                this.updateUserData();
            }
        } else if (tag.containsKey("Light")) {
            ((Map)tag.getValue()).remove("Light");
            this.updateUserData();
        }
    }

    @Override
    @Nonnull
    public CompoundTag getUpgradeNBTData() {
        return ItemPocketComputer.getUpgradeInfo(this.stack);
    }

    @Override
    public void updateUpgradeNBTData() {
        if (this.entity instanceof Player) {
            ((Player)this.entity).inventory.setChanged();
        }
    }

    @Override
    public void invalidatePeripheral() {
        IPeripheral peripheral = this.upgrade == null ? null : this.upgrade.createPeripheral(this);
        this.setPeripheral(ComputerSide.BACK, peripheral);
    }

    @Override
    @Nonnull
    public Map<Integer, IPeripheral> getUpgrades() {
        return this.upgrade == null ? Collections.emptyMap() : Collections.singletonMap(this.upgrade.getUpgradeID(), this.getPeripheral(ComputerSide.BACK));
    }

    public IPocketUpgrade getUpgrade() {
        return this.upgrade;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUpgrade(IPocketUpgrade upgrade) {
        if (this.upgrade == upgrade) {
            return;
        }
        PocketServerComputer pocketServerComputer = this;
        synchronized (pocketServerComputer) {
            ItemPocketComputer.setUpgrade(this.stack, upgrade);
            this.updateUpgradeNBTData();
            this.upgrade = upgrade;
            this.invalidatePeripheral();
        }
    }

    public synchronized void updateValues(Entity entity, @Nonnull ItemStack stack, IPocketUpgrade upgrade) {
        if (entity != null) {
            this.setWorld(entity.world);
            this.setPosition(new BlockPos((int)entity.x, (int)entity.y, (int)entity.z));
        }
        if (entity != this.entity && entity instanceof Player) {
            this.markTerminalChanged();
        }
        this.entity = entity;
        this.stack = stack;
        if (this.upgrade != upgrade) {
            this.upgrade = upgrade;
            this.invalidatePeripheral();
        }
    }

    @Override
    public void broadcastState(boolean force) {
        Player player;
        super.broadcastState(force);
        if ((this.hasTerminalChanged() || force) && this.entity instanceof Player && !this.isInteracting(player = (Player)this.entity)) {
            NetworkHandler.sendToPlayer((Player)player, (NetworkMessage)this.createTerminalPacket());
        }
    }
}

