/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.pocket.items;

import com.google.common.base.Objects;
import com.mojang.nbt.tags.CompoundTag;
import dan200.computercraft.ComputerCraft;
import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.filesystem.IMount;
import dan200.computercraft.api.media.IMedia;
import dan200.computercraft.api.pocket.IPocketUpgrade;
import dan200.computercraft.core.computer.ComputerSide;
import dan200.computercraft.fabric.Helper;
import dan200.computercraft.fabric.IComputerPlayer;
import dan200.computercraft.shared.PocketUpgrades;
import dan200.computercraft.shared.common.IColouredItem;
import dan200.computercraft.shared.computer.core.ClientComputer;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.core.ComputerState;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.computer.inventory.ContainerComputer;
import dan200.computercraft.shared.computer.items.IComputerItem;
import dan200.computercraft.shared.pocket.apis.PocketAPI;
import dan200.computercraft.shared.pocket.core.PocketServerComputer;
import dan200.computercraft.shared.pocket.items.PocketComputerItemFactory;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.player.inventory.container.ContainerInventory;
import net.minecraft.core.util.collection.NamespaceID;
import net.minecraft.core.world.World;

public class ItemPocketComputer
extends Item
implements IComputerItem,
IMedia,
IColouredItem {
    public static final String NBT_LIGHT = "Light";
    private static final String NBT_UPGRADE = "Upgrade";
    private static final String NBT_UPGRADE_INFO = "UpgradeInfo";
    private static final String NBT_INSTANCE = "Instanceid";
    private static final String NBT_SESSION = "SessionId";
    private final ComputerFamily family;

    public ItemPocketComputer(NamespaceID namespaceId, int id, ComputerFamily family) {
        super(namespaceId, id);
        this.family = family;
    }

    public static ServerComputer getServerComputer(@Nonnull ItemStack stack) {
        int session = ItemPocketComputer.getSessionID(stack);
        if (session != ComputerCraft.serverComputerRegistry.getSessionID()) {
            return null;
        }
        int instanceID = ItemPocketComputer.getInstanceID(stack);
        return instanceID >= 0 ? (ServerComputer)ComputerCraft.serverComputerRegistry.get(instanceID) : null;
    }

    @Environment(value=EnvType.CLIENT)
    public static ComputerState getState(@Nonnull ItemStack stack) {
        ClientComputer computer = ItemPocketComputer.getClientComputer(stack);
        return computer == null ? ComputerState.OFF : computer.getState();
    }

    private static ClientComputer getClientComputer(@Nonnull ItemStack stack) {
        int instanceID = ItemPocketComputer.getInstanceID(stack);
        return instanceID >= 0 ? (ClientComputer)ComputerCraft.clientComputerRegistry.get(instanceID) : null;
    }

    @Environment(value=EnvType.CLIENT)
    public static int getLightState(@Nonnull ItemStack stack) {
        CompoundTag computerNBT;
        ClientComputer computer = ItemPocketComputer.getClientComputer(stack);
        if (computer != null && computer.isOn() && (computerNBT = computer.getUserData()) != null && computerNBT.containsKey(NBT_LIGHT)) {
            return computerNBT.getInteger(NBT_LIGHT);
        }
        return -1;
    }

    public static void setUpgrade(@Nonnull ItemStack stack, IPocketUpgrade upgrade) {
        CompoundTag compound = stack.getData();
        if (upgrade == null) {
            ((Map)compound.getValue()).remove(NBT_UPGRADE);
        } else {
            compound.putInt(NBT_UPGRADE, upgrade.getUpgradeID());
        }
        ((Map)compound.getValue()).remove(NBT_UPGRADE_INFO);
        stack.setData(compound);
    }

    public static CompoundTag getUpgradeInfo(@Nonnull ItemStack stack) {
        return stack.getData();
    }

    public static IPocketUpgrade getUpgrade(@Nonnull ItemStack stack) {
        CompoundTag compound = stack.getData();
        return compound.containsKey(NBT_UPGRADE) ? PocketUpgrades.get(compound.getInteger(NBT_UPGRADE)) : null;
    }

    private static void setComputerID(@Nonnull ItemStack stack, int computerID) {
        CompoundTag tag = stack.getData();
        tag.putInt("ComputerId", computerID);
        stack.setData(tag);
    }

    public static ClientComputer createClientComputer(@Nonnull ItemStack stack) {
        int instanceID = ItemPocketComputer.getInstanceID(stack);
        if (instanceID >= 0) {
            if (!ComputerCraft.clientComputerRegistry.contains(instanceID)) {
                ComputerCraft.clientComputerRegistry.add(instanceID, new ClientComputer(instanceID));
            }
            return (ClientComputer)ComputerCraft.clientComputerRegistry.get(instanceID);
        }
        return null;
    }

    private static int getInstanceID(@Nonnull ItemStack stack) {
        CompoundTag nbt = stack.getData();
        return nbt.containsKey(NBT_INSTANCE) ? nbt.getInteger(NBT_INSTANCE) : -1;
    }

    private static int getSessionID(@Nonnull ItemStack stack) {
        CompoundTag nbt = stack.getData();
        return nbt.containsKey(NBT_SESSION) ? nbt.getInteger(NBT_SESSION) : -1;
    }

    private static void setInstanceID(@Nonnull ItemStack stack, int instanceID) {
        CompoundTag tag = stack.getData();
        tag.putInt(NBT_INSTANCE, instanceID);
        stack.setData(tag);
    }

    private static void setSessionID(@Nonnull ItemStack stack, int sessionID) {
        CompoundTag tag = stack.getData();
        tag.putInt(NBT_SESSION, sessionID);
        stack.setData(tag);
    }

    public ItemStack onUseItem(ItemStack itemstack, World world, Player player) {
        ItemStack stack = player.getHeldItem();
        if (!Helper.isClientWorld()) {
            PocketServerComputer computer = this.createServerComputer(world, player.inventory, (Entity)player, stack);
            boolean stop = false;
            if (computer != null) {
                computer.turnOn();
                IPocketUpgrade upgrade = ItemPocketComputer.getUpgrade(stack);
                if (upgrade != null) {
                    computer.updateValues((Entity)player, stack, upgrade);
                    stop = upgrade.onRightClick(world, computer, computer.getPeripheral(ComputerSide.BACK));
                }
            }
            if (!stop && computer != null) {
                computer.sendTerminalState(player);
                ((IComputerPlayer)player).setCurrentContainerComputer(new ContainerComputer(this, world, player.inventory, (Entity)player, stack));
                computer.sendOpenComputerGui(player);
            }
        }
        return stack;
    }

    public void inventoryTick(@Nonnull ItemStack stack, World world, @Nonnull Entity entity, int slotNum, boolean selected) {
        if (!Helper.isClientWorld()) {
            ContainerInventory inventory = entity instanceof Player ? ((Player)entity).inventory : null;
            PocketServerComputer computer = this.createServerComputer(world, inventory, entity, stack);
            if (computer != null) {
                String label;
                IPocketUpgrade upgrade = ItemPocketComputer.getUpgrade(stack);
                computer.keepAlive();
                computer.setWorld(world);
                computer.updateValues(entity, stack, upgrade);
                int id = computer.getID();
                if (id != this.getComputerID(stack)) {
                    ItemPocketComputer.setComputerID(stack, id);
                    if (inventory != null) {
                        inventory.setChanged();
                    }
                }
                if (!Objects.equal(label = computer.getLabel(), this.getLabel(stack))) {
                    this.setLabel(stack, label);
                    if (inventory != null) {
                        inventory.setChanged();
                    }
                }
                if (upgrade != null) {
                    upgrade.update(computer, computer.getPeripheral(ComputerSide.BACK));
                }
            }
        } else {
            ItemPocketComputer.createClientComputer(stack);
        }
    }

    public String getTranslatedName(ItemStack stack) {
        I18n i18n = I18n.getInstance();
        String baseString = stack.getItemKey();
        IPocketUpgrade upgrade = ItemPocketComputer.getUpgrade(stack);
        if (upgrade != null) {
            return i18n.translateKeyAndFormat(baseString + ".upgraded.name", new Object[]{i18n.translateKey(upgrade.getUnlocalisedAdjective())});
        }
        return super.getTranslatedName(stack);
    }

    public String getTranslatedDescription(ItemStack stack) {
        int id;
        I18n i18n = I18n.getInstance();
        String text = super.getTranslatedDescription(stack);
        if (this.getLabel(stack) == null && (id = this.getComputerID(stack)) >= 0) {
            text = text + "\n" + i18n.translateKeyAndFormat("gui.computercraft.tooltip.computer_id", new Object[]{id});
        }
        return text;
    }

    public void addToCreativeMenu(@Nonnull List<ItemStack> stacks) {
        stacks.add(this.create(-1, null, -1, null));
        for (IPocketUpgrade upgrade : PocketUpgrades.getVanillaUpgrades()) {
            stacks.add(this.create(-1, null, -1, upgrade));
        }
    }

    public ItemStack create(int id, String label, int colour, IPocketUpgrade upgrade) {
        ItemStack result = new ItemStack((Item)this);
        CompoundTag tag = result.getData();
        if (id >= 0) {
            tag.putInt("ComputerId", id);
        }
        if (label != null) {
            result.setCustomName(label);
        }
        if (upgrade != null) {
            tag.putInt(NBT_UPGRADE, upgrade.getUpgradeID());
        }
        if (colour != -1) {
            tag.putInt("Color", colour);
        }
        result.setData(tag);
        return result;
    }

    public PocketServerComputer createServerComputer(World world, ContainerInventory inventory, Entity entity, @Nonnull ItemStack stack) {
        PocketServerComputer computer;
        if (Helper.isClientWorld()) {
            return null;
        }
        int instanceID = ItemPocketComputer.getInstanceID(stack);
        int sessionID = ItemPocketComputer.getSessionID(stack);
        int correctSessionID = ComputerCraft.serverComputerRegistry.getSessionID();
        if (instanceID >= 0 && sessionID == correctSessionID && ComputerCraft.serverComputerRegistry.contains(instanceID)) {
            computer = (PocketServerComputer)ComputerCraft.serverComputerRegistry.get(instanceID);
        } else {
            int computerID;
            if (instanceID < 0 || sessionID != correctSessionID) {
                instanceID = ComputerCraft.serverComputerRegistry.getUnusedInstanceID();
                ItemPocketComputer.setInstanceID(stack, instanceID);
                ItemPocketComputer.setSessionID(stack, correctSessionID);
            }
            if ((computerID = this.getComputerID(stack)) < 0) {
                computerID = ComputerCraftAPI.createUniqueNumberedSaveDir(world, "computer");
                ItemPocketComputer.setComputerID(stack, computerID);
            }
            computer = new PocketServerComputer(world, computerID, this.getLabel(stack), instanceID, this.getFamily());
            computer.updateValues(entity, stack, ItemPocketComputer.getUpgrade(stack));
            computer.addAPI(new PocketAPI(computer));
            ComputerCraft.serverComputerRegistry.add(instanceID, computer);
            if (inventory != null) {
                inventory.setChanged();
            }
        }
        computer.setWorld(world);
        return computer;
    }

    @Override
    public String getLabel(@Nonnull ItemStack stack) {
        return IComputerItem.super.getLabel(stack);
    }

    @Override
    public ComputerFamily getFamily() {
        return this.family;
    }

    @Override
    public ItemStack withFamily(@Nonnull ItemStack stack, @Nonnull ComputerFamily family) {
        return PocketComputerItemFactory.create(this.getComputerID(stack), this.getLabel(stack), this.getColour(stack), family, ItemPocketComputer.getUpgrade(stack));
    }

    @Override
    public boolean setLabel(@Nonnull ItemStack stack, String label) {
        if (label != null) {
            stack.setCustomName(label);
        } else {
            stack.removeCustomName();
        }
        return true;
    }

    @Override
    public IMount createDataMount(@Nonnull ItemStack stack, @Nonnull World world) {
        int id = this.getComputerID(stack);
        if (id >= 0) {
            return ComputerCraftAPI.createSaveDirMount(world, "computer/" + id, ComputerCraft.computerSpaceLimit);
        }
        return null;
    }
}

