/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.pocket.peripherals;

import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.pocket.AbstractPocketUpgrade;
import dan200.computercraft.api.pocket.IPocketAccess;
import dan200.computercraft.shared.common.ComputerCraftItems;
import dan200.computercraft.shared.pocket.peripherals.PocketSpeakerPeripheral;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.item.IItemConvertible;
import net.minecraft.core.util.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class PocketSpeaker
extends AbstractPocketUpgrade {
    public PocketSpeaker(int id) {
        super(id, (IItemConvertible)ComputerCraftItems.SPEAKER);
    }

    @Override
    @Nullable
    public IPeripheral createPeripheral(@Nonnull IPocketAccess access) {
        return new PocketSpeakerPeripheral();
    }

    @Override
    @NotNull
    public String getUnlocalisedAdjective() {
        return "upgrade.computercraft.speaker.adjective";
    }

    @Override
    public void update(@Nonnull IPocketAccess access, @Nullable IPeripheral peripheral) {
        if (!(peripheral instanceof PocketSpeakerPeripheral)) {
            return;
        }
        PocketSpeakerPeripheral speaker = (PocketSpeakerPeripheral)peripheral;
        Entity entity = access.getEntity();
        if (entity != null) {
            speaker.setLocation(entity.world, Vec3.getPermanentVec3((double)entity.x, (double)(entity.y + (double)entity.getHeadHeight()), (double)entity.z));
        }
        speaker.update();
        access.setLight(speaker.madeSound(20L) ? 3350780 : -1);
    }
}

