/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.blocks;

import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.client.blocks.BlockAORenderer;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.turtle.blocks.BlockLogicTurtle;
import dan200.computercraft.shared.turtle.blocks.TileTurtle;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.Minecraft;
import net.minecraft.client.render.block.model.BlockModel;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.tileentity.TileEntityRenderer;
import net.minecraft.core.block.Block;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.util.phys.Vec3;
import net.minecraft.core.world.WorldSource;
import org.lwjgl.opengl.GL11;

@Environment(value=EnvType.CLIENT)
public class TileEntityRendererTurtle
extends TileEntityRenderer<TileTurtle> {
    private static void drawBase(Tessellator tessellator, TileTurtle tileEntity, float angle) {
        new BlockAORenderer(AABB.getTemporaryBB((double)0.125, (double)0.125, (double)0.125, (double)0.875, (double)0.875, (double)0.8125)).setBottomUV(0.359375, 0.171875, 0.171875, 0.0).setTopUV(0.546875, 0.0, 0.359375, 0.171875).setNorthUV(0.71875, 0.359375, 0.53125, 0.171875).setSouthUV(0.359375, 0.359375, 0.171875, 0.171875).setWestUV(0.53125, 0.359375, 0.359375, 0.171875).setEastUV(0.171875, 0.359375, 0.0, 0.171875).render(tessellator, tileEntity, angle, 1.0f, 1.0f, 1.0f);
        new BlockAORenderer(AABB.getTemporaryBB((double)0.1875, (double)0.375, (double)0.8125, (double)0.8125, (double)0.8125, (double)0.9375)).setBottomUV(0.734375, 0.03125, 0.578125, 0.0).setTopUV(0.890625, 0.0, 0.734375, 0.03125).setSouthUV(0.734375, 0.140625, 0.578125, 0.03125).setWestUV(0.765625, 0.140625, 0.734375, 0.03125).setEastUV(0.578125, 0.140625, 0.546875, 0.03125).render(tessellator, tileEntity, angle, 1.0f, 1.0f, 1.0f);
    }

    public void doRender(Tessellator tessellator, TileTurtle tileEntity, double x, double y, double z, float partialTick) {
        if (this.renderDispatcher.textureManager == null) {
            return;
        }
        if (tileEntity.carriedBlock == null && tileEntity.worldObj == null) {
            return;
        }
        Block block = tileEntity.getBlock();
        if (block != null && block.getLogic() instanceof BlockLogicTurtle) {
            ITurtleUpgrade rightUpgrade;
            GL11.glEnable((int)32826);
            GL11.glPushMatrix();
            Vec3 pos = tileEntity.getAccess().getVisualPosition(partialTick);
            GL11.glTranslatef((float)((float)x + (float)pos.x + 1.0f), (float)((float)y + (float)pos.y + 1.0f), (float)((float)z + (float)pos.z + 1.0f));
            GL11.glTranslatef((float)-0.5f, (float)0.0f, (float)-0.5f);
            float angle = tileEntity.getAccess().getVisualYaw(partialTick);
            GL11.glRotatef((float)(-angle + 180.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTranslatef((float)0.5f, (float)0.0f, (float)0.5f);
            GL11.glPushMatrix();
            GL11.glScalef((float)-1.0f, (float)-1.0f, (float)-1.0f);
            int colour = tileEntity.getColour();
            BlockModel.renderBlocks.enableAO = true;
            if (tileEntity.worldObj == null) {
                BlockModel.renderBlocks.cache.setupCache(block, (WorldSource)Minecraft.getMinecraft().currentWorld, tileEntity.x, tileEntity.y, tileEntity.z);
            } else {
                BlockModel.renderBlocks.cache.setupCache(block, (WorldSource)tileEntity.worldObj, tileEntity.x, tileEntity.y, tileEntity.z);
            }
            if (colour != -1) {
                float r = (float)(colour >> 16 & 0xFF) / 255.0f;
                float g2 = (float)(colour >> 8 & 0xFF) / 255.0f;
                float b = (float)(colour & 0xFF) / 255.0f;
                this.loadTexture("/assets/computercraft/textures/block/turtle_colour.png");
                tessellator.startDrawingQuads();
                new BlockAORenderer(AABB.getTemporaryBB((double)0.125, (double)0.125, (double)0.125, (double)0.875, (double)0.875, (double)0.8125)).setBottomUV(0.359375, 0.53125, 0.171875, 0.359375).setTopUV(0.546875, 0.359375, 0.359375, 0.53125).setNorthUV(0.71875, 0.71875, 0.53125, 0.53125).setSouthUV(0.359375, 0.71875, 0.171875, 0.53125).setWestUV(0.53125, 0.71875, 0.359375, 0.5346875).setEastUV(0.171875, 0.71875, 0.0, 0.53125).render(tessellator, tileEntity, angle, r, g2, b);
                new BlockAORenderer(AABB.getTemporaryBB((double)0.1875, (double)0.375, (double)0.8125, (double)0.8125, (double)0.8125, (double)0.9375)).setBottomUV(0.734375, 0.390625, 0.578125, 0.359375).setTopUV(0.890625, 0.359375, 0.734375, 0.390625).setSouthUV(0.734375, 0.5, 0.578125, 0.390625).setWestUV(0.765625, 0.5, 0.734375, 0.390625).setEastUV(0.578125, 0.5, 0.546875, 0.390625).render(tessellator, tileEntity, angle, r, g2, b);
                tessellator.draw();
            } else if (tileEntity.getFamily() == ComputerFamily.ADVANCED) {
                this.loadTexture("/assets/computercraft/textures/block/turtle_advanced.png");
            } else {
                this.loadTexture("/assets/computercraft/textures/block/turtle_normal.png");
            }
            tessellator.startDrawingQuads();
            TileEntityRendererTurtle.drawBase(tessellator, tileEntity, angle);
            tessellator.draw();
            ITurtleUpgrade leftUpgrade = tileEntity.getAccess().getUpgrade(TurtleSide.LEFT);
            if (leftUpgrade != null) {
                leftUpgrade.drawTileUpgrade(tessellator, this.renderDispatcher.textureManager, tileEntity, angle, TurtleSide.LEFT, partialTick);
            }
            if ((rightUpgrade = tileEntity.getAccess().getUpgrade(TurtleSide.RIGHT)) != null) {
                rightUpgrade.drawTileUpgrade(tessellator, this.renderDispatcher.textureManager, tileEntity, angle, TurtleSide.RIGHT, partialTick);
            }
            BlockModel.renderBlocks.enableAO = false;
            GL11.glPopMatrix();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glPopMatrix();
            GL11.glDisable((int)32826);
        }
    }
}

