/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.core;

import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.ITurtleCommand;
import dan200.computercraft.api.turtle.TurtleCommandResult;
import dan200.computercraft.shared.turtle.core.InteractDirection;
import dan200.computercraft.shared.util.BlockPos;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.core.block.Block;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.world.World;

public class TurtleCompareCommand
implements ITurtleCommand {
    private final InteractDirection direction;

    public TurtleCompareCommand(InteractDirection direction) {
        this.direction = direction;
    }

    @Override
    @Nonnull
    public TurtleCommandResult execute(@Nonnull ITurtleAccess turtle) {
        Direction direction = this.direction.toWorldDir(turtle);
        ItemStack selectedStack = turtle.getInventory().getItem(turtle.getSelectedSlot());
        World world = turtle.getWorld();
        BlockPos oldPosition = turtle.getPosition();
        BlockPos newPosition = oldPosition.offset(direction);
        ItemStack lookAtStack = null;
        if (!world.isAirBlock(newPosition.x, newPosition.y, newPosition.z)) {
            Block lookAtBlock = world.getBlock(newPosition.x, newPosition.y, newPosition.z);
            block0: for (int i = 0; i < 5 && lookAtStack == null; ++i) {
                ItemStack[] drops = Objects.requireNonNull(lookAtBlock).getBreakResult(world, EnumDropCause.PICK_BLOCK, newPosition.x, newPosition.y, newPosition.z, world.getBlockMetadata(newPosition.x, newPosition.y, newPosition.z), world.getTileEntity(newPosition.x, newPosition.y, newPosition.z));
                if (drops == null) continue;
                for (ItemStack drop : drops) {
                    if (!drop.getItem().equals(lookAtBlock.asItem())) continue;
                    lookAtStack = drop;
                    continue block0;
                }
            }
            if (lookAtStack == null) {
                lookAtStack = new ItemStack(lookAtBlock);
            }
        }
        return Objects.requireNonNull(selectedStack).getItem().equals(((ItemStack)Objects.requireNonNull(lookAtStack)).getItem()) ? TurtleCommandResult.success() : TurtleCommandResult.failure();
    }
}

