/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.core;

import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.ITurtleCommand;
import dan200.computercraft.api.turtle.TurtleCommandResult;
import dan200.computercraft.api.turtle.event.TurtleBlockEvent;
import dan200.computercraft.api.turtle.event.TurtleEvent;
import dan200.computercraft.fabric.Helper;
import dan200.computercraft.shared.peripheral.generic.data.BlockData;
import dan200.computercraft.shared.turtle.core.InteractDirection;
import dan200.computercraft.shared.util.BlockPos;
import java.util.HashMap;
import javax.annotation.Nonnull;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.world.World;

public class TurtleInspectCommand
implements ITurtleCommand {
    private final InteractDirection direction;

    public TurtleInspectCommand(InteractDirection direction) {
        this.direction = direction;
    }

    @Override
    @Nonnull
    public TurtleCommandResult execute(@Nonnull ITurtleAccess turtle) {
        Direction direction = this.direction.toWorldDir(turtle);
        World world = turtle.getWorld();
        BlockPos oldPosition = turtle.getPosition();
        BlockPos newPosition = oldPosition.offset(direction);
        if (world.isAirBlock(newPosition.x, newPosition.y, newPosition.z)) {
            return TurtleCommandResult.failure("No block to inspect");
        }
        BlockLogic block = Helper.getBlockLogic(world, newPosition.x, newPosition.y, newPosition.z);
        int metadata = world.getBlockMetadata(newPosition.x, newPosition.y, newPosition.z);
        HashMap<String, Object> table = BlockData.fill(new HashMap(), block.id(), metadata, block.namespaceId());
        TurtleBlockEvent.Inspect event = new TurtleBlockEvent.Inspect(turtle, world, newPosition, block.id(), metadata, table);
        if (TurtleEvent.post(event)) {
            return TurtleCommandResult.failure(event.getFailureMessage());
        }
        return TurtleCommandResult.success(new Object[]{table});
    }
}

