/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.core;

import dan200.computercraft.ComputerCraft;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.ITurtleCommand;
import dan200.computercraft.api.turtle.TurtleAnimation;
import dan200.computercraft.api.turtle.TurtleCommandResult;
import dan200.computercraft.api.turtle.event.TurtleBlockEvent;
import dan200.computercraft.api.turtle.event.TurtleEvent;
import dan200.computercraft.shared.TurtlePermissions;
import dan200.computercraft.shared.peripheral.modem.wired.ItemCable;
import dan200.computercraft.shared.turtle.core.InteractDirection;
import dan200.computercraft.shared.util.BlockPos;
import dan200.computercraft.shared.util.DirectionUtil;
import javax.annotation.Nonnull;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.entity.TileEntityActivator;
import net.minecraft.core.block.entity.TileEntitySign;
import net.minecraft.core.enums.EnumBlockSoundEffectType;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemBoat;
import net.minecraft.core.item.ItemBucket;
import net.minecraft.core.item.ItemBucketEmpty;
import net.minecraft.core.item.ItemDye;
import net.minecraft.core.item.ItemEgg;
import net.minecraft.core.item.ItemSeeds;
import net.minecraft.core.item.ItemSign;
import net.minecraft.core.item.ItemSnowball;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.block.ItemBlock;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;

public class TurtlePlaceCommand
implements ITurtleCommand {
    private final InteractDirection direction;
    private final Object[] extraArguments;

    public TurtlePlaceCommand(InteractDirection direction, Object[] arguments) {
        this.direction = direction;
        this.extraArguments = arguments;
    }

    public static ItemStack deploy(@Nonnull ItemStack stack, ITurtleAccess turtle, Direction direction, Object[] extraArguments, String[] outErrorMessage) {
        Item item;
        BlockPos turtlePosition = turtle.getPosition();
        BlockPos position = turtlePosition.offset(direction);
        float hitX = 0.5f + (float)direction.getOffsetX() * 0.5f;
        float hitY = 0.5f + (float)direction.getOffsetY() * 0.5f;
        float hitZ = 0.5f + (float)direction.getOffsetZ() * 0.5f;
        if (Math.abs(hitY - 0.5f) < 0.01f) {
            hitY = 0.45f;
        }
        if (!((item = stack.getItem()) instanceof ItemBucket || item instanceof ItemBoat || item instanceof ItemBucketEmpty || item instanceof ItemEgg || item instanceof ItemSnowball || item instanceof ItemCable || item instanceof ItemSeeds || item instanceof ItemDye || TurtlePlaceCommand.canDeployOnBlock(stack, turtle, position, direction, true, outErrorMessage))) {
            return stack;
        }
        boolean placed = false;
        TileEntity existingTile = turtle.getWorld().getTileEntity(position.x, position.y, position.z);
        TileEntityActivator tileEntityActivator = new TileEntityActivator();
        tileEntityActivator.x = turtlePosition.x;
        tileEntityActivator.y = turtlePosition.y;
        tileEntityActivator.z = turtlePosition.z;
        tileEntityActivator.worldObj = turtle.getWorld();
        int oldStackSize = stack.stackSize;
        item.onUseByActivator(stack, tileEntityActivator, turtle.getWorld(), turtle.getWorld().rand, turtlePosition.x, turtlePosition.y, turtlePosition.z, (double)hitX, (double)hitY, (double)hitZ, direction);
        if (oldStackSize != stack.stackSize) {
            placed = true;
        }
        if (!placed && item instanceof ItemSign) {
            TurtlePlaceCommand.placeSign(stack, turtle.getWorld(), turtlePosition.x, turtlePosition.y, turtlePosition.z, direction.getSide(), turtle.getDirection());
        }
        if (oldStackSize != stack.stackSize) {
            placed = true;
        }
        if (placed && item instanceof ItemSign && extraArguments != null && extraArguments.length >= 1 && extraArguments[0] instanceof String) {
            World world = turtle.getWorld();
            TileEntity tile = world.getTileEntity(position.x, position.y, position.z);
            if (tile == null || tile == existingTile) {
                tile = world.getTileEntity(position.x, position.y, position.z);
            }
            if (tile instanceof TileEntitySign) {
                TileEntitySign signTile = (TileEntitySign)tile;
                String s2 = (String)extraArguments[0];
                String[] split = s2.split("\n");
                int firstLine = split.length <= 2 ? 1 : 0;
                for (int i = 0; i < 4; ++i) {
                    if (i >= firstLine && i < firstLine + split.length) {
                        if (split[i - firstLine].length() > 15) {
                            signTile.signText[i] = split[i - firstLine].substring(0, 15);
                            continue;
                        }
                        signTile.signText[i] = split[i - firstLine];
                        continue;
                    }
                    signTile.signText[i] = "";
                }
                signTile.setChanged();
            }
        }
        if (stack.stackSize == 0) {
            return null;
        }
        return stack.copy();
    }

    private static void placeSign(ItemStack itemstack, World world, int blockX, int blockY, int blockZ, Side side, Direction direction) {
        int sideHit = side.getOpposite().getId();
        if (world.getBlockMaterial(blockX, blockY, blockZ).isSolid()) {
            if (!world.canPlaceInsideBlock(blockX, blockY, blockZ)) {
                blockX += side.getOffsetX();
                blockY += side.getOffsetY();
                blockZ += side.getOffsetZ();
            }
            if (!world.getBlockMaterial(blockX + side.getOffsetX(), blockY + side.getOffsetY(), blockZ + side.getOffsetZ()).isSolid()) {
                sideHit = side.getId();
            }
            if (blockY >= 0 && blockY < world.getHeightBlocks() && Blocks.SIGN_POST_PLANKS_OAK.canPlaceBlockAt(world, blockX, blockY, blockZ)) {
                if (sideHit == Side.TOP.getId() || sideHit == Side.BOTTOM.getId()) {
                    world.playBlockSoundEffect(null, (double)((float)blockX + 0.5f), (double)((float)blockY + 0.5f), (double)((float)blockZ + 0.5f), Blocks.SIGN_POST_PLANKS_OAK, EnumBlockSoundEffectType.PLACE);
                    world.setBlockAndMetadataWithNotify(blockX, blockY, blockZ, Blocks.SIGN_POST_PLANKS_OAK.id(), MathHelper.floor((double)((double)((DirectionUtil.getRotationYaw(direction) + 180.0f) * 16.0f / 360.0f) + 0.5)) & 0xF);
                } else {
                    world.playBlockSoundEffect(null, (double)((float)blockX + 0.5f), (double)((float)blockY + 0.5f), (double)((float)blockZ + 0.5f), Blocks.SIGN_WALL_PLANKS_OAK, EnumBlockSoundEffectType.PLACE);
                    world.setBlockAndMetadataWithNotify(blockX, blockY, blockZ, Blocks.SIGN_WALL_PLANKS_OAK.id(), sideHit);
                }
                itemstack.consumeItem(null);
            }
        }
    }

    private static boolean canDeployOnBlock(ItemStack item, ITurtleAccess turtle, BlockPos position, Direction side, boolean allowReplaceable, String[] outErrorMessage) {
        if (position.getY() < 0 || position.getY() >= 256) {
            return false;
        }
        World world = turtle.getWorld();
        if (!(item.getItem() instanceof ItemBlock) && !(item.getItem() instanceof ItemSign)) {
            return false;
        }
        if (world.isAirBlock(position.x, position.y, position.z)) {
            return true;
        }
        if (ComputerCraft.turtlesObeyBlockProtection) {
            boolean editable;
            boolean bl = editable = allowReplaceable ? TurtlePermissions.isBlockEditable(world, position) : TurtlePermissions.isBlockEditable(world, position.offset(side));
            if (!editable) {
                if (outErrorMessage != null) {
                    outErrorMessage[0] = "Cannot place in protected area";
                }
                return false;
            }
        }
        return world.getBlockMaterial(position.x, position.y, position.z).isReplaceable();
    }

    @Override
    @Nonnull
    public TurtleCommandResult execute(@Nonnull ITurtleAccess turtle) {
        ItemStack stack = turtle.getInventory().getItem(turtle.getSelectedSlot());
        if (stack == null) {
            return TurtleCommandResult.failure("No items to place");
        }
        Direction direction = this.direction.toWorldDir(turtle);
        BlockPos coordinates = turtle.getPosition().offset(direction);
        TurtleBlockEvent.Place place = new TurtleBlockEvent.Place(turtle, turtle.getWorld(), coordinates, stack);
        if (TurtleEvent.post(place)) {
            return TurtleCommandResult.failure(place.getFailureMessage());
        }
        String[] errorMessage = new String[1];
        ItemStack remainder = TurtlePlaceCommand.deploy(stack, turtle, direction, this.extraArguments, errorMessage);
        if (remainder != stack) {
            turtle.getInventory().setItem(turtle.getSelectedSlot(), remainder);
            turtle.getInventory().setChanged();
            turtle.playAnimation(TurtleAnimation.WAIT);
            return TurtleCommandResult.success();
        }
        if (errorMessage[0] != null) {
            return TurtleCommandResult.failure(errorMessage[0]);
        }
        if (stack.getItem() instanceof ItemBlock) {
            return TurtleCommandResult.failure("Cannot place block here");
        }
        return TurtleCommandResult.failure("Cannot place item here");
    }
}

