/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.core;

import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.ITurtleCommand;
import dan200.computercraft.api.turtle.TurtleAnimation;
import dan200.computercraft.api.turtle.TurtleCommandResult;
import dan200.computercraft.api.turtle.event.TurtleEvent;
import dan200.computercraft.api.turtle.event.TurtleInventoryEvent;
import dan200.computercraft.shared.turtle.core.InteractDirection;
import dan200.computercraft.shared.util.BlockPos;
import dan200.computercraft.shared.util.InventoryUtil;
import dan200.computercraft.shared.util.ItemStorage;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.entity.EntityItem;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.player.inventory.container.Container;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.World;

public class TurtleSuckCommand
implements ITurtleCommand {
    private final InteractDirection direction;
    private final int quantity;

    public TurtleSuckCommand(InteractDirection direction, int quantity) {
        this.direction = direction;
        this.quantity = quantity;
    }

    @Override
    @Nonnull
    public TurtleCommandResult execute(@Nonnull ITurtleAccess turtle) {
        Direction side;
        Container inventory;
        BlockPos turtlePosition;
        BlockPos blockPosition;
        if (this.quantity == 0) {
            turtle.playAnimation(TurtleAnimation.WAIT);
            return TurtleCommandResult.success();
        }
        Direction direction = this.direction.toWorldDir(turtle);
        World world = turtle.getWorld();
        TurtleInventoryEvent.Suck event = new TurtleInventoryEvent.Suck(turtle, world, blockPosition = (turtlePosition = turtle.getPosition()).offset(direction), inventory = InventoryUtil.getInventory(world, blockPosition, side = direction.getOpposite()));
        if (TurtleEvent.post(event)) {
            return TurtleCommandResult.failure(event.getFailureMessage());
        }
        if (inventory != null) {
            ItemStack stack = InventoryUtil.takeItems(this.quantity, ItemStorage.wrap(inventory));
            if (stack == null) {
                return TurtleCommandResult.failure("No items to take");
            }
            ItemStack remainder = InventoryUtil.storeItems(stack, turtle.getItemHandler(), turtle.getSelectedSlot());
            if (remainder != null) {
                InventoryUtil.storeItems(remainder, ItemStorage.wrap(inventory));
            }
            if (remainder != stack) {
                turtle.playAnimation(TurtleAnimation.WAIT);
                return TurtleCommandResult.success();
            }
            return TurtleCommandResult.failure("No space for items");
        }
        AABB aabb = AABB.getPermanentBB((double)blockPosition.getX(), (double)blockPosition.getY(), (double)blockPosition.getZ(), (double)((double)blockPosition.getX() + 1.0), (double)((double)blockPosition.getY() + 1.0), (double)((double)blockPosition.getZ() + 1.0));
        List list = world.getEntitiesWithinAABB(EntityItem.class, aabb);
        if (list.isEmpty()) {
            return TurtleCommandResult.failure("No items to take");
        }
        for (EntityItem entity : list) {
            ItemStack remainder;
            ItemStack leaveStack;
            ItemStack storeStack;
            ItemStack stack = entity.item.copy();
            if (stack.stackSize > this.quantity) {
                storeStack = stack.splitStack(this.quantity);
                leaveStack = stack;
            } else {
                storeStack = stack;
                leaveStack = null;
            }
            if ((remainder = InventoryUtil.storeItems(storeStack, turtle.getItemHandler(), turtle.getSelectedSlot())) == storeStack) continue;
            if (remainder == null && leaveStack == null) {
                entity.remove();
            } else if (remainder == null) {
                entity.item = leaveStack;
            } else if (leaveStack == null) {
                entity.item = remainder;
            } else {
                leaveStack.stackSize += remainder.stackSize;
                entity.item = leaveStack;
            }
            world.playBlockEvent(1000, turtlePosition.x, turtlePosition.y, turtlePosition.z, 0);
            turtle.playAnimation(TurtleAnimation.WAIT);
            return TurtleCommandResult.success();
        }
        return TurtleCommandResult.failure("No space for items");
    }
}

