/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.inventory;

import dan200.computercraft.client.gui.FixedWidthFontRenderer;
import dan200.computercraft.client.gui.widgets.WidgetTerminal;
import dan200.computercraft.core.terminal.Terminal;
import dan200.computercraft.fabric.GLFWKeyboardManager;
import dan200.computercraft.shared.computer.core.ClientComputer;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.inventory.ContainerComputerBase;
import dan200.computercraft.shared.turtle.blocks.TileTurtle;
import dan200.computercraft.shared.turtle.inventory.MenuTurtle;
import java.util.UUID;
import net.minecraft.client.gui.container.ScreenContainerAbstract;
import net.minecraft.core.player.inventory.container.Container;
import net.minecraft.core.player.inventory.container.ContainerInventory;
import net.minecraft.core.player.inventory.menu.MenuAbstract;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class ScreenTurtle<T extends ContainerComputerBase>
extends ScreenContainerAbstract {
    public static final int PLAYER_START_Y = 134;
    public static final int TURTLE_START_X = 175;
    protected final ComputerFamily family;
    protected final ClientComputer computer;
    private final int termWidth;
    private final int termHeight;
    protected WidgetTerminal terminal;
    UUID glfwKeyCallbackId;
    UUID glfwCharCallbackId;

    public ScreenTurtle(T container, int termWidth, int termHeight, ContainerInventory inventoryplayer, TileTurtle tileentitydispenser) {
        super((MenuAbstract)new MenuTurtle((Container)inventoryplayer, tileentitydispenser));
        this.family = ((ContainerComputerBase)container).getFamily();
        this.computer = ((ContainerComputerBase)container).getClientComputer();
        this.termWidth = termWidth;
        this.termHeight = termHeight;
        this.xSize = 254;
        this.ySize = 217;
    }

    public void init() {
        super.init();
        this.terminal = new WidgetTerminal(this.mc, () -> this.computer, this.termWidth, this.termHeight, 0, 0, 0, 0);
        GLFWKeyboardManager.getInstance().removeKeyObserver(this.glfwKeyCallbackId);
        this.glfwKeyCallbackId = GLFWKeyboardManager.getInstance().addKeyObserver(this::glfwKeyCallback);
        GLFWKeyboardManager.getInstance().removeCharObserver(this.glfwCharCallbackId);
        this.glfwCharCallbackId = GLFWKeyboardManager.getInstance().addCharObserver(this::glfwCharCallback);
    }

    public void removed() {
        GLFWKeyboardManager.getInstance().removeKeyObserver(this.glfwKeyCallbackId);
        GLFWKeyboardManager.getInstance().removeCharObserver(this.glfwCharCallbackId);
    }

    public void glfwKeyCallback(long window, int key, int scancode, int action, int mods) {
        if (action == 0) {
            this.terminal.keyReleased(key, scancode, mods);
            return;
        }
        this.terminal.keyPressed(key, scancode, mods);
    }

    public void glfwCharCallback(long window, int codepoint) {
        this.terminal.charTyped((char)codepoint);
    }

    public void tick() {
        super.tick();
        this.terminal.update();
    }

    public void keyPressed(char eventCharacter, int eventKey, int mx, int my) {
        if (eventKey == Keyboard.KEY_ESCAPE) {
            this.mc.displayScreen(null);
        }
    }

    protected void drawGuiContainerBackgroundLayer(float f) {
        int slot;
        Terminal terminal;
        int j = (this.width - this.xSize) / 2;
        int k = (this.height - this.ySize) / 2;
        if (this.terminal != null) {
            int termPxWidth = this.terminal.getWidth();
            int termPxHeight = this.terminal.getHeight();
            int wrapperX = (this.width - termPxWidth) / 2;
            int wrapperY = (this.height - termPxHeight - 80) / 2;
            FixedWidthFontRenderer.drawEmptyTerminal(wrapperX - 1, wrapperY - 1, termPxWidth + 2, termPxHeight + 2);
            this.terminal.draw(wrapperX, wrapperY);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.family == ComputerFamily.ADVANCED) {
            this.mc.textureManager.loadTexture("/assets/computercraft/textures/gui/turtle_advanced.png").bind();
        } else {
            this.mc.textureManager.loadTexture("/assets/computercraft/textures/gui/turtle_normal.png").bind();
        }
        this.drawTexturedModalRect(j, k, 0, 0, this.xSize, this.ySize);
        Terminal terminal2 = terminal = this.computer != null ? this.computer.getTerminal() : null;
        if (terminal != null && (slot = terminal.getSelectedSlot()) >= 0) {
            int slotX = slot % 4;
            int slotY = slot / 4;
            this.drawTexturedModalRect(j + 175 - 2 + slotX * 18, k + 134 - 2 + slotY * 18, 0, 217, 24, 24);
        }
    }
}

