/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.items;

import com.mojang.nbt.tags.CompoundTag;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.shared.TurtleUpgrades;
import dan200.computercraft.shared.common.IColouredItem;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.items.ItemBlockComputerBase;
import dan200.computercraft.shared.turtle.blocks.TileTurtle;
import dan200.computercraft.shared.turtle.core.TurtleBrain;
import dan200.computercraft.shared.turtle.items.ITurtleItem;
import dan200.computercraft.shared.turtle.items.TurtleItemFactory;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumBlockSoundEffectType;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemBlockTurtle
extends ItemBlockComputerBase
implements ITurtleItem {
    public ItemBlockTurtle(@NotNull Block block) {
        super(block);
    }

    public void addToCreativeMenu(@Nonnull List<ItemStack> list) {
        ComputerFamily family = this.getFamily();
        list.add(this.create(-1, null, -1, null, null, 0, -1));
        TurtleUpgrades.getVanillaUpgrades().filter(x -> TurtleUpgrades.suitableForFamily(family, x)).map(x -> this.create(-1, null, -1, null, (ITurtleUpgrade)x, 0, -1)).forEach(list::add);
    }

    public ItemStack create(int id, String label, int colour, ITurtleUpgrade leftUpgrade, ITurtleUpgrade rightUpgrade, int fuelLevel, int overlay) {
        ItemStack stack = new ItemStack((Item)this);
        if (label != null) {
            stack.setCustomName(label);
        }
        CompoundTag tag = stack.getData();
        if (id >= 0) {
            tag.putInt("ComputerId", id);
        }
        IColouredItem.setColourBasic(stack, colour);
        if (fuelLevel > 0) {
            tag.putInt("Fuel", fuelLevel);
        }
        if (overlay != -1) {
            tag.putInt("Overlay", overlay);
        }
        if (leftUpgrade != null) {
            tag.putInt("LeftUpgrade", leftUpgrade.getUpgradeID());
        }
        if (rightUpgrade != null) {
            tag.putInt("RightUpgrade", rightUpgrade.getUpgradeID());
        }
        stack.setData(tag);
        return stack;
    }

    public String getTranslatedName(ItemStack itemStack) {
        I18n i18n = I18n.getInstance();
        String baseString = itemStack.getItemKey();
        ITurtleUpgrade left = this.getUpgrade(itemStack, TurtleSide.LEFT);
        ITurtleUpgrade right = this.getUpgrade(itemStack, TurtleSide.RIGHT);
        if (left != null && right != null) {
            return i18n.translateKeyAndFormat(baseString + ".upgraded_twice.name", new Object[]{i18n.translateKey(right.getUnlocalisedAdjective()), i18n.translateKey(left.getUnlocalisedAdjective())});
        }
        if (left != null) {
            return i18n.translateKeyAndFormat(baseString + ".upgraded.name", new Object[]{i18n.translateKey(left.getUnlocalisedAdjective())});
        }
        if (right != null) {
            return i18n.translateKeyAndFormat(baseString + ".upgraded.name", new Object[]{i18n.translateKey(right.getUnlocalisedAdjective())});
        }
        return i18n.translateKey(baseString + ".name");
    }

    @Override
    public ITurtleUpgrade getUpgrade(@Nonnull ItemStack stack, @Nonnull TurtleSide side) {
        CompoundTag tag = stack.getData();
        String key = side == TurtleSide.LEFT ? "LeftUpgrade" : "RightUpgrade";
        return tag.containsKey(key) ? TurtleUpgrades.get(tag.getInteger(key)) : null;
    }

    @Override
    public int getFuelLevel(@Nonnull ItemStack stack) {
        CompoundTag tag = stack.getData();
        return tag.containsKey("Fuel") ? tag.getInteger("Fuel") : 0;
    }

    @Override
    public int getOverlay(@Nonnull ItemStack stack) {
        CompoundTag tag = stack.getData();
        return tag.containsKey("Overlay") ? tag.getInteger("Overlay") : -1;
    }

    @Override
    public ItemStack withFamily(@Nonnull ItemStack stack, @Nonnull ComputerFamily family) {
        return TurtleItemFactory.create(this.getComputerID(stack), this.getLabel(stack), this.getColour(stack), family, this.getUpgrade(stack, TurtleSide.LEFT), this.getUpgrade(stack, TurtleSide.RIGHT), this.getFuelLevel(stack), this.getOverlay(stack));
    }

    public boolean onUseItemOnBlock(ItemStack stack, @Nullable Player player, World world, int x, int y, int z, Side side, double xPlaced, double yPlaced) {
        if (stack.stackSize <= 0) {
            return false;
        }
        if (!world.canPlaceInsideBlock(x, y, z)) {
            x += side.getOffsetX();
            y += side.getOffsetY();
            z += side.getOffsetZ();
        }
        if (y >= 0 && y < world.getHeightBlocks()) {
            if (world.canBlockBePlacedAt(this.block.id(), x, y, z, false, side) && stack.consumeItem(player)) {
                int meta = this.getPlacedBlockMetadata(player, stack, world, x, y, z, side, xPlaced, yPlaced);
                if (world.setBlockAndMetadataWithNotify(x, y, z, this.block.id(), meta)) {
                    if (player == null) {
                        this.block.onBlockPlacedOnSide(world, x, y, z, side, xPlaced, yPlaced);
                    } else {
                        this.block.onBlockPlacedByMob(world, x, y, z, side, (Mob)player, xPlaced, yPlaced);
                    }
                    world.playBlockSoundEffect((Entity)player, (double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), this.block, EnumBlockSoundEffectType.PLACE);
                    TileEntity entity = world.getTileEntity(x, y, z);
                    if (!(entity instanceof TileTurtle)) {
                        return false;
                    }
                    TileTurtle turtle = (TileTurtle)entity;
                    turtle.readDescription(stack.getData());
                    if (player != null) {
                        turtle.setOwningPlayer(player.uuid);
                    }
                    if (stack.getItem() instanceof ITurtleItem) {
                        int overlay;
                        ITurtleItem item = (ITurtleItem)stack.getItem();
                        for (TurtleSide turtleSide : TurtleSide.values()) {
                            turtle.getAccess().setUpgrade(turtleSide, item.getUpgrade(stack, turtleSide));
                        }
                        turtle.getAccess().setFuelLevel(item.getFuelLevel(stack));
                        int colour = item.getColour(stack);
                        if (colour != -1) {
                            turtle.getAccess().setColour(colour);
                        }
                        if ((overlay = item.getOverlay(stack)) != -1) {
                            ((TurtleBrain)turtle.getAccess()).setOverlay(overlay);
                        }
                    }
                    return true;
                }
                if (player == null || player.getGamemode().consumeBlocks()) {
                    ++stack.stackSize;
                }
            }
            return false;
        }
        return false;
    }
}

